// plugin/vue-renderer/render-compile.js
// idea taken from: https://lachlan-miller.me/articles/vue-3-pdf-customer-renderer

let startTime = performance.now()

import fs from 'fs'
import { srcPath, newComponentPath } from './copy-files.js' // creates new component folder and copies common files
import { provide, defineComponent, compile, createRenderer } from '../vuelib.js' // 'vue'
import { newDocument } from './element.js'
import { createNodeOps } from './nodeOps.js'
import { compileVueFile } from './compileVueFile.js'

const elementArr = JSON.parse(fs.readFileSync('./element-arr.json', 'utf8')).element
const compiledComponent = []
const ssr = false
compileVueFile('/Users/pasi/nc/nc-plugin/preference/form/core/', 'nc-list-form/nc-list-form.html', newComponentPath, ssr)
let runStartTime = performance.now()
elementArr.forEach(fileName => {
	compiledComponent.push(compileVueFile(srcPath, fileName, newComponentPath, ssr))
})
Promise.all(compiledComponent).then(ret => {
	const componentArr = ret.map(item => {
		if (item.default.render) {
			console.warn(`component ${item.default.name} has render -tag in default export`)
		}
		if (item.ssrRender) {
			item.default.ssrRender = item.ssrRender
		} else {
			item.default.render = item.render
		}
		return item.default
	})
	run(componentArr)
})

function run(componentArr) {
	const componentCreationTime = performance.now() - runStartTime
	runStartTime = performance.now()
	const stateRec = JSON.parse(fs.readFileSync('./state.json', 'utf8'))
	import('../core/nc-state.js').then(module => {
		// we need dynamic import because ../core/nc-state.js will be copiend from source and does not exist on file start
		let state = module.newState('nc-render', stateRec)
		state.rec.printing = true
		let html = fs.readFileSync('./page.html', 'utf8')
		html = html.replaceAll('v-show=', 'v-if=')

		const App = defineComponent({
			name: 'NcRender',
			// components: comp, // create later by app.component(), components must be in app, here is not enugh
			setup() {
				provide('state', state)
				// return Object.assign({ style: appStyle }, toRefs(state)) // this is old-browser compatible version of '...state'
				return { ...state, state } // ...toRefs(state) if state is reactive
			},
			render: compile(`${html}`)
		})

		function createApp(...args) {
			// Modelled after https://github.com/vuejs/vue-next/blob/master/packages/runtime-dom/src/index.ts#L61
			const nodeMap = []
			const nodeOps = createNodeOps(nodeMap) // createNodeOps generates nodeMap
			const renderer = createRenderer(nodeOps)
			const app = renderer.createApp(...args) // vue call
			const { mount } = app

			app.mount = doc => {
				const proxy = mount(doc)
				doc.nodeMap = nodeMap
				return proxy
			}
			return app
		}
		const app = createApp(App)
		for (const item of componentArr) {
			app.component(item.name, item)
		}
		const doc = newDocument()
		app.mount(doc) // this creates doc.nodeMap
		doc.nodeMap.shift() // The shift() method removes the first item of an array, we don't need first root
		if (doc.nodeMap.length > 0) {
			delete doc.nodeMap[0].parent
			// console.log('\nnodeMap raw', doc.nodeMap)

			const nodeMap = doc.nodeMap.map(item => {
				const ret = {}
				for (const key in item) {
					if (!key.startsWith('_') && key !== 'nodeMap') {
						ret[key] = item[key]
					}
				}
				if (item.__vnode && item.__vnode.props) {
					const item2 = item.__vnode.props
					ret.props = {}
					for (const key2 in item2) {
						if (item2[key2] != null && typeof item2[key2] !== 'function') {
							ret.props[key2] = item2[key2]
						}
					}
				}
				return ret
			})
		}
		runStartTime = performance.now() - runStartTime
		// console.log('\nnodeMap', doc.nodeMap)
		if (doc.nodeMap.length > 0) {
			let data = JSON.stringify(doc.nodeMap, null, 2)
			fs.writeFileSync('./page.json', data)
			console.log('* wrote file: ./page.json')
		}
		// renderToPDF(doc.doc.nodeMap)
		startTime = performance.now() - startTime

		const msg =
			`%c••• components create time: ` +
			(componentCreationTime / 1000).toFixed(4) +
			` seconds\n web page json create time: ` +
			(runStartTime / 1000).toFixed(4) +
			` seconds\n total time: ` +
			(startTime / 1000).toFixed(4) +
			` seconds •••\n`
		if (doc.nodeMap.length > 0) {
		}
		console.log(msg, 'font-weight: bold; font-style: italic;')
	})
}
