// plugin/vue-renderer/renderer/compileVueComponent.js
import { replaceContent } from './replace-content.js'
import { parse, compileScript, compileTemplate } from '../vuelib.js' // '@vue/compiler-sfc' // './vuelib.js'
import peg from '../core/nc-peg.js'

const jsStart = `
import { ref, computed, watchEffect, onBeforeMount, onMounted, onBeforeUpdate, onUpdated, onBeforeUnmount, onUnmounted, onActivated, onDeactivated, provide } from '/src/core/vue.js'
import { dt, message, nc, peg } from '/src/core/nc-dynamic-form.js'

`
let id = 10000

export function compileVueComponent(param) {
	let { fileName, js, html, pug, ssr, vuePath, style } = param
	vuePath = vuePath || '/src/core/vue.js'
	if (ssr !== true) {
		ssr = false
	}
	const fileNameVue = fileName + '.vue'
	let content
	if (html) {
		content = '<template>\n' + html + '</template>\n\n' + '<script setup>\n' + jsStart + js + '\n</script>\n'
	} else {
		content = js // .vue component from disk
	}
	const parsed = parse(content, { sourceMap: false, filename: fileNameVue })
	id++
	const script = compileScript(parsed.descriptor, { id: 'nc-script-' + id, filename: fileNameVue, sourceMap: false })
	const ret = {}
	if (parsed.descriptor.template) {
		let parsedHtml = parsed.descriptor.template.content
		if (parsed.descriptor.template.lang === 'pug') {
			if (!pug) {
				ret.error = 'pug is not defined, give it as param 4'
			} else {
				const pugOptions = {}
				const fn = pug.compile(parsedHtml, pugOptions)
				const pugLocals = {}
				parsedHtml = fn(pugLocals)
			}
		}
		id++
		// render = compile(parsed.descriptor.template.content) // works, but gives a function, not code as text
		const render = compileTemplate({
			sourceMap: false,
			id: 'nc-template-' + id,
			source: parsedHtml,
			filename: fileNameVue,
			ssr: ssr
		})
		ret.code = replaceContent(fileName, script.content + '\n\n// render code\n' + render.code, vuePath)
	}
	if (style) {
		ret.style = parsed.descriptor.styles
		return ret
	}
	return ret.code
}
