// plugin/vue-renderer/renderer/compileVueFile.js
import fs from 'fs'
import pug from 'pug'
import sass from 'sass'
import { compileStyle } from '../vuelib.js'
import { compileVueComponent } from './compileVueComponent.js'
import peg from '../core/nc-peg.js'

export function compileVueFile(srcPath, fileName, newComponentPath, ssr, sourceMap = false) {
	if (fs.existsSync(newComponentPath + fileName + '.js')) {
		fileName = newComponentPath + fileName + '.js'
	} else {
		console.log(`🚀 compileVueFile.js ~ creating file:`, newComponentPath + fileName + '.js')
		const vuePath = '/src/core/vue.js'
		let js, html
		if (fs.existsSync(srcPath + fileName)) {
			js = fs.readFileSync(srcPath + fileName.replace('.html', '2.js'), 'utf-8')
			html = fs.readFileSync(srcPath + fileName, 'utf-8')
		} else {
			js = fs.readFileSync(srcPath + fileName + '.vue', 'utf-8')
		}
		const ret = compileVueComponent({ fileName, js, html, pug, ssr, vuePath, style: true })
		const styleArr = []
		const scopedStyleArr = []
		for (const item of ret.style) {
			let css = item.content
			if (item.lang === 'scss' || item.lang === 'sass') {
				const result = sass.renderSync({ data: css })
				css = result.css.toString()
			}
			const style = compileStyle({ id: 'nc-style-' + id, source: css, filename: fileName })
			if (item.scoped) {
				scopedStyleArr.push(style.code)
			} else {
				styleArr.push(style.code)
			}
		}
		if (scopedStyleArr.length > 0) {
			console.log(`* component '${fileName}' scoped style:\n${scopedStyleArr}`)
			// TODO: add to ../component/core/nc-component-style.json
		}
		if (styleArr.length > 0) {
			console.log(`* component '${fileName}' style:\n${styleArr}`)
			// TODO: add to ../component/core/nc-component-style.json
		}
		const path = peg.parseBeforeLast(fileName, '/')
		if (path !== fileName && !fs.existsSync(newComponentPath + path)) {
			fs.mkdirSync(newComponentPath + path)
		}
		fileName = newComponentPath + fileName + '.js'
		fs.writeFileSync(fileName, ret.code)
		// console.log(`🚀 compileVueFile.js ~ created file:`, fileName)
	}
	/*
	// import(dataUri) does needs full path for access to existing files: `import { fn } from 'file:///${process.cwd()}/dyn-import-existing.js'; fn(10);`
	// https://2ality.com/2019/10/eval-via-import.html
	const dataUri = 'data:text/javascript;charset=utf-8,' + encodeURIComponent(code)
	const ret = await import(dataUri)
	*/
	const ret = import(fileName)
	console.log(`🚀 compileVueFile.js ~ imported file:`, fileName)
	return ret
}
