// plugin/vue-renderer/renderer/nodeOps.js

import { newTextNode, newElement } from './element.js'

function noop(fn) {
	console.error(`no-op: ${fn}`)
}

export function createNodeOps(nodeMap) {
	return {
		patchProp: (el, key, prevVal, nextVal) => {
			if (el && key && nextVal != null) {
				el[key] = nextVal
			}
		},
		insert: (child, parentNode) => {
			// (child, parentNode, anchor)
			if (parentNode.idx === 0) {
				nodeMap[parentNode.idx] = parentNode
			}
			if (child == null) {
				return
			}
			if (!(child.idx in nodeMap)) {
				nodeMap[child.idx] = child
			}
			parentNode.children.push(child.idx)
			child.parent = parentNode.idx
		},
		createElement: tag => {
			return newElement(tag)
		},
		createText: text => {
			if (text !== '') {
				return newTextNode(text)
			}
		},
		parentNode: () => {
			// (node)
			return null
		},
		createComment: () => {
			// if (text === '') return null
			return null
		},
		setText: () => noop('setText'),
		setElementText: () => noop('setElementText'),
		nextSibling: () => noop('nextSibling'),
		querySelector: () => noop('querySelector'),
		setScopeId: () => noop('setScopeId'),
		cloneNode: () => noop('cloneNode'),
		insertStaticContent: () => noop('insertStaticContent'),
		forcePatchProp: () => noop('forcePatchProp'),
		remove: () => noop('remove')
	}
}
