// form/nc/nc-document/nc-document.js
import { ref, computed, watchEffect, onBeforeMount, onMounted, onBeforeUpdate, onUpdated, onBeforeUnmount, onUnmounted, onActivated, onDeactivated, provide } from '/src/core/vue.js'
import { dt, message, nc, peg } from '/src/core/nc-dynamic-form.js'

// form/nc/nc-document/nc-document.js

export default {
  setup(__props, { expose }) {
  expose();


const rec = state.rec

let selectedDocType = ref('')
let pdfFrame = null
let pdfFullscreenFunc = null
let viewerNode = null
let viewer = null
let documentPassword = {}
const cache = {
	// cache last loaded document data, saves rest call
	// todo: cache all files in view?
	docData: null,
	docPath: '',
	docName: '',
	docType: '',
	applicationType: ''
}

function clearPreview(clearName) {
	if (clearName) {
		rec.document_name = ''
	}
	rec.pdf_style = 'display: none'
	if (viewerNode) {
		viewerNode.parentNode.removeChild(viewerNode)
		viewerNode = null
	}
	nc.setRec(state, 'pdf_data', '')
}

function fullScreen() {
	if (pdfFrame == null) {
		pdfFrame = document.getElementById('pdfjs-viewer-iframe')
		pdfFullscreenFunc = pdfFrame.requestFullscreen || pdfFrame.webkitRequestFullscreen || pdfFrame.mozRequestFullScreen
	}
	if (pdfFullscreenFunc) {
		pdfFullscreenFunc.call(pdfFrame)
	}
}

function closeFullpage() {
	rec.pdf_style = rec.pdf_style_preview
	rec.viewer_show_type = 'preview'
	documentRowClicked(rec.viewer_show_type)
}

function find() {
	nc.callServer(
		state,
		'form/nc/nc-document',
		{
			parameter: {
				connection: rec.connection,
				state: rec.document_state,
				product: rec.product
			}
		},
		() => {
			documentPassword = {}
			if (rec.select_row_on_load) {
				setTimeout(() => {
					const unselectOther = true
					const scroll = true
					nc.gridActivateRows(state, 'document', 1, scroll, unselectOther)
					documentRowClicked(rec.viewer_show_type)
				}, rec.select_row_timeout) // needs timeout for grid to be drawn
			}
		}
	)
}

function openCallback(ret, showType) {
	let docData = ret.rec && ret.rec.picture // must use re.rec because of keep_value in rest answer
	if (!docData) {
		// show error message?
		clearPreview()
		return
	}
	const docName = rec.document_name
	const docPath = rec.document_path
	let docType = rec.document_type.toLowerCase()
	let applicationType
	if (docType === 'txt' || docType === 'text') {
		docType = 'text'
		applicationType = 'text/plain'
	} else if (docType === 'md') {
		applicationType = 'text/markdown'
	} else if (docType === 'svg') {
		applicationType = 'image/svg+xml'
	} else if (docType === 'jpg') {
		docType = 'jpeg' // safari fix
	}
	if (docType === 'png' || docType === 'jpeg' || docType === 'gif') {
		applicationType = 'image/' + docType
	}
	if (!applicationType) {
		applicationType = 'application/' + docType
	}
	openDocument(showType, docName, docPath, docData, docType, applicationType)
}

function openDocument(showType, docName, docPath, docData, docType, applicationType) {
	message.clearMessage(state) // clear old errors on successful load
	if (!rec.open_type.includes(docType) && !rec.open_type.includes(applicationType)) {
		const txt = nc.l(`document type '${applicationType}' can not be opened`)
		message.alert(state, txt)
		return
	}
	/* const save = false
			if (save) {
				// or nc.isSafari()
				lib.saveFileAs(blob, docName)
			} else { */
	if (cache.docPath !== docPath) {
		cache.docData = docData
		cache.docPath = docPath
		cache.docName = docName
		cache.docType = docType
		cache.applicationType = applicationType
	}
	if (!viewer) {
		viewer = document.getElementById('nc-pdf-preview-canvas')
	}
	if (docType === 'pdf') {
		docData = nc.base64ToBinary(docData, applicationType)
		if (showType === 'fullpage') {
			rec.pdf_style = rec.pdf_style_fullpage
		} else {
			rec.pdf_style = rec.pdf_style_preview
		}
		nc.setRec(state, 'viewer_show_type', showType)
		nc.setRec(state, 'pdf_data', { data: docData, viewer_show_type: showType })
	} else {
		if (!rec.do_not_encode_type.includes(docType)) {
			docData = nc.base64toBlob(docData, applicationType)
		}
		if (viewer) {
			if (applicationType.startsWith('text')) {
				const node = document.createElement('textarea')
				node.className = 'nc-textarea'
				const textNode = document.createTextNode(docData)
				node.appendChild(textNode)
				// in textarea there must be width and min-height, replace the default style
				node.style = rec.pdf_style_preview.replace('max-width', 'width').replace('height', 'min-height') + ';margin: 0'
				viewerNode = viewer.parentNode.insertBefore(node, viewer)
			} else if (docType === 'svg') {
				// https://dev.to/benjaminblack/using-a-string-of-svg-as-an-image-source-8mo
				let docDataBlob = new Blob([docData], { type: 'image/svg+xml' })
				const url = URL.createObjectURL(docDataBlob)
				const node = document.createElement('img')
				node.addEventListener('load', () => URL.revokeObjectURL(url), { once: true })
				node.src = url
				node.style.cssText = rec.pdf_style_preview
				viewerNode = viewer.parentNode.insertBefore(node, viewer)
			} else if (docType === 'png' || docType === 'jpeg') {
				const url = URL.createObjectURL(docData)
				const node = new Image()
				node.addEventListener('load', () => URL.revokeObjectURL(url), { once: true })
				node.src = url
				node.style.cssText = rec.pdf_style_preview
				viewerNode = viewer.parentNode.insertBefore(node, viewer)
			} else {
				const url = URL.createObjectURL(docData)
				const win = window.open(url, docName) // , docName, '_blank')
				if (win) {
					win.addEventListener(
						'load',
						() => {
							URL.revokeObjectURL(url)
							win.document.title = docName // set opened window title so that is does not display "blob:..."
						},
						{ once: true }
					)
				} else if (docType !== 'pdf') {
					message.setInfo(state, 'Opening window for print failed, allow popup windows for this url to see report in browser.')
				}
			}
		}
	}
	// }
}

function passwordCallback(reason) {
	let answer
	if (reason === 1) {
		if (documentPassword[rec.document_name]) {
			return documentPassword[rec.document_name]
		}
		answer = prompt(nc.l(`Please enter pdf password`))
	} else {
		//if (reason === 2) {
		answer = prompt(nc.l(`Entered password was invalid, please enter pdf password`))
		/* } else {
				answer = prompt(nc.l(`Please enter pdf password (reason: ${reason})`)) */
	}
	documentPassword[rec.document_name] = answer
	return answer
}

function documentRowClicked(showType) {
	const arr = nc.gridActivatedRecordArr(state, 'document')
	clearPreview(false)
	if (arr && arr.length > 0) {
		const row = arr[0]
		if (row.kw.value === cache.docPath) {
			openDocument(showType, cache.docName, cache.docPath, cache.docData, cache.docType, cache.applicationType)
		} else {
			if (row.kw.value !== '') {
				selectedDocType.value = row.kw.field_type
				if (!selectedDocType.value) {
					// empty string
					selectedDocType.value = peg.parseAfterLast(row.kw.value, '.')
				}
				selectedDocType.value = selectedDocType.value.toLowerCase()
				const param = {
					connection: rec.connection,
					state: rec.document_state,
					encode: !rec.do_not_encode_type.includes(selectedDocType.value),
					document_name: row.kw.info,
					document_path: row.kw.value,
					document_type: selectedDocType.value,
					max_file_size_kb: rec.max_file_size_kb
				}
				nc.callServer(state, 'form/nc/nc-document', { parameter: param }, ret => {
					return openCallback(ret, showType)
				})
			}
		}
	}
}

clearPreview()
if (rec.product !== '') {
	find()
}


const __returned__ = { rec, selectedDocType, pdfFrame, pdfFullscreenFunc, viewerNode, viewer, documentPassword, cache, clearPreview, fullScreen, closeFullpage, find, openCallback, openDocument, passwordCallback, documentRowClicked, ref, computed, watchEffect, onBeforeMount, onMounted, onBeforeUpdate, onUpdated, onBeforeUnmount, onUnmounted, onActivated, onDeactivated, provide, dt, message, nc, peg }
Object.defineProperty(__returned__, '__isScriptSetup', { enumerable: false, value: true })
return __returned__
}

}

// render code
import { createCommentVNode as _createCommentVNode, createTextVNode as _createTextVNode, resolveComponent as _resolveComponent, withCtx as _withCtx, createVNode as _createVNode, toDisplayString as _toDisplayString, createElementVNode as _createElementVNode, vShow as _vShow, withDirectives as _withDirectives, normalizeStyle as _normalizeStyle, openBlock as _openBlock, createBlock as _createBlock, Fragment as _Fragment, createElementBlock as _createElementBlock } from '/src/core/vue.js'

const _hoisted_1 = /*#__PURE__*/_createTextVNode("Documents")
const _hoisted_2 = /*#__PURE__*/_createTextVNode("Fullscreen")
const _hoisted_3 = /*#__PURE__*/_createTextVNode("Close")
const _hoisted_4 = /*#__PURE__*/_createTextVNode("Product")
const _hoisted_5 = /*#__PURE__*/_createTextVNode("Name")
const _hoisted_6 = /*#__PURE__*/_createTextVNode("Viewer...")
const _hoisted_7 = /*#__PURE__*/_createTextVNode("Find")

export function render(_ctx, _cache) {
  const _component_nc_translate = _resolveComponent("nc-translate")
  const _component_nc_header = _resolveComponent("nc-header")
  const _component_nc_col = _resolveComponent("nc-col")
  const _component_nc_icon = _resolveComponent("nc-icon")
  const _component_nc_button = _resolveComponent("nc-button")
  const _component_nc_row = _resolveComponent("nc-row")
  const _component_nc_label = _resolveComponent("nc-label")
  const _component_nc_input = _resolveComponent("nc-input")
  const _component_nc_grid = _resolveComponent("nc-grid")
  const _component_nc_pdf_preview = _resolveComponent("nc-pdf-preview")
  const _component_nc_pdf_viewer = _resolveComponent("nc-pdf-viewer")
  const _component_nc_form = _resolveComponent("nc-form")

  return (_openBlock(), _createElementBlock(_Fragment, null, [
    _createCommentVNode(" form/nc/nc-document/nc-document.html "),
    _createVNode(_component_nc_form, { id: "nc-document" }, {
      default: _withCtx(() => [
        _createVNode(_component_nc_row, null, {
          default: _withCtx(() => [
            _createVNode(_component_nc_col, { width: "3/10" }, {
              default: _withCtx(() => [
                _createVNode(_component_nc_header, { size: "medium" }, {
                  default: _withCtx(() => [
                    _createVNode(_component_nc_translate, { model: "hdr.header" }, {
                      default: _withCtx(() => [
                        _hoisted_1
                      ]),
                      _: 1 /* STABLE */
                    })
                  ]),
                  _: 1 /* STABLE */
                })
              ]),
              _: 1 /* STABLE */
            }),
            _createVNode(_component_nc_col, {
              class: "nc-center-h",
              width: "4/10"
            }, {
              default: _withCtx(() => [
                _createElementVNode("div", null, _toDisplayString(_ctx.rec.document_name), 1 /* TEXT */)
              ]),
              _: 1 /* STABLE */
            }),
            _withDirectives(_createVNode(_component_nc_col, {
              class: "nc-end-h",
              width: "auto"
            }, {
              default: _withCtx(() => [
                _createVNode(_component_nc_button, {
                  style: {"width":"8em"},
                  onClick: _ctx.fullScreen
                }, {
                  default: _withCtx(() => [
                    _createVNode(_component_nc_icon, { icon: "arrows-alt" }),
                    _createVNode(_component_nc_translate, { model: "hdr.fullscreen" }, {
                      default: _withCtx(() => [
                        _hoisted_2
                      ]),
                      _: 1 /* STABLE */
                    })
                  ]),
                  _: 1 /* STABLE */
                }, 8 /* PROPS */, ["onClick"]),
                _createVNode(_component_nc_button, {
                  class: "nc-end-h",
                  primary: "primary",
                  style: {"width":"8em"},
                  onClick: _ctx.closeFullpage
                }, {
                  default: _withCtx(() => [
                    _createVNode(_component_nc_icon, { icon: "times" }),
                    _createVNode(_component_nc_translate, { model: "hdr.close" }, {
                      default: _withCtx(() => [
                        _hoisted_3
                      ]),
                      _: 1 /* STABLE */
                    })
                  ]),
                  _: 1 /* STABLE */
                }, 8 /* PROPS */, ["onClick"])
              ]),
              _: 1 /* STABLE */
            }, 512 /* NEED_PATCH */), [
              [_vShow, _ctx.rec.viewer_show_type === "fullpage"]
            ])
          ]),
          _: 1 /* STABLE */
        }),
        _withDirectives(_createVNode(_component_nc_row, null, {
          default: _withCtx(() => [
            _createVNode(_component_nc_col, { width: "3/20" }, {
              default: _withCtx(() => [
                _createVNode(_component_nc_label, { model: "hdr.product_id" }, {
                  default: _withCtx(() => [
                    _hoisted_4
                  ]),
                  _: 1 /* STABLE */
                })
              ]),
              _: 1 /* STABLE */
            }),
            _createVNode(_component_nc_col, {
              class: "nc-padding-right",
              width: "4/20"
            }, {
              default: _withCtx(() => [
                _createVNode(_component_nc_input, { model: "rec.product" })
              ]),
              _: 1 /* STABLE */
            }),
            _createVNode(_component_nc_col, { width: "3/20" }, {
              default: _withCtx(() => [
                _createVNode(_component_nc_label, { model: "hdr.product_name" }, {
                  default: _withCtx(() => [
                    _hoisted_5
                  ]),
                  _: 1 /* STABLE */
                })
              ]),
              _: 1 /* STABLE */
            }),
            _createVNode(_component_nc_col, {
              class: "nc-padding-right",
              width: "auto"
            }, {
              default: _withCtx(() => [
                _createVNode(_component_nc_input, {
                  disabled: "disabled",
                  model: "rec.product_name"
                })
              ]),
              _: 1 /* STABLE */
            }),
            _createVNode(_component_nc_col, {
              class: "nc-end-h",
              width: "auto"
            }, {
              default: _withCtx(() => [
                _createVNode(_component_nc_col, {
                  class: "nc-end-h",
                  width: "auto"
                }, {
                  default: _withCtx(() => [
                    _createVNode(_component_nc_button, {
                      disabled: _ctx.selectedDocType !== "pdf",
                      style: {"width":"8em"},
                      onClick: _cache[0] || (_cache[0] = $event => (_ctx.documentRowClicked("fullpage")))
                    }, {
                      default: _withCtx(() => [
                        _createVNode(_component_nc_translate, { model: "hdr.open_viewer" }, {
                          default: _withCtx(() => [
                            _hoisted_6
                          ]),
                          _: 1 /* STABLE */
                        })
                      ]),
                      _: 1 /* STABLE */
                    }, 8 /* PROPS */, ["disabled"])
                  ]),
                  _: 1 /* STABLE */
                }),
                _createVNode(_component_nc_col, {
                  class: "nc-end-h",
                  width: "auto"
                }, {
                  default: _withCtx(() => [
                    _createVNode(_component_nc_button, {
                      name: "doc_print",
                      primary: "primary",
                      style: {"width":"8em"},
                      onClick: _ctx.find
                    }, {
                      default: _withCtx(() => [
                        _createVNode(_component_nc_translate, { model: "hdr.find" }, {
                          default: _withCtx(() => [
                            _hoisted_7
                          ]),
                          _: 1 /* STABLE */
                        })
                      ]),
                      _: 1 /* STABLE */
                    }, 8 /* PROPS */, ["onClick"])
                  ]),
                  _: 1 /* STABLE */
                })
              ]),
              _: 1 /* STABLE */
            }),
            _createVNode(_component_nc_row, { class: "nc-padding-bottom" }, {
              default: _withCtx(() => [
                _createVNode(_component_nc_grid, {
                  id: "document",
                  model: "grid.document",
                  style: {"width":"100%","height":"18.3em"},
                  onGridRowClicked: _cache[1] || (_cache[1] = $event => (_ctx.documentRowClicked("preview")))
                })
              ]),
              _: 1 /* STABLE */
            }),
            _withDirectives(_createVNode(_component_nc_row, null, {
              default: _withCtx(() => [
                _createVNode(_component_nc_pdf_preview, {
                  passwordCallback: _ctx.passwordCallback,
                  src: _ctx.rec.pdf_data,
                  style: _normalizeStyle(_ctx.rec.pdf_style),
                  id: "nc-pdf-preview-canvas"
                }, null, 8 /* PROPS */, ["passwordCallback", "src", "style"])
              ]),
              _: 1 /* STABLE */
            }, 512 /* NEED_PATCH */), [
              [_vShow, _ctx.rec.viewer_show_type === "preview"]
            ])
          ]),
          _: 1 /* STABLE */
        }, 512 /* NEED_PATCH */), [
          [_vShow, _ctx.rec.viewer_show_type !== "fullpage"]
        ]),
        (_ctx.rec.viewer_show_type === "fullpage" || _ctx.rec.viewer_show_type === "preview-full")
          ? (_openBlock(), _createBlock(_component_nc_row, { key: 0 }, {
              default: _withCtx(() => [
                _createVNode(_component_nc_pdf_viewer, {
                  passwordCallback: _ctx.passwordCallback,
                  src: _ctx.rec.pdf_data,
                  style: {"width":"100%","height":"calc(100vh - 8em)"}
                }, null, 8 /* PROPS */, ["passwordCallback", "src"])
              ]),
              _: 1 /* STABLE */
            }))
          : _createCommentVNode("v-if", true)
      ]),
      _: 1 /* STABLE */
    })
  ], 2112 /* STABLE_FRAGMENT, DEV_ROOT_FRAGMENT */))
}