// form/core/nc-define/nc-database-editor/nc-database-editor.js

const rec = state.rec
let selectedRow = null
let externalSelectedRow = null

function loadCallback() {
	let arr
	const grid = state.grid.field
	const extGrid = state.grid.external_field
	let fieldData = []
	// debugger
	addField(fieldData, rec.table_prf.field, 'field')
	if (rec.table_prf.default_field) {
		addField(fieldData, rec.table_prf.default_field.default_field, 'default field')
		addField(fieldData, rec.table_prf.default_field.extra_field, 'default field')
	}
	addField(fieldData, rec.table_prf.extra_field, 'extra field')

	let extFieldData = []
	addField(extFieldData, rec.external_table_prf.field, 'field')
	if (rec.external_table_prf.default_field) {
		addField(extFieldData, rec.table_prf.default_field.default_field, 'default field')
		addField(extFieldData, rec.table_prf.default_field.extra_field, 'default field')
	}
	addField(extFieldData, rec.external_table_prf.extra_field, 'extra field')

	extFieldData.forEach(item => {
		setLocalField(fieldData, item)
	})

	arr = rec.group_prf.group.map(item => {
		return { show: item.table_name, value: item.table_name }
	})
	state.arr.table = arr.sort(nc.dynamicSort(['show', '>']))

	arr = rec.external_group_prf.group.map(item => {
		return { show: item.table_name, value: item.table_name }
	})
	state.arr.external_table = arr.sort(nc.dynamicSort(['show', '>']))

	grid.data = fieldData // first load needs this, nc.grid.dataChanged() is empty function before grid has been created
	extGrid.data = extFieldData
	setData('local_data', 0)
	setData('external_data', 0)
	nc.grid.dataChanged(grid, grid.data)
	nc.grid.dataChanged(extGrid, extGrid.data)
	nc.grid.redrawRows(state, 'field')
	nc.grid.redrawRows(state, 'external_field')
	nc.grid.activateRows(state, 'local_data', 1)
	nc.grid.activateRows(state, 'external_data', 1)
	selectedRow = null
	externalSelectedRow = null
}
loadCallback()

function setLocalField(data, externalRec) {
	const localRec = nc.findRecFromArr(data, 'field_name', externalRec.local_field)
	if (localRec) {
		localRec.local_field = externalRec.field_name
		externalRec.state = 'match'
		localRec.state = 'match'
	}
}

function addExampleData(arr, data, exampleData, prefix) {
	if (!prefix) {
		prefix = ''
	} else if (prefix.length > 0) {
		const lastChar = prefix.substring(prefix.length - 1)
		if (lastChar !== '.') {
			prefix = prefix + '.'
		}
	}
	for (const fieldName in exampleData) {
		const value = exampleData[fieldName]
		let rec =
			nc.findRecFromArr(data, 'field_name', prefix + fieldName) ||
			nc.findRecFromArr(data, 'field_name', 'json_data.' + prefix + fieldName) ||
			nc.findRecFromArr(arr, 'field_name', prefix + fieldName) ||
			nc.findRecFromArr(arr, 'field_name', 'json_data.' + prefix + fieldName)
		if (rec && fieldName !== 'json_data') {
			rec.example_data = value
		} else {
			rec =
				nc.findRecFromArr(data, 'local_field', prefix + fieldName) ||
				nc.findRecFromArr(data, 'local_field', 'json_data.' + prefix + fieldName)
			if (rec && fieldName !== 'json_data') {
				rec.example_data = value
			}
			const type = typeof value
			if (type === 'string') {
				type === 'text'
			} else if (type === 'number') {
				type === 'double'
			}
			const item = {
				field_name: prefix + fieldName,
				field_type: type,
				type: 'data field',
				state: '',
				example_data: value,
				info: 'created from example data'
			}
			if (type === 'object' && exampleData[0]) {
				addExampleData(arr, data, exampleData[0], prefix.substring(0, prefix.length - 1) + '[1]')
			} else {
				if (fieldName !== 'json_data') {
					// add json_data separately to the end or arrays after normal data fields, with another call to this method
					arr.push(item)
					if (type === 'object') {
						addExampleData(arr, data, value, prefix + fieldName)
					}
				}
			}
		}
	}
}

function setExampleData(data, exampleData, prefix) {
	let arr = []
	addExampleData(arr, data, exampleData, prefix)
	arr = arr.sort(nc.dynamicSort(['field_name', '>']))
	arr.forEach(item => {
		data.push(item)
	})
}

function addField(data, newArr, type) {
	if (newArr) {
		let arr = Object.assign([], newArr) // do not sort original array
		arr = arr.sort(nc.dynamicSort(['field_name', '>']))
		arr.forEach(item => {
			item.type = type
			data.push(item)
		})
	}
}

function findTable(arr, table, option) {
	let rec = arr.find(item => item.table_name === table)
	if (!rec && option === 'start') {
		rec = arr.find(item => peg.parseBefore(item.table_name, '-') === table)
	}
	return rec
}

function dropdown(action) {
	let tablePathRec, extTablePathRec, tableRectype
	if (action === 'external table') {
		tablePathRec = findTable(rec.group_prf.group, rec.external_table)
		if (tablePathRec == null) {
			tablePathRec = findTable(rec.group_prf.group, peg.parseBefore(rec.external_table, '-'))
		}
	}
	if (tablePathRec == null) {
		tablePathRec = findTable(rec.group_prf.group, rec.table)
		if (action === 'local table') {
			extTablePathRec = findTable(rec.external_group_prf.group, rec.table, 'start')
		}
	}
	if (extTablePathRec == null) {
		extTablePathRec = findTable(rec.external_group_prf.group, rec.external_table)
	}
	if (peg.parseBefore(extTablePathRec.table_name, '-') === tablePathRec.table_name) {
		tableRectype = extTablePathRec.table_name
	} else {
		tableRectype = tablePathRec.table_name
	}
	const recParam = {
		connection: rec.connection,
		table: tablePathRec.table_name,
		table_path: tablePathRec.group,
		table_rectype: tableRectype,
		external_table: extTablePathRec.table_name,
		external_table_path: extTablePathRec.group
	}
	rec.table = recParam.table
	const callParam = {
		name: rec.name,
		parameter: {
			rec: recParam
		},
		return: {
			rec: 'rec',
			grid: 'form/core/nc-define/nc-database-editor/grid.json'
		}
	}
	nc.callServer(state, 'query', callParam, loadCallback)
}

function gridContextMenu() {
	debugger
}

function setData(area, rowIndex) {
	let targetArea, fieldData, exampleData
	if (area === 'local_data') {
		targetArea = 'field'
		fieldData = state.grid.field.data
		exampleData = state.grid.local_data.data
	} else if (area === 'external_data') {
		targetArea = 'external_field'
		fieldData = state.grid.external_field.data
		exampleData = state.grid.external_data.data
	}
	const idx = nc.recordArrayIndex(fieldData, 'type', 'data field')
	if (idx > 0) {
		fieldData.length = idx - 1
	}
	exampleData = exampleData[rowIndex]
	if (exampleData) {
		setExampleData(fieldData, exampleData) // setExampleData(fieldData, exampleData, 'no-json-prefix')
		if (exampleData.json_data) {
			setExampleData(fieldData, exampleData.json_data, 'json_data') // setExampleData(fieldData, exampleData, 'no-json-prefix')
		}
	}
	const dataRec = state.grid[area].data[rowIndex]
	const grid = state.grid[targetArea]
	if (dataRec) {
		let item
		for (let index = 0; index < grid.data.length; index++) {
			item = grid.data[index]
			if (item.field_name && item.example_data == null) {
				const val = nc.recData(dataRec, item.field_name)
				item.example_data = val != null ? val : null
			}
			item.idx = index + 1
		}
	}
	nc.grid.dataChanged(grid, fieldData)
	// nc.grid.redrawRows(state, targetArea)
}

function otherArea(area) {
	if (area === 'field') {
		return 'external_field'
	}
	return 'field'
}

function selectMatchField(area, rowIndex) {
	if (area === 'external_field') {
		externalSelectedRow = rowIndex
	} else if (area === 'field') {
		selectedRow = rowIndex
	}
	const dataRec = state.grid[area].data[rowIndex]
	const area2 = otherArea(area)
	if (dataRec.local_field) {
		const localRec = nc.findRecFromArr(state.grid[area2].data, 'field_name', dataRec.local_field)
		if (localRec) {
			nc.grid.activateRows(state, area2, localRec.idx)
		}
	}
}

function matchField() {
	if (selectedRow == null || externalSelectedRow == null) return
	const extrnalRec = state.grid['external_field'].data[externalSelectedRow]
	const localRec = state.grid['field'].data[selectedRow]
	extrnalRec.local_field = localRec.field_name
	localRec.local_field = extrnalRec.field_name
	extrnalRec.state = 'match'
	localRec.state = 'match'
	let toIndex
	if (extrnalRec.type === 'data field') {
		const extFieldArr = rec.external_table_prf.field
		extFieldArr.push(extrnalRec)
		toIndex = extFieldArr.length
		extrnalRec.field_name = peg.parseAfter(extrnalRec.field_name, 'json_data.')
		extrnalRec.type = 'field'
		extrnalRec.idx = toIndex
		const extGrid = state.grid.external_field
		const arr = extGrid.data
		arr.splice(externalSelectedRow, 1) // remove data field -row
		arr.splice(toIndex - 1, 0, extrnalRec) // add field -row
		for (let index = 0; index < arr.length; index++) {
			const item = arr[index]
			item.idx = index + 1
		}
		nc.grid.dataChanged(extGrid, arr)
		nc.grid.activateRows(state, 'external_field', toIndex)
	}
	nc.grid.redrawRows(state, 'field')
	nc.grid.redrawRows(state, 'external_field')
}

function gridRowClicked(area, rowIndex, selected, event) {
	console.log(`🚀 ~ file: nc-database-editor.js ~ gridRowClicked ~ event`, event)
	if (selected) {
		if (area === 'local_data' || area === 'external_data') {
			setData(area, rowIndex)
		} else if (area === 'field' || area === 'external_field') {
			selectMatchField(area, rowIndex)
		}
	}
}

function gridRowDoubleClicked(area, rowIndex, event) {
	gridRowClicked(area, rowIndex, 'selected', event)
}

function setNewChangeRecord(gridData, dataRec, rowIndex) {
	// TODO: unique find by field type unique or primary key, not field_name
	// TODO: check allowed values from field preferece
	if (dataRec.per && dataRec.field_name != null) {
		let idx = nc.recordArrayIndexLowerCase(gridData, 'field_name', dataRec.field_name)
		if (idx === rowIndex) {
			idx = nc.recordArrayIndexLowerCase(gridData, 'field_name', dataRec.field_name, idx + 1)
		}
		if (idx >= 0 || dataRec.field_name === '') {
			if (dataRec.changeRecord) {
				dataRec.changeRecord.duplicate = idx + 1
			} else {
				dataRec.changeRecord = { duplicate: idx + 1 }
			}
		} else if (dataRec.changeRecord && dataRec.changeRecord.duplicate != null) {
			delete dataRec.changeRecord.duplicate
		}
	}
}

function setChangeRecord(data, colId, oldValue, newValue) {
	if (data.changeRecord && data.changeRecord[colId] === newValue) {
		delete data.changeRecord[colId]
		if (nc.isEmptyObject(data.changeRecord)) {
			delete data.changeRecord
		}
	} else if (oldValue !== newValue) {
		if (data.changeRecord == null) {
			data.changeRecord = { [colId]: oldValue }
		} else if (data.changeRecord[colId] == null && oldValue !== newValue) {
			data.changeRecord[colId] = oldValue
		}
	}
}

function clearChangeRecord(data) {
	data.forEach(item => {
		delete item.changeRecord
		if (item.default_value === '') {
			delete item.default_value
		}
	})
}

function gridCellValueChanged(area, node, data, newValue, oldValue, colId, rowIndex) {
	const gridData = state.grid[area].data
	setNewChangeRecord(gridData, data, rowIndex) // need to set value before cleaned
	if (typeof newValue === 'string') {
		const cleaned = peg.cleanBeforeAfterDoubleSpace(newValue)
		if (cleaned !== newValue) {
			newValue = cleaned
			nc.setRecData(data, colId, newValue)
			setNewChangeRecord(gridData, data, rowIndex)
		}
	}
	setChangeRecord(data, colId, oldValue, newValue)
	nc.grid.refereshCells(state, area, node)
}

function cleanSaveRec(item) {
	delete item.changeRecord
	delete item.idx
	delete item.type
	delete item.state
	delete item.example_data
}

function save() {
	const field = nc.clone(rec.table_prf.field).map(item => {
		cleanSaveRec(item)
		delete item.local_field // no local_field in local table
		return item
	})
	const extraField = nc.clone(rec.table_prf.extra_field).map(item => {
		cleanSaveRec(item)
		delete item.local_field
		return item
	})
	const externalField = nc.clone(rec.external_table_prf.field).map(item => {
		cleanSaveRec(item)
		return item
	})
	const param = {
		connection: rec.connection,
		table: rec.table,
		table_path: rec.table_path,
		field: field,
		extra_field: extraField,
		external_table: rec.external_table,
		external_table_path: rec.external_table_path,
		external_field: externalField
	}
	nc.callServer(
		state,
		'save',
		{
			run: [{ function: 'nc-database-editor.saveTablePreference', parameter: [param], result: 'info' }]
		},
		() => {
			clearChangeRecord(state.grid.field.data)
			clearChangeRecord(state.grid.external_field.data)
			nc.grid.redrawRows(state, 'field')
			nc.grid.redrawRows(state, 'external_field')
		}
	)
}
