// form/nc/nc-storage/nc-storage.js
// form/nc/nc-storage/init.json

const unselectOther = true
const productCount = ref(0)
const materialCount = ref(0)
const workCount = ref(0)
const selectedProductCount = ref(0)
const selectedMaterialCount = ref(0)
const selectedWorkCount = ref(0)
let selectedProductIdx = []
let selectedMaterialIdx = []
let activatedMaterialIdx = []
let selectedWorkIdx = []
let activatedWorkIdx = []
let productArr = []
let productionOrderArr = []
let materialArr = []
let workArr = []
let productKey = {}
let productionOrderKey = {}
let productMaterialKey = {}

// nc-svg-map

/* let workloads = ref(['FINISHING', 'METAL', 'UPHOLSTERY', 'CUSHION', 'CANOPY', 'PREWORK', 'CUTTING', 'ZIPPER'])
		let racks = ref([
			'warehouse14',
			'warehouse13',
			'warehouse12',
			'warehouse11',
			'warehouse1',
			'Metalwarehouse',
			'Uphosterywarehouse1',
			'Uphosterywarehouse2',
			'Outgoing_warehouse',
			'Finishingwarehouse',
			'Cuttingwarehouse'
		]) */
let mapSelected = ref([])
let mapHover = ref([])
function mapToggleSelected(param) {
	console.debug('map click', param.id, param.event)
	const i = mapSelected.value.indexOf(param.id)
	if (i === -1) mapSelected.value.push(param.id)
	else mapSelected.value.splice(i, 1)
}
function mapDoubleClick(param) {
	console.debug('map double click', param.id, param.event)
}
// nc-svg-map end

function setSelectedWork(materialIdxArr) {
	selectedWorkIdx = workArr
		.filter(prwo => {
			if (prwo.calc.material_idx == null) return false
			if (state.rec.only_material_phases === true && prwo.calc.used_material_idx == null) return false
			const idx = materialIdxArr.findIndex(matIdx => {
				if (state.rec.only_material_phases === true && !prwo.calc.used_material_idx.includes(matIdx)) return false
				if (!prwo.calc.material_idx.includes(matIdx)) return false
				return true
			})
			return idx >= 0
		})
		.map(prwo => prwo.idx)
	if (state.rec.only_material_phases === true) {
		activatedWorkIdx = selectedWorkIdx
	} else {
		activatedWorkIdx = workArr
			.filter(prwo => {
				if (prwo.calc.used_material_idx == null) return false
				if (!selectedWorkIdx.includes(prwo.idx)) return false
				const idx = materialIdxArr.findIndex(matIdx => {
					if (prwo.calc.used_material_idx.includes(matIdx)) return true
					return false
				})
				return idx >= 0
			})
			.map(prwo => prwo.idx)
	}
}

function setSelectedProduct(materialIdx) {
	const productIdx = materialIdx.map(idx => {
		return materialArr[idx - 1].product_idx // indexes are 1 based
	})
	setTimeout(() => {
		nc.grid.activateRows(state, 'product', productIdx, 'scroll-last', unselectOther)
	}, 0)
}

function setSelectedMaterialIdx() {
	const selectedWorkNumber = materialArr.filter(prma => activatedMaterialIdx.includes(prma.idx)).map(prma => prma.work_number_id)
	selectedMaterialIdx = materialArr.filter(prma => selectedWorkNumber.includes(prma.work_number_id)).map(prma => prma.idx)
}

function setFilterArr(selectedItemArr, area) {
	if (area === 'all') {
		selectedProductCount.value = productArr.length
		selectedMaterialCount.value = materialArr.length
		selectedWorkCount.value = workArr.length
		selectedMaterialIdx = materialArr.map(prma => prma.idx)
		activatedMaterialIdx = []
		selectedWorkIdx = workArr.map(prwo => prwo.idx)
		activatedWorkIdx = []
	} else {
		if (area === 'product') {
			if (selectedItemArr.length === 0) {
				setFilterArr(selectedItemArr, 'all')
			} else {
				selectedProductIdx = selectedItemArr.map(prod => prod.idx)
				activatedMaterialIdx = materialArr.filter(prma => selectedProductIdx.includes(prma.calc.product_idx)).map(prma => prma.idx)
				setSelectedMaterialIdx()
				setSelectedWork(activatedMaterialIdx)
			}
			setTimeout(() => {
				nc.grid.activateRows(state, 'product_material', activatedMaterialIdx, 'scroll-last', unselectOther)
				nc.grid.activateRows(state, 'product_work', activatedWorkIdx, 'scroll-last', unselectOther)
			}, 0)
		} else if (area === 'product_material') {
			if (selectedItemArr.length === 0) {
				activatedMaterialIdx = []
				selectedWorkIdx = workArr.map(prwo => prwo.idx)
				activatedWorkIdx = []
			} else {
				activatedMaterialIdx = selectedItemArr.map(prma => prma.idx)
				setSelectedWork(activatedMaterialIdx)
			}
			setSelectedProduct(activatedMaterialIdx)
			setTimeout(() => {
				nc.grid.activateRows(state, 'product_work', activatedWorkIdx, 'scroll-last', unselectOther)
			}, 0)
		} else if (area === 'product_work') {
			if (selectedItemArr.length === 0) {
				selectedMaterialIdx = materialArr.map(prma => prma.idx)
				activatedMaterialIdx = []
			} else {
				selectedMaterialIdx = []
				selectedItemArr
					.filter(prwo => prwo.calc.material_idx != null)
					.forEach(prwo => {
						prwo.calc.material_idx.forEach(idx => {
							if (!selectedMaterialIdx.includes(idx)) {
								// do not add same many times
								selectedMaterialIdx.push(idx)
							}
						})
					})
				activatedMaterialIdx = []
				selectedItemArr
					.filter(prwo => prwo.calc.used_material_idx != null)
					.forEach(prwo => {
						prwo.calc.used_material_idx.forEach(idx => {
							if (!activatedMaterialIdx.includes(idx)) {
								// do not add same many times
								activatedMaterialIdx.push(idx)
							}
						})
					})
			}
			// setSelectedMaterialIdx()
			setSelectedProduct(activatedMaterialIdx)
			setTimeout(() => {
				nc.grid.activateRows(state, 'product_material', activatedMaterialIdx, 'scroll-last', unselectOther)
			}, 0)
		}
	}
	selectedProductCount.value = selectedProductIdx.length
	selectedMaterialCount.value = selectedMaterialIdx.length
	selectedWorkCount.value = selectedWorkIdx.length
	nc.grid.updateFilter(state, 'product_material')
	nc.grid.updateFilter(state, 'product_work')
}

// function gridRowClicked(area, rowIndex, mapSelected, event, deselect) {
function gridRowClicked(area) {
	const selectedItemArr = nc.grid.activatedRecordArr(state, area)
	setFilterArr(selectedItemArr, area)
}

function checkboxClicked(checkboxName) {
	if (checkboxName === 'only_material_phases') {
		const arr = nc.grid.activatedRecordArr(state, 'product_material')
		setFilterArr(arr, 'product_material')
	}
}

function doesExternalFilterPass(node) {
	// if (!this.api.gridOptionsWrapper) return true
	const area = this.api.gridOptionsWrapper.gridOptions.context.gridName
	let find
	switch (area) {
		case 'product':
			if (state.rec.find_product === '') return true
			find = state.rec.find_product.toLowerCase()
			return (
				node.data.product_id.toLowerCase().includes(find) ||
				node.data.work_number_id.toLowerCase().includes(find) ||
				node.data.name.toLowerCase().includes(find)
			)
		case 'product_material':
			return selectedMaterialIdx.includes(node.data.idx)
		case 'product_work':
			if (!selectedWorkIdx.includes(node.data.idx)) return false
			if (state.rec.find_work === '') return true
			find = state.rec.find_work.toLowerCase()
			node.data.pr = node.data.pr || { product_id: '', name: '' } // todo: remove when links do work
			return (
				node.data.production_lot.toLowerCase().includes(find) ||
				node.data.resource_id.toLowerCase().includes(find) ||
				node.data.pr.product_id.toLowerCase().includes(find) ||
				node.data.pr.name.toLowerCase().includes(find) ||
				node.data.work_phase_state.toLowerCase().includes(find) ||
				node.data.json_data.substate.toLowerCase().includes(find)
			)
		// || node.data.pro.production_order_state.toLowerCase().includes(find)
		default:
			return true // should not come here
	}
}

function loadData(ret) {
	productArr = (ret.grid && ret.grid.product && ret.grid.product.data) || []
	materialArr = (ret.grid && ret.grid.product_material && ret.grid.product_material.data) || []
	workArr = (ret.grid && ret.grid.product_work && ret.grid.product_work.data) || []
	productionOrderArr = (ret.grid && ret.grid.product_work && ret.grid.production_order.data) || []
	productCount.value = productArr.length
	materialCount.value = materialArr.length
	workCount.value = workArr.length
	productKey = nc.fieldKey(productArr, 'work_number_id') // product_id
	productionOrderKey = nc.fieldKey(productionOrderArr, 'production_lot')
	productMaterialKey = nc.fieldKey(materialArr, 'work_number_id', 'multiple')
	materialArr.forEach(prma => {
		// prma.pro = productionOrderKey[prma.production_lot]
		prma.pr = productKey[prma.work_number_id]
	})
	workArr.forEach(prwo => {
		prwo.pro = productionOrderKey[prwo.production_lot]
		prwo.pr = productKey[prwo.pro.work_number_id]
	})
	setFilterArr(productArr, 'all')
}

function update() {
	nc.callServer(state, 'query', { name: 'form/nc/nc-storage/init.json', parameter: { save_result: state.rec.save_result } }, loadData)
	// nc.callServer(state, 'query', { name: 'form/nc/nc-storage/grid.json', parameter: { rec: {default_material_phase: state.rec.default_material_phase} } }, callback)
}

loadData(state) // calculate and select all after load or page change

watchEffect(() => {
	if (state.rec.find_product) {
		console.debug(`* find_product: '${state.rec.find_product}'`)
	}
	nc.grid.updateFilter(state, 'product')
})

watchEffect(() => {
	if (state.rec.find_work) {
		console.debug(`* find_work: '${state.rec.find_work}'`)
	}
	nc.grid.updateFilter(state, 'product_work')
})
