// nc-input/nc-textarea.js
import { normalizeClass as _normalizeClass, normalizeStyle as _normalizeStyle, openBlock as _openBlock, createElementBlock as _createElementBlock } from '../../vuelib.js'

const _hoisted_1 = ["rows", "disabled", "value", "placeholder", "autocomplete", "tabindex"]

export function render(_ctx, _cache) {
  return (_openBlock(), _createElementBlock("textarea", {
    class: _normalizeClass(["ui input nc-textarea", _ctx.styleClass]),
    "data-lpignore": "true",
    rows: _ctx.rows,
    style: _normalizeStyle(_ctx.calculatedStyle),
    disabled: _ctx.disabled,
    value: _ctx.recValueFormatted,
    placeholder: _ctx.placeholder,
    autocomplete: _ctx.autocomplete,
    tabindex: _ctx.disabled && -1,
    onInput: _cache[0] || (_cache[0] = (...args) => (_ctx.updateValue && _ctx.updateValue(...args))),
    onFocus: _cache[1] || (_cache[1] = (...args) => (_ctx.onFocus && _ctx.onFocus(...args))),
    onBlur: _cache[2] || (_cache[2] = (...args) => (_ctx.onBlur && _ctx.onBlur(...args)))
  }, null, 46 /* CLASS, STYLE, PROPS, HYDRATE_EVENTS */, _hoisted_1))
}
// :id='editor'
// :style='calculatedStyle'
// :class='styleClass'
// /src/components/nc-input/nc-textarea.vue
/* <template>
	<div
		class='ui input'
		style='width: 100%'>
		<textarea
			:rows='rows'
			:disabled='disabled'
			:value='recValueFormatted'
			class='nc-input'
			@input='updateValue($event)'
			@focus='onFocus($event)'
			@blur='onBlur($event)'/>
	</div>
</template> */
// todo: sync with input, should this be same?
import createComponent from './nc-input-component.js'
export default { ...createComponent('NcTextarea') }
