// form/nc/nc-load/nc-load.js
// in layout nc-gantt-chart -component uses:	":data": "rec.gantt_data", ":options": "rec.gantt_options",
const rec = state.rec

function update() {
	nc.callServer(state, 'calc/loading', {}, ret => {
		console.log(`🚀 ~ file: nc-load.js ~ update() ~ ret`, ret)
	})
}
update()

function setQueryItem(index, event) {
	// nc-dropdown calls this
	console.log(`🚀 ~ file: nc-load.js ~ setQueryItem ~ index, $event`, index, event)
}

const mouse = ref({
	mouseover: null,
	mouseout: null,
	mousemove: null,
	click: null,
	drag: null,
	dragend: null
})

function mousemove(id, e) {
	mouse.value.mousemove = `${id}: ${Math.floor(e.offsetX)}x${Math.floor(e.offsetY)}`
}

// demodata
/*
Pieni dokumentaatio datamuodosta

On group, joilla voi olla items:ejä tai subgroup:eja.
items:illä on start ja end, sen sisälle (tai kait ulkopuolellekin) voi pistää element:ejä

elementit type: box, rect, text tai tail

Tyylit sekoitus css ja svg:n tyylejä. ks. https://echarts.apache.org/en/option.html#graphic.elements-rect.style
*/

//
const graphDemo = [
	{
		title: 'laatikoita',
		defaultElements: [{ type: 'text', inside: true }],
		heightRatio: 1, // kuinka korkea rivin sisältö on
		defaultLines: 1, // kuinka monella rivillä arvataan liikkeelle
		timeBuffer: -0.1, // kuinka paljon anetaan väliä ennen kuin rivitetään, negatiivinen pistää samalle riville kuhan ei pahoja päällekkäisyyksiä
		boxStyle: { lineDash: 0 }, // laatikoiden default tyylit
		groupDividerStyle: { lineDash: 0, stroke: '#000' }, // ryhmän border tyylit.
		items: new Array(20).fill(null).map((_, index) => {
			const d = new Date('2021-06-04T23:00:00')
			const randomColor = ((Math.random() * 0xffffff) << 0).toString(16)
			return {
				id: 10 + index,
				start: new Date(d.getTime() + index * 24 * 60 * 60 * 1000),
				end: new Date(d.getTime() + (index + 1) * 24 * 60 * 60 * 1000),
				title: index, // default teksti text elementille
				elements: [
					{ type: 'box', color: '#999' }, // elementillä on start ja end automaattisesti sama kuin item:illä
					{ type: 'rect', color: `#${randomColor}66`, height: Math.random() * 0.7 + 0.3 }
				]
			}
		})
	},
	{
		title: 'Draggable osio tässä',
		draggable: true,
		tooltip: i => `XXX${i.title}`, // options ja group tooltip on funkkari jolle tulee item parametrinä
		items: [
			{
				id: 1,
				end: '2021-06-11T04:00:00',
				start: '2021-06-04T23:00:00',
				title: 'Foobar',
				elements: [
					{
						type: 'box',
						height: 1,
						end: '2021-06-07T23:30:00',
						start: '2021-06-04T23:00:00'
					},
					{
						type: 'text',
						end: '2021-06-07T23:30:00',
						hover: false,
						inside: true // keskitetään keskelle start ja end arvoja
					},
					/* 					{
						type: 'text',
						text: 'Yliajalla',
						inside: false, // näytetään item:in ulkopuolella, vasemmalla puolella jos mahtuu, näytetään kunnes start ja end näkyy ruudulla
						right: true, // yritetään ensiksi oikeaan reunaan
						hover: false
					}, */
					{
						type: 'tail',
						start: '2021-06-07T23:30:00',
						end: '2021-06-11T04:00:00',
						color: '#f00',
						hover: false
					} /* ,
					{
						type: 'rect',
						start: '2021-06-05T08:00:00',
						end: '2021-06-05T16:00:00',
						color: '#37a2da99',
						height: 1
					},
					{
						type: 'rect',
						start: '2021-06-06T08:00:00',
						end: '2021-06-06T16:00:00',
						color: '#37f22a99',
						height: 0.5
					},
					{
						type: 'rect',
						start: '2021-06-07T08:00:00',
						end: '2021-06-07T16:00:00',
						color: '#f009',
						height: 1,
						hover: true
					} */
				],
				connections: [{ to: 3, hover: false, lineStyle: { stroke: '#f00' }, arrowStyle: { fill: '#f00' } }]
			},
			{
				id: 2,
				start: '2021-06-11T08:00:00',
				end: '2021-06-14T04:00:00',
				title: 'Foobar2',
				tooltip: '<h1>tää on</h1> <b>Foobar</b> joopa', // item tooltip on tekstiä
				elements: [
					{
						type: 'box',
						expand: -2, // pikseliä mitä elementtiä voidaan isontaa/pienentää
						style: {
							lineDash: [0]
						}
					},
					{
						type: 'text',
						hover: true
					}
				],
				connections: [{ to: 1, hover: false }]
			},
			{
				id: 3,
				start: '2021-06-08T23:00:00',
				end: '2021-06-20T04:00:00',
				title: 'Foobar',
				elements: [
					{
						type: 'box',
						height: 1,
						start: '2021-06-11T23:00:00',
						end: '2021-06-17T23:30:00'
					},
					{
						type: 'text',
						start: '2021-06-11T23:00:00',
						end: '2021-06-17T23:30:00',
						hover: true,
						inside: true
					},
					{
						type: 'tail',
						start: '2021-06-17T23:30:00',
						end: '2021-06-20T04:00:00',
						hover: false
					},
					{
						type: 'tail',
						start: '2021-06-11T23:00:00',
						end: '2021-06-08T23:00:00',
						hover: false
					},
					{
						type: 'rect',
						start: '2021-06-13T08:00:00',
						end: '2021-06-14T16:00:00',
						color: '#37a2da99',
						height: 1
					},
					{
						type: 'text',
						start: '2021-06-13T08:00:00',
						end: '2021-06-14T16:00:00',
						color: '#000',
						text: 'foo',
						height: 1,
						inside: true
					},
					{
						type: 'rect',
						start: '2021-06-15T08:00:00',
						end: '2021-06-15T16:00:00',
						color: '#37f22a99',
						height: 0.5
					},
					{
						type: 'rect',
						start: '2021-06-16T08:00:00',
						end: '2021-06-16T16:00:00',
						color: '#f009',
						height: 1,
						hover: true
					}
				]
			}
		]
	},
	{
		title: 'vieläkin pitempi otsikko joka vaan jatkuu ja jatkuu',
		draggable: false,
		defaultElements: [
			{ type: 'box', color: '#999' },
			{ type: 'text', inside: true }
		],
		defaultLines: 99999,
		items: new Array(10).fill(null).map((_, index) => {
			const d = new Date('2021-06-04T23:00:00')
			return {
				id: 100 + index,
				start: new Date(d.getTime() + 2 * index * 24 * 60 * 60 * 1000),
				end: new Date(d.getTime() + (2 * index + 1) * 24 * 60 * 60 * 1000),
				title: `#${index}`,
				connections: [
					{
						to: 101 + index,
						type: 'arrow',
						hover: false
					}
				]
			}
		})
	},
	{
		title: 'testi pitkällä otsikolla',
		defaultElements: [{ type: 'box' }, { type: 'text', inside: true }],
		subgroups: [
			{
				title: 'kuorma',
				defaultElements: [{ type: 'text', inside: true }],
				sticky: true,
				heightRatio: 1,
				defaultLines: 1,
				timeBuffer: -0.1,
				boxStyle: { lineDash: 0 },
				groupDividerStyle: { lineDash: 0, stroke: '#000' },
				bgStyle: { fill: '#8ff' },
				items: new Array(20).fill(null).map((_, index) => {
					const d = new Date('2021-06-04T23:00:00')
					const randomColor = ((Math.random() * 0xffffff) << 0).toString(16)
					return {
						id: 50 + index,
						start: new Date(d.getTime() + index * 24 * 60 * 60 * 1000),
						end: new Date(d.getTime() + (index + 1) * 24 * 60 * 60 * 1000),
						title: index,
						elements: [
							{ type: 'box', color: '#999' },
							{ type: 'rect', color: `#${randomColor}66`, height: Math.random() * 0.7 + 0.3 }
						]
					}
				})
			}
		].concat(
			new Array(10).fill(null).map((_, groupIndex) => {
				const randomColor = `#${((Math.random() * 0xffffff) << 0).toString(16)}`
				return {
					title: `subgroup${groupIndex + 1}`,
					...(groupIndex === 1 ? { draggable: true, title: `drag subgroup${groupIndex + 1}` } : {}),
					defaultBoxColor: randomColor,
					items: new Array(10).fill(null).map((_, index) => {
						const d = new Date('2021-06-04T23:00:00')
						return {
							id: (groupIndex + 2) * 100 + index,
							start: new Date(d.getTime() + (index - 5 * Math.random()) * 24 * 60 * 60 * 1000),
							end: new Date(d.getTime() + (index + 5 * Math.random()) * 24 * 60 * 60 * 1000),
							title: `Foobar${index}`,
							connections: [
								{
									to: (groupIndex + 2) * 100 + 1 + index,
									type: 'arrow',
									hover: true
								}
							]
						}
					})
				}
			})
		)
	},
	{
		title: 'toinen',
		defaultElements: [{ type: 'box' }, { type: 'text', inside: true }],
		subgroups: new Array(10).fill(null).map((_, groupIndex) => {
			const randomColor = `#${((Math.random() * 0xffffff) << 0).toString(16)}`
			return {
				title: `subgroup${groupIndex + 1}`,
				defaultBoxColor: randomColor,
				items: new Array(10).fill(null).map((_, index) => {
					const d = new Date('2021-06-04T23:00:00')
					return {
						id: (groupIndex + 2) * 10000 + index,
						start: new Date(d.getTime() + (index - 5 * Math.random()) * 24 * 60 * 60 * 1000),
						end: new Date(d.getTime() + (index + 5 * Math.random()) * 24 * 60 * 60 * 1000),
						title: `Foobar${index}`,
						connections: [
							{
								to: (groupIndex + 2) * 10000 + 1 + index,
								type: 'arrow',
								hover: true
							}
						]
					}
				})
			}
		})
	}
]
rec.gantt_data = ref(graphDemo)
