// preference/form/nc/nc-production/nc-production.js

const rec = state.rec
const arr = state.arr
const hdr = state.hdr

const mouse = ref({
	mouseover: null,
	mouseout: null,
	mousemove: null,
	click: null,
	drag: null,
	dragend: null
})
function mousemove(id, e) {
	mouse.value.mousemove = `${id}: ${Math.floor(e.offsetX)}x${Math.floor(e.offsetY)}`
}

let findProduct, prevProduct
let findProductIdx = {}
const activatedRowIdxArr = []
const unselectOther = true

function updateFilter(product) {
	if (product != null) {
		findProduct = product.toLowerCase()
	}
	let found = false
	const data = state.grid?.product_need?.data
	if (findProduct && data && findProduct.length >= rec.find_min_characters) {
		findProductIdx = {}
		activatedRowIdxArr.length = 0
		let item
		for (let i = 1; i <= data.length; i++) {
			item = data[i - 1]
			if (item.product_id.includes(findProduct)) {
				found = true
				findProductIdx[item.product_id] = true
				if (activatedRowIdxArr.length <= rec.max_activate_row_count + 1) {
					activatedRowIdxArr.push(i) // item.idx is not set if called from callback, use i instead
				}
			} else if (item.from_row_text && item.from_row_text.toLowerCase().includes(findProduct)) {
				found = true
				findProductIdx[item.product_id] = true
			}
		}
	}
	if (found) {
		let foundUpper = false // add upper-level products and repeat until no upper-level is found
		do {
			foundUpper = false
			data.forEach(item => {
				if (findProductIdx[item.product_id]) {
					if (item.from_row_product_arr) {
						item.from_row_product_arr.forEach(productId => {
							if (!findProductIdx[productId]) {
								foundUpper = true
								findProductIdx[productId] = true
							}
						})
					}
				}
			})
		} while (foundUpper === true)
	}
	if ((findProduct.length >= rec.find_min_characters && findProduct !== prevProduct) || !findProduct) {
		prevProduct = findProduct
		nc.grid.updateFilter(state, 'product_need')
	}
	if (activatedRowIdxArr.length > 0 && activatedRowIdxArr.length <= rec.max_activate_row_count) {
		setTimeout(() => {
			nc.grid.activateRows(state, 'product_need', activatedRowIdxArr, 'scroll-last', unselectOther)
		}, 0)
	}
}

let node
function doesExternalFilterPass(node) {
	// if (rec.find_product === '') return true
	node = node.data
	return (
		!findProduct ||
		findProductIdx[node.product_id] ||
		node.product_id.toLowerCase().includes(findProduct) ||
		(node.production_lot && node.production_lot.toLowerCase().includes(findProduct)) ||
		(node.order_id && node.order_id.toLowerCase().includes(findProduct))
	)
}

onMounted(() => {
	const updateFunc = nc.debounce(updateFilter, (rec.find_delay_seconds && rec.find_delay_seconds * 1000) || 1000, false)
	watchEffect(() => {
		updateFunc(state.rec.find_product) // must use state.rec in watchEffect to work
	})
	update('update') // first data load
})

function update(action) {
	if (action === 'update') {
		if (rec.view === 'product-need') {
			nc.callServer(
				state,
				'calc/product-need',
				{
					parameter: {
						project: rec.project,
						max_need_down_loop_count: rec.max_need_down_loop_count,
						action_limit: rec.action_limit,
						negative_end_balance: rec.negative_end_balance,
						reload_data: rec.reload_data,
						critical_date: rec.critical_date
					}
				},
				() => {
					updateFilter() // callback
				}
			)
		}
	}
}
