// form/nc/report/pallet-label/pallet-label.js

const rec = state.rec
const arr = state.arr
const hdr = state.hdr

onMounted(() => {
	update() // first data load
})

function setRecord(item) {
	nc.mergeState(state, 'rec', item, 'pallet-label.js')
	loadPdf()
}

function pdfCallback(ret) {
	if (ret && ret.page) {
		// pdf render result
		state.rec.pdf = { data: ret.page }
		return
	}
}

function callback(ret) {
	pdfCallback(ret)
	const arr = state.grid && state.grid.order_row && state.grid.order_row.data
	state.rec.ord = {}
	state.rec.co = {}
	if (arr && arr.length > 0) {
		setRecord(arr[0])
		nc.grid.activateRows(state, 'order_row', 1)
	}
}

function gridRowClicked(area) {
	const arr = nc.grid.activatedRecordArr(state, area)
	if (arr.length > 0) {
		setRecord(arr[0])
	}
}

function loadPdf() {
	if (rec.show_pdf) {
		nc.callServer(
			state,
			'print',
			{
				render_preference: {
					document_type: 'pdf',
					paper_type: rec.paper_type,
					paper_orientation: (rec.landscape && 'landscape') || 'portrait'
				},
				state: {
					rec: state.rec,
					hdr: state.hdr
				}
			},
			pdfCallback
		)
	}
}

function update() {
	const param = {
		dispatch_note: state.rec.dispatch_note
	}
	nc.callServer(
		state,
		'query',
		{
			name: 'form/nc/report/pallet-label/grid.json',
			return: {
				grid: [
					{
						name: 'order_row'
					}
				]
			},
			parameter: param
		},
		callback
	)
}
