$on('gridDataChanged', function (msg, areaId, args, fldName, previousValue, area) {
	return gridDataChanged(areaId, args, fldName, previousValue, area)
})
$on('gridAddNewRow', function (msg, areaId, args, area) {
	return gridAddNewRow(areaId, args, area)
})
$on('gridRowDelete', function (msg, areaId, rows, area) {
	return gridRowDelete(areaId, rows, area)
})

function addToSelection(call, rec) {
	var colName, id
	if (call === 'input/duplicate') {
		// start of duplicate
		if (inAdd !== true) {
			sel = null
			inAdd = true
		}
		return
	}
	if (inAdd !== true) {
		return
	}
	if (rec == null) {
		return
	}
	if (sel == null) {
		sel = {}
	}
	if (sel.selection == null) {
		sel.selection = []
	}
	colName = table + '_record_id'
	id = rec[colName]
	if (id == null || id === '') {
		return
	}
	sel.selection.push(id)
	sel.selection_record = sel.selection.length - 1 // 0-based array index of idArr
	nc.setParam(sel, 'nc_selection_' + table)
}

function gridLink(args, area, param, row, cell) {
	if (param.grid_rec && !nc.isEmptyObject(param.grid_rec)) {
		nc.textRecToRec(param.grid_rec, args.item, 'js_date')
		area.refreshRows([row])
	}
	if (param.link_grid) {
		if (param.link_grid.dialog_closed === true) {
			if (param.link_grid.selected != null) {
				area.data[row][param.link_grid.linking_field] = param.link_grid.selected
				area.refreshRows([row])
				area.runScriptOnCellExit(row, cell)
				return area.grid.gotoCell(row, cell, false) // (row, cell, forceEdit)
			} else {
				area.runScriptOnCellExit(-row, -cell)
				return area.grid.gotoCell(row, cell, true)
			}
		}
	}
}

function gridDataChanged(areaId, args, fldName, previousValue, area) {
	var callb, param
	param = {}
	param.table = area.table
	param.main_table = mainTable()
	param.area = areaId
	param.rec = nc.recToServerRec(rec)
	param.grid_rec = args.item
	param.field_name = fldName
	param.prev_value = previousValue
	mainScope.recChanged[fldName] = true
	function callb(param) {
		var cell, row
		row = args.row
		cell = args.cell
		return gridLink(args, area, param, row, cell)
	}
	nc.callServer(state, 'input/grid/script', param, callb)
}

function gridAddNewRow(areaId, args, area) {
	var callId, callb, param
	callId = 'input/grid/add'
	param = {}
	param.table = area.table
	param.main_table = mainTable()
	param.area = areaId
	param.rec = nc.recToServerRec(rec)
	param.grid_rec = args.item
	mainScope.recChanged[callId] = true
	param.rows = area.data.length
	function callb(param) {
		var cell, row
		row = area.data.length - 1
		cell = args.column.id // we get cell from from column header id
		return gridLink(args, area, param, row, cell)
	}
	nc.callServer(state, callId, param, callb)
}

function gridRowDelete(areaId, rows, area) {
	var callId, callb, item, param
	callId = 'input/grid/delete'
	item = rows[0]
	param = {}
	param.table = area.table
	param.main_table = mainTable()
	param.area = areaId
	param.rec = nc.recToServerRec(rec)
	param.grid_rec = item
	mainScope.recChanged[callId] = true
	param.rows = area.data.length
	function callb(param) {
		if (param.grid_rec && !nc.isEmptyObject(param.grid_rec)) {
			nc.textRecToRec(param.grid_rec, item, 'js_date')
			return area.refreshRows()
		}
	}
	nc.callServer(state, callId, param, callb)
}

function gridOnSelectedRowsChangedCallback(e, args) {
	return console.log(e, args)
}

function setGridCallback(param) {
	var key
	for (key in grid) {
		if (!grid[key].callback) {
			grid[key].callback = {}
			grid[key].callback.onSelectedRowsChanged = gridOnSelectedRowsChangedCallback
		}
	}
}
// grid.list.callback.onDblClick = gridOnDblClick
// grid.list.callback.onViewportChanged = gridOnViewportChanged
// grid.list.callback.onRedraw = gridOnRedraw
// grid.list.callback.onSort = onSort
