// preference/form/nc/nc-work-center/nc-work-center.js

// storage map svg
let mapSelected = ref([])
let mapHover = ref([])
function storageMapToggleSelected(param) {
	console.debug('map click', param.id, param.event)
	const i = mapSelected.value.indexOf(param.id)
	if (i === -1) mapSelected.value.push(param.id)
	else mapSelected.value.splice(i, 1)
}

function storageMapDoubleClick(param) {
	console.debug('map double click', param.id, param.event)
}

// employee
function getEmployee() {
	// called from web page
	var data, emp, rec
	rec = state.rec
	data = state.data
	emp = rec.em_employee_id
	if (emp !== '') {
		// state.rec.data.em.data does not exist
		emp = nc.findCaseInsensitiveRecFromArr(data.em.data, 'em_employee_id', rec.em_employee_id)
	}
	if (!emp || emp === '') {
		nc.setRec(state, 'em_employee_id', '')
		return nc.setRec(state, 'em_whole_name', '')
	} else {
		nc.setRec(state, 'em_employee_id', emp.em_employee_id)
		return nc.setRec(state, 'em_whole_name', emp.em_whole_name)
	}
}

function gridRowClicked(area, rowIndex, selected, event) {
	console.log(`🚀 ~ file: nc-work-center.js:38 ~ gridRowClicked ~ area, rowIndex, selected, event:`, area, rowIndex, selected, event)
	if (selected) {
		if (area === 'local_data' || area === 'external_data') {
			// setData(area, rowIndex)
		} else if (area === 'local_field' || area === 'external_field') {
			// selectMatchField(area, rowIndex)
		}
	}
}

function gridRowDoubleClicked(area, rowIndex, event) {
	gridRowClicked(area, rowIndex, 'selected', event)
}

function query() {
	nc.callServer(
		state,
		'query', // 'calc/work-center',
		{
			name: 'form/nc/nc-work-center/grid.json',
			parameter: {
				// {"production_lot": state.rec.wo_work_order_id, "employee": state.rec.em_employee_id, "days_before": state.rec.days_before}
				employee: state.rec.em_employee_id,
				selected_work_row: state.rec.selected_work_row,
				resource: state.rec.resource
			}
		}
	)
}
