// preference/form/nc/nc-work-center/nc-work-center.js

// storage map svg
let mapSelected = ref([])
let mapHover = ref([])
function storageMapToggleSelected(param) {
	console.debug('map click', param.id, param.event)
	const i = mapSelected.value.indexOf(param.id)
	if (i === -1) mapSelected.value.push(param.id)
	else mapSelected.value.splice(i, 1)
}

function storageMapDoubleClick(param) {
	console.debug('map double click', param.id, param.event)
}

// update data
function setIndex(data, arr) {
	if (arr.length === 0) {
		return arr
	}
	const productWorkIdx = data.dataIdx['product-work']
	const productionOrderIdx = data.dataIdx['production_order']
	const delimiter = data.production_lot_delimiter
	const parseBefore = peg.parseBefore
	arr.forEach(item => {
		if (item.production_lot) {
			item.pro = productionOrderIdx[item.production_lot]
			if (item.pro) {
				item.pr = productWorkIdx[item.pro.work_number_id]
			}
		}
	})
	return arr
}

function updateAfter(ret) {
	if (ret.data) {
		debugger //
		if (ret.data.work) {
			state.grid.work.data = setIndex(ret.data, ret.data.work)
			// state.grid.work = Object.assign({}, state.grid.work)
			// nc.grid.activateRows(state, 'work', state.rec.selected_work_row)
			// nc.grid.redrawRows(state, 'work', true) // this does not work at all, must assign a new grid object for refresh
		}
		if (ret.data.work_phase) {
			state.grid.work_phase.data = setIndex(ret.data, ret.data.work_phase)
			state.grid.work_phase = Object.assign({}, state.grid.work_phase)
		}
		if (ret.data.product_material) {
			state.grid.product_material.data = ret.data.product_material
			state.grid.product_material = Object.assign({}, state.grid.product_material)
		}
	}
}

function callParameter(rowIndex, reload) {
	return {
		// {"production_lot": state.rec.wo_work_order_id, "employee": state.rec.em_employee_id, "days_before": state.rec.days_before}
		reload_data: reload == false ? reload : state.rec.reload_data,
		prev_resource: state.rec.prev_resource,
		employee: state.rec.employee_id,
		selected_work_row: rowIndex || state.rec.selected_work_row,
		resource: state.rec.resource
	}
}

function update(area, rowIndex) {
	if (area != null) {
		state.rec.selected_work_row = rowIndex
		nc.callServer(
			state,
			'calc/work-center',
			{
				rec: callParameter(rowIndex, false)
			},
			updateAfter
		)
		return
	}
	nc.callServer(
		state,
		'query',
		{
			name: 'form/nc/nc-work-center/grid.json',
			parameter: callParameter(rowIndex)
		},
		updateAfter
	)
}
updateAfter(state) // first call

// grid ui
function gridRowClicked(area, rowIndex, selected, event) {
	console.log(`🚀 ~ file: nc-work-center.js:38 ~ gridRowClicked ~ area, rowIndex, selected, event:`, area, rowIndex, selected, event)
	if (selected) {
		if (area === 'work') {
			update('work', rowIndex + 1)
			// } else if (area === 'local_field' || area === 'external_field') {
			// 	// selectMatchField(area, rowIndex)
		}
	}
}

function gridRowDoubleClicked(area, rowIndex, event) {
	gridRowClicked(area, rowIndex, 'selected', event)
}
