(function() {
  "use strict";
  var addDrop, addEvent, app, dateKeys, datepicker, datepickerOptions, datepickerOptionsSet, inputFunc, maBlur, maFocus, maLabelInputTemplate, maLabelTemplate, maLink, maSpanTemplate, maTranslateTemplate, popupDirective, prevHoverElement, translatableDirective;

  app = angular.module("ma_directive", ["ui.bootstrap.contextMenu"]);

  prevHoverElement = null;

  addDrop = function(ma, $scope, element, attrs) {
    if (!ma.defineTool()) {
      return;
    }
    element.bind("ondrop", function(e) {
      return console.log("ondrop", e);
    });
  };

  addEvent = function(ma, $scope, element, attrs) {
    if (!ma.defineTool()) {
      return;
    }
    element.bind("mouseenter", function(e) {
      if (prevHoverElement) {
        prevHoverElement.removeClass("ma-hover");
      }
      element.addClass("ma-hover");
      return prevHoverElement = element;
    });
    element.bind("mouseleave", function(e) {
      if (prevHoverElement) {
        prevHoverElement.removeClass("ma-hover");
      }
      element.removeClass("ma-hover");
      return prevHoverElement = null;
    });
  };

  app.directive("maDynamic", [
    "$compile", "ma", function($compile, ma) {
      return {
        require: "?^ngModel",
        restrict: "E",
        transclude: false,
        replace: true,
        template: '<div class="ma-dynamic"/>',
        link: function($scope, element, attrs, ngModel) {
          $scope.$watchCollection(attrs.ngModel, function(newCol, oldCol, $newScope) {
            var dom, domObject, i, item, j, len;
            dom = [];
            for (i = j = 0, len = newCol.length; j < len; i = ++j) {
              item = newCol[i];

              /*if typeof item is "string"
                linkFn = $compile(item)
                dom.splice(i, 0, linkFn($scope))
              else
               */
              if (typeof item !== "object") {
                console.error("ma-dynamic array item " + i + ". type '" + typeof item + "' is not an object");
              } else {
                if (false && item.pushed) {

                } else if (item.linkFn) {
                  dom.push(item.linkFn($scope));
                  item.pushed = true;
                } else if (item.html) {
                  item.linkFn = $compile(item.html);
                  domObject = item.linkFn($scope);
                  dom.push(domObject);
                  item.pushed = true;
                } else if (item.value) {
                  item.html = "<ma-row dnd-draggable='item' dnd-effect-allowed='copy'>" + item.value + "</ma-row>";
                  domObject = $compile(item.html)($scope);
                  dom.push(domObject);
                  item.pushed = true;
                }
              }
            }
            element.append(dom);
          });
        }
      };
    }
  ]);

  app.directive("maForm", [
    "ma", function(ma) {
      return {
        restrict: "E",
        transclude: true,
        replace: true,
        template: '<form class="ma-form" style="{{style}}" ng-transclude/>',
        scope: {
          "height": "=",
          "hover": "="
        },
        controller: function($scope, $element, $attrs) {
          var percent;
          if ($scope.hover) {
            addEvent(ma, $scope, $element, $attrs);
            addDrop(ma, $scope, $element, $attrs);
          }
          if ($scope.height) {
            percent = $scope.height * 100;
            $scope.style = "height:" + percent + "%;";
          }
        }
      };
    }
  ]);

  app.directive("maBeginButton", [
    "ma", function(ma) {
      return {
        restrict: "E",
        transclude: true,
        replace: true,
        template: '<button class="btn btn-default btn-block ma-begin-button" style="{{style}}" ng-transclude/>'
      };
    }
  ]);

  app.directive("maRow", [
    "ma", function(ma) {
      return {
        restrict: "E",
        transclude: true,
        replace: true,
        template: '<div class="ma-row" style="{{style}}" ng-transclude/>',
        scope: {
          "width": "=",
          "height": "=",
          "hover": "="
        },
        controller: function($scope, $element, $attrs) {
          var percent;
          if ($scope.hover) {
            addEvent(ma, $scope, $element, $attrs);
            addDrop(ma, $scope, $element, $attrs);
          }
          if (typeof $scope.style !== "string") {
            $scope.style = "";
          }
          if ($scope.height) {
            percent = $scope.height * 100;
            $scope.style = "height:" + percent + "%;";
          }
          if ($scope.width) {
            percent = $scope.width * 100;
            $scope.style = $scope.style + "width:" + percent + "%;";
          }
        }
      };
    }
  ]);

  app.directive("maCol", [
    "ma", function(ma) {
      return {
        restrict: "E",
        transclude: true,
        replace: true,
        template: '<div class="ma-col" style="{{style}}" ng-transclude/>',
        scope: {
          "width": "=",
          "height": "=",
          "hover": "="
        },
        controller: function($scope, $element, $attrs) {
          var percent;
          if ($scope.hover) {
            addEvent(ma, $scope, $element, $attrs);
            addDrop(ma, $scope, $element, $attrs);
          }
          if (typeof $scope.style !== "string") {
            $scope.style = "";
          }
          if (!$scope.width) {
            $scope.style = $scope.style + "width:100%;";
          } else {
            percent = $scope.width * 100;
            $scope.style = $scope.style + "width:" + percent + "%;";
          }
          if ($scope.height) {
            percent = $scope.height * 100;
            $scope.style = $scope.style + "height:" + percent + "%;";
          }
        }
      };
    }
  ]);


  /*
  app.directive "maBox", ["ma", (ma) ->
     * require: "?^ngModel"
    restrict: "E"
    transclude: true
    replace : true
    template: '<div class="ma-box" style="{{style}}" ng-transclude/>'
     * is-disabled="maDisabled || readonly"
    scope   :
      "width": "="
      "height": "="
       * "extraStyle": "style" # this does NOT work because template has style="{{style}}"
       * "hover": "="
    controller: ($scope, $element, $attrs) ->
       * if $scope.hover
          * addEvent(ma, $scope, $element, $attrs)
          * addDrop(ma, $scope, $element, $attrs)
       * if not $scope.width and not $scope.height
         * console.error("ma-box needs width or height attribute")
      #else
      if typeof $scope.style isnt "string"
        $scope.style = ""
      if $scope.width
        percent = $scope.width * 100
        $scope.style = $scope.style + "width:" + percent + "%;"
      if $scope.height
        percent = $scope.height * 100
        $scope.style = $scope.style + "height:" + percent + "%;"
      return
  ]
   */

  app.directive("maResize", function() {
    return {
      restrict: 'A',
      scope: {
        callback: '&onResize'
      },
      link: function(scope, elem, attrs) {
        elem.resizable();
        elem.on('resize', function(evt, ui) {
          scope.$apply(function() {
            if (scope.callback) {
              scope.callback({
                $evt: evt,
                $ui: ui
              });
            }
          });
        });
      }
    };
  });

  app.directive("maKeyDown", function() {
    return function(scope, element, attrs) {
      element.bind("keydown keypress", function(event) {
        console.log("ngKeyDown", event);
        return scope.$apply(function() {
          var funcName, ret;
          funcName = attrs.maKeyDown.replace("$keyCode", event.which);
          funcName = funcName.replace("$shiftKey", event.shiftKey);
          ret = scope.$eval(funcName);
          if (ret === true) {
            event.preventDefault();
          }
        });
      });
    };
  });

  app.directive("maPicture", [
    "ma", function(ma) {
      return {
        require: "?^ngModel",
        restrict: "E",
        replace: true,
        template: "<span></span>",
        scope: true,
        link: function($scope, element, attrs, ngModel) {
          return $scope.$parent.$watch(attrs.ngModel, function(newValue) {
            if (newValue != null) {
              return element.html(newValue);
            }
          });
        }
      };
    }
  ]);

  app.directive("maInclude", function() {
    return {
      restrict: 'CAE',
      scope: {
        src: '=',
        myInclude: '='
      },
      transclude: true,
      link: function(scope, iElement, iAttrs, controller) {
        scope.$on('$includeContentError', function(event, args) {
          scope.loadFailed = true;
        });
        scope.$on('$includeContentLoaded', function(event, args) {
          scope.loadFailed = false;
        });
      },
      template: '<div ng-include=\'myInclude||src\'></div><div ng-show=\'loadFailed\' ng-transclude/>'
    };
  });

  app.directive('price2d', [
    "ma", function(ma) {
      return {
        require: 'ngModel',
        link: function(scope, element, attrs, modelCtrl) {
          return modelCtrl.$formatters.push(function(input) {
            if (input == null) {
              return;
            }
            return input = ma.round(input, 2, true);
          });
        }
      };
    }
  ]);

  app.directive('num2d', [
    "ma", function(ma) {
      return {
        require: 'ngModel',
        link: function(scope, element, attrs, modelCtrl) {
          return modelCtrl.$formatters.push(function(input) {
            if (input == null) {
              return;
            }
            return input = ma.round(input, 2, true);
          });
        }
      };
    }
  ]);

  app.directive('num1d', [
    "ma", function(ma) {
      return {
        require: 'ngModel',
        link: function(scope, element, attrs, modelCtrl) {
          return modelCtrl.$formatters.push(function(input) {
            if (input == null) {
              return;
            }
            return input = ma.round(input, 1, true);
          });
        }
      };
    }
  ]);

  app.directive('num0d', [
    "ma", function(ma) {
      return {
        require: 'ngModel',
        link: function(scope, element, attrs, modelCtrl) {
          return modelCtrl.$formatters.push(function(input) {
            if (input == null) {
              return;
            }
            return input = ma.round(input, 0, true);
          });
        }
      };
    }
  ]);

  app.directive("maTest", function() {
    return {
      restrict: 'E',
      replace: true,
      template: '<div class="maTest"></div>',
      link: function($scope, element, attrs) {
        var htmlText;
        htmlText = "Hello maTest, directive is loaded and works!";
        return element.html(htmlText);
      }
    };
  });

  app.directive("maBlur", maBlur = function() {
    return function(scope, elem, attrs) {
      return elem.bind("blur", function() {
        return scope.$apply(attrs.maBlur);
      });
    };
  });

  app.directive("maFocus", maFocus = function($timeout) {
    return function(scope, elem, attrs) {
      return scope.$watch(attrs.maFocus, function(newVal) {
        if (newVal) {
          return $timeout((function() {
            return elem[0].focus();
          }), 0, false);
        }
      });
    };
  });

  app.directive("maMarkdown", [
    "ma", function(ma) {
      return {
        restrict: 'E',
        link: function($scope, element, attrs) {
          var htmlText;
          htmlText = ma.markdown(element.text(), true, 'marked');
          return element.html(htmlText);
        }
      };
    }
  ]);

  translatableDirective = function(name, template, styleClass) {
    var translationTemplate;
    translationTemplate = '<input type="text" ng-show="translateInUse" ng-model="labelText" ng-change="changeText()" class="ma-translate" ng-class="{changed: !textIsSame}" context-menu="menuOptions"/>';
    return app.directive(name, [
      "lang", "ma", function(lang, ma) {
        return {
          require: "?^ngModel",
          restrict: "E",
          replace: true,
          transclude: true,
          template: '<span>' + translationTemplate + '<span ng-show="!translateInUse">' + template + '</span></span>',
          scope: {
            "labelText": "=ngModel"
          },
          link: function($scope, element, attrs, ngModel) {
            var getMenuOptions, hdrId, justTransclude, mainScope, originalText;
            $scope.styleClass = styleClass;
            $scope.textIsSame = true;
            $scope.translateInUse = lang.translateInUse();
            mainScope = ma.mainScope();
            hdrId = null;
            if (attrs.ngModel) {
              hdrId = attrs.ngModel.split('.').slice(1).join('.');
            }
            if (!hdrId) {
              console.warn(name + " is missing proper hdr id!");
            }
            getMenuOptions = function() {
              return [ngModel.$modelValue].concat(lang.getAlternatives(hdrId)).map(function(v) {
                return [
                  v, function(name) {
                    var textIsSame;
                    ngModel.$setViewValue(name);
                    textIsSame = $scope.labelText === name;
                    $scope.textIsSame = textIsSame;
                    return mainScope.hdrChanged[hdrId] = !textIsSame;
                  }
                ];
              });
            };
            originalText = '';
            justTransclude = false;
            mainScope.$watch('translate.use', function(translateInUse) {
              var transclusionElement, transclusionText;
              $scope.translateInUse = translateInUse;
              if (translateInUse) {
                $scope.menuOptions = getMenuOptions();
                if (!ngModel.$modelValue) {
                  transclusionElement = element.find('.transclusion');
                  if (transclusionElement.length) {
                    transclusionText = transclusionElement[0].textContent;
                    ngModel.$setViewValue(transclusionText);
                    justTransclude = true;
                  }
                }
                $scope.textIsSame = true;
                return originalText = ngModel.$modelValue;
              } else if (justTransclude && $scope.textIsSame) {
                return ngModel.$setViewValue(transclusionText);
              }
            }, true);
            return $scope.changeText = function() {
              var textIsSame;
              textIsSame = $scope.labelText === originalText;
              $scope.textIsSame = textIsSame;
              return mainScope.hdrChanged[hdrId] = !textIsSame;
            };
          }
        };
      }
    ]);
  };

  maSpanTemplate = '<span class="input-group-addon" ng-transclude></span>';

  translatableDirective("maSpan", maSpanTemplate, "ma-span");

  maLabelTemplate = '<label class="{{styleClass}}"><span ng-show="labelText">{{labelText}}</span><span ng-show="!labelText">&nbsp;<span class="transclusion" ng-transclude></span></span></label>';

  translatableDirective("maLabel", maLabelTemplate, "ma-label");

  translatableDirective("maLabelNormal", maLabelTemplate, "ma-label-normal");


  /*
  maLabelTextareaTemplate = '<textarea class="form-control {{styleClass}}"><span ng-show="labelText">{{labelText}}</span><span ng-show="!labelText">&nbsp;<span class="transclusion" ng-transclude></span></span></textarea>'
  translatableDirective("maLabelTextarea", maLabelTextareaTemplate, "ma-label-textarea")
   */

  maTranslateTemplate = '<span ng-show="labelText">{{labelText}}</span><span ng-show="!labelText">&nbsp;<span class="transclusion" ng-transclude></span></span>';

  translatableDirective("maTranslate", maTranslateTemplate, "ma-translate");

  translatableDirective("maReportGroupLabel", maLabelTemplate, "ma-report-group-label");

  translatableDirective("maReportLabel", maLabelTemplate, "ma-report-label");

  translatableDirective("maReportLabelBold", maLabelTemplate, "ma-report-label-bold");

  translatableDirective("maPageHeader", maLabelTemplate, "ma-page-header");

  translatableDirective("maHeader1", maLabelTemplate, "ma-header1");

  translatableDirective("maHeader2", maLabelTemplate, "ma-header2");

  translatableDirective("maHeader3", maLabelTemplate, "ma-header3");

  translatableDirective("maGroupLabel", maLabelTemplate, "ma-group-label");

  popupDirective = function(name, mode, handlers, className) {
    return app.directive(name, [
      "ma", function(ma) {
        return {
          require: "?^ngModel",
          restrict: "E",
          template: '<div isteven-multi-select is-disabled="maDisabled || readonly" class="' + className + '" translation="translation" input-model="inputModel" output-model="outputModel" on-select-all="selectAll()" on-select-none="resetModel()" on-item-click="updateModel()" selection-mode="' + mode + '" button-label="show" item-label="show" tick-property="ticked" ng-class="{changed: textIsChanged}"></div>',
          scope: {
            "inputValue": "=ngModel",
            "inputModel": "@",
            "outputModel": "@",
            "itemClicked": "@"
          },
          controller: function($scope, $element, $attrs) {
            return $scope.translation = {
              selectAll: "Valitse kaikki",
              selectNone: "Tyhjennä kaikki",
              reset: "Oletus",
              search: "Etsi...",
              nothingSelected: ""
            };
          },
          link: function($scope, element, attrs, ngModel) {
            var initPopup, initialValue, mainScope, popupVarId, pos, previousValue, recVarId, selectedDataRec, selectedPopRec, setPopup;
            initialValue = null;
            previousValue = null;
            $scope.inputId = attrs.ngModel;
            $scope.readonly = ma.currentUrl() === "input/browse";
            mainScope = ma.mainScope();
            $scope.changed = function(option) {
              if (ma.inInput()) {
                if (option === "change") {
                  previousValue = String.fromCharCode(0);
                  return;
                } else if (option === "clear") {
                  previousValue = String.fromCharCode(0);
                  $scope.textIsChanged = false;
                  initialValue = null;
                  previousValue = null;
                  return;
                }
                if (initialValue === null) {
                  initialValue = $scope.inputValue;
                }
                if (previousValue !== String.fromCharCode(0)) {
                  previousValue = $scope.inputValue;
                }
                $scope.textIsChanged = $scope.inputValue !== initialValue;
                if ($scope.textIsChanged === false) {
                  mainScope.deleteRecChanged($scope.inputId);
                } else {
                  mainScope.setRecChanged($scope.inputId, $scope.changed);
                }
                if (previousValue !== $scope.inputValue) {
                  $scope.$emit("inputValueChanged", attrs.ngModel, $scope.inputValue, previousValue);
                }
                return previousValue = null;
              }
            };
            if (!$scope.$parent.popup_arr) {
              $scope.$parent.popup_arr = {};
            }
            $scope.inputModel = [];
            $scope.outputModel = [];
            $scope.selectAll = function() {
              $scope.outputModel = angular.copy($scope.inputModel);
              return $scope.updateModel();
            };
            $scope.resetModel = function() {
              $scope.outputModel = [];
              return $scope.updateModel();
            };
            $scope.updateModel = function() {
              var selected, value;
              if (initialValue === null) {
                initialValue = $scope.inputValue;
              }
              selected = $scope.outputModel;
              value = handlers.getValue(selected);
              ngModel.$setViewValue(value);
              return $scope.changed();
            };
            selectedDataRec = null;
            selectedPopRec = null;
            recVarId = attrs.ngModel;
            popupVarId = recVarId;
            pos = recVarId.indexOf("rec.");
            if (pos >= 0) {
              popupVarId = popupVarId.replace("rec.", "popup.");
            }
            if (!$scope.$parent.popup) {
              console.error("ma-popup: $scope.popup does not exist");
              return;
            }
            setPopup = function(pop, selectedValues) {
              var item, j, len, rec, results, selecitedPopRec;
              if (selectedValues == null) {
                selectedValues = [];
              }
              $scope.inputModel = [];
              results = [];
              for (j = 0, len = pop.length; j < len; j++) {
                item = pop[j];
                rec = {
                  value: item.value,
                  show: item.show
                };
                if (selectedValues && selectedValues.length > 0 && selectedValues.indexOf(item.value) >= 0) {
                  rec.ticked = true;
                  selectedDataRec = item;
                  selecitedPopRec = rec;
                } else {
                  rec.ticked = false;
                }
                results.push($scope.inputModel.push(rec));
              }
              return results;
            };
            initPopup = function(recVarId, value) {
              var arr, i, j, len, parentPopupArr, parentVar, pop;
              parentPopupArr = $scope.$parent.popup_arr;
              arr = popupVarId.split(".");
              parentVar = $scope.$parent;
              pop = null;
              i = 0;
              for (j = 0, len = arr.length; j < len; j++) {
                name = arr[j];
                if (parentVar[name]) {
                  i = i + 1;
                  pop = parentVar[name];
                  parentVar = pop;
                }
              }
              if (pop && i === arr.length) {
                parentPopupArr[popupVarId] = angular.copy(pop);
                return setPopup(parentPopupArr[popupVarId], value);
              }
            };
            return $scope.$parent.$watch(recVarId, function(newValue) {
              return initPopup(recVarId, handlers.getWatchValue(newValue));
            });
          }
        };
      }
    ]);
  };

  popupDirective("maPopup", "single", {
    getValue: function(selected) {
      return selected[0].value;
    },
    getWatchValue: function(value) {
      return [value];
    }
  }, "ma-popup");

  popupDirective("maMultiPopup", "multiple", {
    getValue: function(selected) {
      return selected.map(function(a) {
        return a.value;
      });
    },
    getWatchValue: function(value) {
      return value;
    }
  }, "ma-multi-popup");

  app.directive("maButton", function() {
    return {
      restrict: "E",
      replace: true,
      transclude: true,
      template: '<button class="ui basic button ma-button" ng-transclude></button>'

      /* compile: (element, attrs) ->
         * XXX: you can replace this with transclude
        innerHTML = element.html()
        htmlText = '<button type="button" class="ma-button btn btn-default btn-block">' + innerHTML + '</button>'
        element.replaceWith(htmlText)
       */
    };
  });

  app.directive("maDefaultButton", function() {
    return {
      restrict: "E",
      replace: true,
      transclude: true,
      template: '<button type="button" class="ui primary button ma-button" ng-transclude></button>'
    };
  });

  app.directive("maButtonSmall", function() {
    return {
      restrict: "E",
      replace: true,
      transclude: true,
      template: '<button type="button" class="ui button ma-button-small" ng-transclude></button>'
    };
  });

  app.directive("maToolbarButton", function() {
    return {
      require: "?^ngModel",
      restrict: "E",
      replace: true,
      transclude: true,
      template: '<button type="button" ng-click="changeValue()" ng-class="{active: value === inputValue}" class="ma-button ui button" ng-transclude></button>',
      scope: {
        "inputValue": "=ngModel",
        "onClick": "&"
      },
      link: function(scope, element, attrs, ngModel) {
        scope.value = attrs.value;
        return scope.changeValue = function() {
          console.log('selected toolbar button', scope.value);
          ngModel.$setViewValue(scope.value);
          return scope.onClick();
        };
      }
    };
  });

  datepicker = jQuery.fn.datetimepicker;

  jQuery.fn.bootstrapDP = datepicker;

  datepickerOptions = null;

  dateKeys = ["+", "-", "t", "y", "r", "m", "h", "w", "k"];

  datepickerOptionsSet = function(dateFormat) {
    var key, val;
    datepickerOptions = {

      /* old datepicker
      autoclose: true
      calendarWeeks: true
      clearBtn: true
      todayBtn: false
      todayHighlight: true
      enableOnReadonly: false
      forceParse: false
      showOnFocus: true
      weekStart: 1 # monday
      format: dateFormat # "dd.mm.yyyy" # "yyyy-mm-dd"
       */
      sideBySide: true,
      calendarWeeks: true,
      showTodayButton: false,
      showClear: false,
      showClose: false,
      focusOnShow: true,
      toolbarPlacement: "default",
      format: 'DD.MM.YYYY',
      extraFormats: ['DD.MM.YY'],
      locale: "fi"
    };
    for (key in datepickerOptions) {
      val = datepickerOptions[key];
      datepicker.defaults[key] = val;
    }
  };

  inputFunc = function($scope, element, attrs, ngModel, ma, $timeout) {
    var dtPicker, initialValue, mainScope, previousValue, setDatepicker;
    initialValue = null;
    previousValue = null;
    $scope.inputId = attrs.ngModel;
    $scope.readonly = ma.currentUrl() === "input/browse";
    mainScope = ma.mainScope();
    dtPicker = null;
    setDatepicker = function(action) {
      var dateValue, elem, id, obj, opt;
      if (datepickerOptions === null) {
        datepickerOptionsSet(ma.defaultDateFormat());
      }
      dateValue = null;
      if (_.isDate($scope.inputValue)) {
        dateValue = $scope.inputValue;
        $scope.inputValue = ma.formatDate(dateValue);
      } else {
        dateValue = ma.textToDate($scope.inputValue);
      }
      id = $scope.inputId.replace(".", "_");
      element.addClass(id);
      opt = {};
      elem = jQuery("." + id);
      obj = elem.bootstrapDP(opt);
      dtPicker = obj.data("DateTimePicker");
      if ($scope.inputValue === "") {
        dtPicker.date(null);
      } else {
        dtPicker.date($scope.inputValue);
      }
      obj.on("change", function(e) {
        dateValue = ma.textToDate($scope.inputValue);
        return $scope.inputValue = ma.formatDate(dateValue);
      });
      obj.on("hide", function(e) {
        dateValue = ma.textToDate($scope.inputValue);
        $scope.inputValue = ma.formatDate(dateValue);
        dtPicker.date($scope.inputValue);
        $scope.changed();
        return $scope.blurred();
      });
      obj.on("dp.change", function(e) {

        /* e = {
            date, //date the picker changed to. Type: moment object (clone)
            oldDate //previous date. Type: moment object (clone) or false in the event of a null
        }
         */
        return $timeout(function() {
          return $scope.inputValue = e.date.format(e.date._f);
        });
      });
      element.bind("keydown keypress", function(event) {
        var key;
        key = ma.fromKeyCode(event.keyCode).toLowerCase();
        if (dateKeys.indexOf(key) >= 0) {
          dateValue = ma.textToDate(key, dateValue);
          dateValue = ma.formatDate(dateValue);
          $timeout(function() {
            $scope.inputValue = dateValue;
            return dtPicker.date(dateValue);
          });
          return event.preventDefault();
        }
      });
      if (action === "show") {
        return dtPicker.show();
      }
    };
    $scope.focused = function() {
      if (dtPicker === null) {
        if ($scope.maDatepicker || ma.fieldType($scope.inputId) === "date") {
          _.isDate($scope.inputValue);
          setDatepicker("show");
        } else {
          dtPicker = false;
        }
      } else if (dtPicker) {
        dtPicker.show();
      }
      if (initialValue === null) {
        initialValue = $scope.inputValue;
      }
      if (previousValue !== String.fromCharCode(0)) {
        if (typeof initialValue === "number") {
          $scope.inputValue = ma.textToNumber($scope.inputValue);
        }
        return previousValue = $scope.inputValue;
      }
    };
    $scope.blurred = function() {
      var fn, funcName, pos;
      if ($scope.maChange) {
        funcName = $scope.maChange;
        pos = funcName.indexOf("(");
        if (pos > 0) {
          funcName = funcName.substring(0, pos);
        }
        fn = $scope.$parent[funcName];
        if (typeof fn === "function") {
          fn();
        } else {
          console.error("ma-change function was not found: " + $scope.maChange);
        }
      }
      $scope.changed();
      if (previousValue !== $scope.inputValue) {
        $scope.$emit("inputValueChanged", attrs.ngModel, $scope.inputValue, previousValue);
      }
      return previousValue = null;
    };
    return $scope.changed = function(option) {
      var newValue;
      if (option === "change") {
        previousValue = String.fromCharCode(0);
        return;
      } else if (option === "clear") {
        previousValue = String.fromCharCode(0);
        $scope.textIsChanged = false;
        initialValue = null;
        previousValue = null;
        return;
      }
      if (initialValue === null) {
        initialValue = $scope.inputValue;
      }
      newValue = null;
      if (attrs.$$element && attrs.$$element.length && attrs.$$element.length > 0 && (attrs.$$element[0].value != null)) {
        if (attrs["class"] === "ma-label-input") {
          newValue = attrs.$$element[0].lastChild.firstChild.value;
        } else {
          newValue = attrs.$$element[0].value;
        }
      } else {
        newValue = $scope.inputValue;
      }
      if (typeof initialValue === "number") {
        $scope.inputValue = ma.textToNumber($scope.inputValue);
        newValue = ma.textToNumber(newValue);
      }
      $scope.textIsChanged = newValue !== initialValue;
      $scope.inputValue = newValue;
      if ($scope.textIsChanged === false) {
        return mainScope.deleteRecChanged($scope.inputId);
      } else {
        return mainScope.setRecChanged($scope.inputId, $scope.changed);
      }

      /*
      pos = $scope.inputId.indexOf("rec.")
      recId = null
      if pos >= 0
        recId = $scope.inputId.substr(4) # "rec." len is 4
      if recId and $scope.$parent.$parent.rec and $scope.$parent.$parent.rec[recId]
        $scope.$parent.$parent.rec[recId] = $scope.inputValue
       */
    };
  };

  app.directive("maInputValue", [
    function() {
      return {
        restrict: "E",
        replace: true,
        template: '<input class="ma-input form-control" disabled/>'
      };
    }
  ]);

  app.directive("maInput", [
    "ma", "$timeout", function(ma, $timeout) {
      return {
        require: "?^ngModel",
        restrict: "E",
        replace: true,
        templatex: '<input id="{{inputId}}" class="ma-input form-control" ng-readonly="readonly"  ng-focus="focused()" ng-blur="blurred()" ng-change="changed()" ng-class="{changed: textIsChanged}"/>',
        template: '<input id="{{inputId}}" class="ma-input form-control" ng-readonly="readonly"  ng-focus="focused()" ng-blur="blurred()" ng-change="changed()" ng-class="{changed: textIsChanged}"/>',
        scope: {
          "inputValue": "=ngModel",
          "disabled": "=",
          "maDatepicker": "@",
          "maChange": "@"
        },
        link: function($scope, element, attrs, ngModel) {
          return inputFunc($scope, element, attrs, ngModel, ma, $timeout);
        }
      };
    }
  ]);

  maLabelInputTemplate = '<label class="ma-label"><span ng-show="labelText">{{labelText}}</span><span ng-show="!labelText">&nbsp;<span class="transclusion" ng-transclude></span></span></label>';

  app.directive("maLabelInput", [
    "ma", "$timeout", function(ma, $timeout) {
      return {
        require: "?^ngModel",
        restrict: "E",
        replace: true,
        transclude: true,
        template: '<span class="ma-label-input"><ma-col width="1/3">' + maLabelInputTemplate + '</ma-col><ma-col width="2/3"><input id="{{inputId}}" class="ma-input form-control" ng-model="inputValue" ng-readonly="readonly" ng-focus="focused()" ng-blur="blurred()" ng-class="{changed: textIsChanged}"/></ma-col></span>',
        scope: {
          "inputValue": "=ngModel",
          "disabled": "=",
          "maDatepicker": "@"
        },
        link: function($scope, element, attrs, ngModel) {
          var field, pos;
          inputFunc($scope, element, attrs, ngModel, ma, $timeout);
          $scope.labelText = null;
          if (!$scope.$parent.hdr) {
            console.error("ma-label-input: $scope.hdr does not exist");
            return;
          }
          if (attrs.ngModel) {
            pos = attrs.ngModel.indexOf("rec.");
            if (pos >= 0) {
              field = attrs.ngModel.substr(4);
              $scope.labelText = $scope.$parent.hdr[field];
            }
          }
        }
      };
    }
  ]);

  maLink = function($scope, element, attrs, ngModel, ma, directive) {
    var getValue, initialValue, mainScope, previousValue;
    if (ma.inInput()) {
      previousValue = null;
      initialValue = null;
      $scope.inputId = attrs.ngModel;
      $scope.readonly = ma.currentUrl() === "input/browse";
      mainScope = ma.mainScope();
      getValue = function() {
        if ($scope.inputValue != null) {
          return $scope.inputValue;
        }
        return $scope.value;
      };
      $scope.focused = function() {
        if (initialValue === null) {
          return initialValue = getValue();
        }
      };
      $scope.blurred = function() {
        return $scope.changed("blur");
      };
      $scope.changed = function(option, value) {
        var newValue;
        if (option === "change") {
          previousValue = getValue();
          return;
        } else if (option === "clear") {
          $scope.textIsChanged = false;
          mainScope.deleteRecChanged($scope.inputId);
          if (value != null) {
            initialValue = value;
          } else {
            initialValue = getValue();
          }
          previousValue = initialValue;
          return;
        }
        value = getValue();
        if (initialValue === null) {
          initialValue = value;
        }
        newValue = null;
        if (attrs.$$element && attrs.$$element.length && attrs.$$element.length > 0 && (attrs.$$element[0].value != null)) {
          newValue = attrs.$$element[0].value;
        } else {
          newValue = value;
        }
        $scope.textIsChanged = newValue !== initialValue;
        if ($scope.textIsChanged === false) {
          mainScope.deleteRecChanged($scope.inputId);
        } else {
          mainScope.setRecChanged($scope.inputId, $scope.changed);
        }
        if (previousValue === null) {
          previousValue = initialValue;
        }
        if (previousValue !== newValue && option === "blur") {
          $scope.$emit("inputValueChanged", attrs.ngModel, newValue, previousValue);
          return previousValue = newValue;
        }
      };
      if (directive === "maCheckbox") {
        initialValue = getValue();
        return ma.setInputType(attrs.ngModel, "boolean", $scope.changed);
      }
    }
  };

  app.directive("maTextarea", [
    "ma", function(ma) {
      return {
        require: "?^ngModel",
        restrict: "E",
        replace: true,
        template: '<textarea id={{inputId}} ng-readonly="readonly" class="ma-input form-control" ng-focus="focused()" ng-blur="blurred()" ng-change="changed()" ng-class="{changed: textIsChanged}"></textarea>',
        scope: {
          "inputValue": "=ngModel",
          "disabled": "="
        },
        link: function($scope, element, attrs, ngModel) {
          return maLink($scope, element, attrs, ngModel, ma);
        }
      };
    }
  ]);

  app.directive("maRadio", [
    "ma", function(ma) {
      return {
        require: "?^ngModel",
        restrict: "E",
        replace: true,
        transclude: true,
        template: '<label class="radio-inline ma-radio" ng-class="{changed: textIsChanged}"><input type="radio" ng-value="value" ng-disabled="{{disabled || readonly}}" ng-model="inputValue" ng-focus="focused()" ng-click="blurred()" ng-change="blurred()"/><span ng-transclude></span></label>',
        scope: {
          "inputValue": "=ngModel",
          "value": "@",
          "disabled": "=ngDisabled"
        },
        link: function($scope, element, attrs, ngModel) {
          return maLink($scope, element, attrs, ngModel, ma);
        }
      };
    }
  ]);

  app.directive("maCheckbox", [
    "ma", function(ma) {
      return {
        require: "?^ngModel",
        restrict: "E",
        replace: true,
        transclude: true,
        template: '<label class="ma-checkbox" ng-class="{changed: textIsChanged}"><input type="checkbox" ng-readonly="readonly" ng-disabled="{{disabled}}" ng-model="inputValue" ng-checked="inputValue == true || inputValue == 1" id="{{inputId}}" ng-focus="focused()" ng-blur="blurred()" ng-change="changed()"/><span class="text" ng-transclude></span></label>',
        scope: {
          "inputValue": "=ngModel",
          "disabled": "=ngDisabled"
        },
        link: function($scope, element, attrs, ngModel) {
          if (typeof $scope.inputValue !== "boolean") {
            if ($scope.inputValue === 0) {
              $scope.inputValue = false;
            } else {
              $scope.inputValue = true;
            }
          }
          return maLink($scope, element, attrs, ngModel, ma, "maCheckbox");
        }
      };
    }
  ]);

  app.directive("maModal", function() {
    return {
      restrict: 'E',
      replace: true,
      scope: true,
      transclude: true,
      template: '<div class="modal fade">' + '<div class="modal-dialog">' + '<div class="modal-content">' + '<div class="modal-header">' + '<button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>' + '<h4 class="modal-title">{{ title }}</h4>' + '</div>' + '<div class="modal-body" modal-transclude></div>' + '</div>' + '</div>' + '</div>',
      link: function(scope, element, attrs) {
        scope.title = attrs.title;
        scope.$watch(attrs.visible, function(value) {
          if (value === true) {
            $(element).modal('show');
          } else {
            $(element).modal('hide');
          }
        });
        $(element).on('shown.bs.modal', function() {
          scope.$apply(function() {
            scope.$parent[attrs.visible] = true;
          });
        });
        $(element).on('hidden.bs.modal', function() {
          scope.$apply(function() {
            scope.$parent[attrs.visible] = false;
          });
        });
      }
    };
  });

  app.directive("modalTransclude", function() {
    return {
      link: function($scope, $element, $attrs, controller, $transclude) {
        $transclude($scope.$parent, function(clone) {
          $element.empty();
          $element.append(clone);
        });
      }
    };
  });

  app.directive("maGrid", [
    "ma", "$timeout", function(ma, $timeout) {
      return {
        require: "?^ngModel",
        restrict: "E",
        replace: true,
        template: '<div class="ma-grid" style="{{hstyle}}"></div>',
        scope: {
          "area": "=ngModel",
          "optheight": "@height",
          "event": "="
        },
        link: function($scope, element, attrs) {
          var beginUpdate, cb, cellChanged, columnNumber, currentCell, dataView, endUpdate, filter, grid, invalidate, mousemove, mouseup, moveRowsPlugin, onClick, prevValue, prevWindowInnerHeight, redraw, redrawRows, refreshRows, render, runScriptOnCellExit, setHeight, setSelectedRows, setSortColumn, sortAscending, sortColumn, sortGrid, totalsPlugin;
          grid = null;
          dataView = null;
          prevValue = null;
          cellChanged = null;
          currentCell = null;
          cb = null;
          sortColumn = null;
          sortAscending = null;
          totalsPlugin = null;
          onClick = function(event, args) {
            var item;
            item = dataView.getItem(args.row);
            if (!item) {
              return;
            }
            if ($scope.event && $scope.event.click) {
              if ($scope.event.click === "setRec" && $scope.$parent.rec) {
                return $timeout(function() {
                  return ma.recToRec(item, $scope.$parent.rec);
                });
              }
            }
          };
          mousemove = function(event) {

            /*
            if $attrs.resizer == 'vertical'
               * Handle vertical resizer
              x = event.pageX
              if $attrs.resizerMax and x > $attrs.resizerMax
                x = parseInt($attrs.resizerMax)
              $element.css left: x + 'px'
              $($attrs.resizerLeft).css width: x + 'px'
              $($attrs.resizerRight).css left: x + parseInt($attrs.resizerWidth) + 'px'
            else
               * Handle horizontal resizer
              y = window.innerHeight - event.pageY
              $element.css bottom: y + 'px'
              $($attrs.resizerTop).css bottom: y + parseInt($attrs.resizerHeight) + 'px'
              $($attrs.resizerBottom).css height: y + 'px'
            return
             */
          };
          mouseup = function() {
            element.unbind('mousemove', mousemove);
            element.unbind('mouseup', mouseup);
          };
          element.on('XXXmousedown', function(evt, ui) {
            event.preventDefault();
            element.on('mousemove', mousemove);
            return element.on('mouseup', mouseup);
          });
          if ($scope.optheight) {
            prevWindowInnerHeight = window.innerHeight;
            setHeight = function() {
              var pxFromBottom;
              if ($scope.optheight.charAt(0) === "-") {
                pxFromBottom = Number($scope.optheight);
                pxFromBottom = window.innerHeight + pxFromBottom;
                $scope.hstyle = "height:" + pxFromBottom + "px;";
              } else {
                $scope.hstyle = "height:" + $scope.optheight + ";";
              }
              if (grid) {
                return $timeout(function() {
                  return grid.resizeCanvas();
                });
              }
            };
            jQuery(window).resize(function() {
              if (grid) {
                if (prevWindowInnerHeight !== window.innerHeight) {
                  prevWindowInnerHeight = window.innerHeight;
                  setHeight();
                }
              }
            });
            setHeight();
          } else {
            $scope.hstyle = "height:12em;";
          }
          $scope.$on("resizeCanvas", function() {
            return console.log("maGrid on resizeCanvas", element.grid);

            /*
            if element.grid
              height = jQuery(window).height() - 300 #jQuery(window).height() - 18
              if height < 50
                height = 50
              document.getElementById(attrs.id).setAttribute("style","height:"+height+"px")
             */
          });
          runScriptOnCellExit = function(row, cell) {
            if (row === null) {
              return grid.runScriptOnCellExit = null;
            } else {
              grid.runScriptOnCellExit = {};
              grid.runScriptOnCellExit.row = row;
              return grid.runScriptOnCellExit.cell = cell;
            }
          };
          filter = function(item) {
            if (!item) {
              return true;
            }
            if (item.__deleted) {
              return false;
            }
            return true;
          };
          columnNumber = function(column) {
            var col, i;
            col = grid.getColumns();
            i = 0;
            while (i < col.length) {
              if (col[i].field === column) {
                return i;
              }
              i++;
            }
            return -1;
          };
          setSortColumn = function(column, ascending) {
            if (typeof column === "string") {
              sortColumn = columnNumber(column);
            }
            if (typeof ascending === "boolean") {
              sortAscending = ascending;
            }
            if (typeof sortColumn === "number" && typeof sortAscending === "boolean") {
              return grid.setSortColumn(sortColumn, sortAscending);
            }
          };
          sortGrid = function() {
            var columns, gridData;
            columns = $scope.area.columns;
            gridData = $scope.area.data;
            gridData.sort(function(a, b) {
              var j, len, rec, ref, result, sortFunc;
              ref = grid.sort;
              for (j = 0, len = ref.length; j < len; j++) {
                rec = ref[j];
                sortFunc = ma.sortFunc(rec.sign);
                result = sortFunc(a[rec.field], b[rec.field]);
                if (result !== 0) {
                  return result;
                }
              }
              return 0;
            });
            setSortColumn(grid.sort[0].field, grid.sort[0].sign >= 0);
          };
          beginUpdate = function() {
            return dataView.beginUpdate();
          };
          endUpdate = function() {
            dataView.endUpdate();
            return setSortColumn();
          };
          invalidate = function() {
            grid.invalidate();
            return setSortColumn();
          };
          render = function() {
            grid.render();
            if (totalsPlugin) {
              totalsPlugin.render();
            }
            return setSortColumn();
          };
          setSelectedRows = function(data) {
            var cell, colName, i, id, j, len, param, rec, ref, rowArr;
            param = ma.getParam("ma_selection_" + $scope.area.table);
            rowArr = [];
            if (param && (param.selection != null)) {
              colName = $scope.area.table + "_record_id";
              ref = param.selection;
              for (j = 0, len = ref.length; j < len; j++) {
                id = ref[j];
                for (i in data) {
                  rec = data[i];
                  if (rec[colName] === id) {
                    rowArr.push(Number(i));
                  }
                }
              }
              if ((param.selection_record != null) && param.selection_record >= 0 && param.selection_record < rowArr.length) {
                cell = 0;
                grid.setActiveCell(rowArr[param.selection_record], cell);
                if (rowArr.length < 2 || rowArr[0] < rowArr[1]) {
                  grid.scrollCellIntoView(rowArr[0], cell);
                } else {
                  grid.scrollCellIntoView(rowArr[rowArr.length - 1], cell);
                }
              }
            }
            return grid.setSelectedRows(rowArr);
          };
          refreshRows = function(rowArr) {
            dataView.setFilter(filter);
            if (rowArr && rowArr.length > 0) {
              grid.invalidateRows(rowArr);
            } else {
              grid.invalidateAllRows();
            }
            render();
            if (grid.runScriptOnCellExit != null) {
              if (typeof grid.runScriptOnCellExit.row === "number" && typeof grid.runScriptOnCellExit.cell === "number") {
                grid.gotoCell(grid.runScriptOnCellExit.row, grid.runScriptOnCellExit.cell, true);
              } else {
                console.warn("runScriptOnCellExit row or cell is invalid type: ", grid.runScriptOnCellExit.row, grid.runScriptOnCellExit.cell);
              }
              return grid.runScriptOnCellExit = null;
            }
          };
          redrawRows = function(newData) {
            var addCount, i, idStart, start;
            if (newData != null) {
              $scope.data = newData;
            } else {
              newData = $scope.data;
            }
            beginUpdate();
            if (newData && newData.data) {
              dataView.setItems(newData.data);
              if (newData.options) {
                if (newData.options.filter) {
                  dataView.setFilter(newData.options.filter);
                  dataView.setFilterArgs(newData.data);
                }
                if (newData.options.rowCss) {
                  dataView.getItemMetadata = newData.options.rowCss;
                } else {
                  console.log("no rowCss");
                }
              }
              if (cb && cb.onRedraw) {
                addCount = cb.onRedraw($scope.area, newData);
                if (addCount) {
                  start = newData.data.length;
                  idStart = start + 1;
                  i = 0;
                  while (i < addCount) {
                    newData.data[start + i] = {
                      id: idStart + i
                    };
                    i++;
                  }
                }
              }
            }
            dataView.setFilter(filter);
            endUpdate();
            grid.updateRowCount();
            grid.invalidateAllRows();
            render();
            if (newData && newData.data) {
              return setSelectedRows(newData.data);
            }
          };
          redraw = function(newScopeData) {
            var callScript, checkboxSelector, copyManager, copyManagerOptions, dataProvider, err, getSelectedRows, hasTotal, onCopySuccess, runScript, selModel, showContextMenu;
            if (!newScopeData) {
              console.error("ma-grid redraw: " + attrs.id + ", newScopeData is null");
              return;
            }
            if (!newScopeData.data) {
              console.error("ma-grid redraw: " + attrs.id + ", data is null");
              return;
            }
            if (!$scope.area) {
              console.error("ma-grid redraw: " + attrs.id + ", area is null");
              return;
            }
            if (!$scope.area.columns) {
              console.error("ma-grid redraw: " + attrs.id + ", colums is null");
              return;
            }
            if (!$scope.area.options) {
              console.error("ma-grid redraw: " + attrs.id + ", options is null");
              return;
            }
            if (document.getElementById(attrs.id) === null) {
              console.error("ma-grid redraw: " + attrs.id + " DOM element does not exist (this is ok if you changed page while data was loading)");
              return;
            }
            if (!element.dataView) {
              element.dataView = new Slick.Data.DataView();
              dataView = element.dataView;
              $scope.area.dataView = element.dataView;
            }
            if (true) {
              try {
                hasTotal = function() {
                  var j, len, rec, ref;
                  ref = $scope.area.columns;
                  for (j = 0, len = ref.length; j < len; j++) {
                    rec = ref[j];
                    if (rec.hasTotal) {
                      return true;
                    }
                  }
                  return false;
                };
                if (typeof TotalsDataView === "undefined" || !hasTotal()) {
                  element.grid = new Slick.Grid("#" + attrs.id, element.dataView, $scope.area.columns, $scope.area.options);
                } else {
                  dataProvider = new TotalsDataView(element.dataView, $scope.area.columns, $scope.area.options);
                  element.grid = new Slick.Grid("#" + attrs.id, dataProvider, $scope.area.columns, $scope.area.options);
                  totalsPlugin = new TotalsPlugin(jQuery.getScrollbarWidth());
                  element.grid.registerPlugin(totalsPlugin);
                }
                grid = element.grid;
                grid.dataView = element.dataView;
                $scope.area.grid = element.grid;
                if ($scope.area.sort && $scope.area.sort.length > 0) {
                  grid.sort = $scope.area.sort;
                  sortGrid();
                }
                $scope.area.setSortColumn = setSortColumn;
                $scope.area.refreshRows = refreshRows;
                $scope.area.beginUpdate = beginUpdate;
                $scope.area.endUpdate = endUpdate;
                $scope.area.updateRowCount = grid.updateRowCount;
                $scope.area.runScriptOnCellExit = runScriptOnCellExit;
                selModel = null;
                if ($scope.area.options.editable) {
                  selModel = new Slick.CellSelectionModel();
                } else {
                  selModel = new Slick.RowSelectionModel();
                }
                grid.setSelectionModel(selModel);
                element.columnpicker = new Slick.Controls.ColumnPicker($scope.area.columns, element.grid, $scope.area.options);
                cb = $scope.area.callback;
                if (cb) {
                  if (cb.onSelectedRowsChanged) {
                    grid.onSelectedRowsChanged.subscribe(cb.onSelectedRowsChanged);
                  }
                  if (cb.onDblClick) {
                    grid.onDblClick.subscribe(cb.onDblClick);
                  }
                  if (cb.onViewportChanged) {
                    grid.onViewportChanged.subscribe(cb.onViewportChanged);
                  }
                }
                grid.onClick.subscribe(onClick);
                jQuery('.modal.fade').one("webkitTransitionEnd otransitionend oTransitionEnd msTransitionEnd transitionend", function(event) {
                  return grid.resizeCanvas();
                });
              } catch (error) {
                err = error;
                console.error("ma-grid redraw: " + attrs.id + ", grid creation error: " + err.message);
                return;
              }
            }
            $scope.area.redrawRows = redrawRows;
            console.log("ma-grid redraw: " + attrs.id + ", rows: " + newScopeData.data.length);
            checkboxSelector = null;
            if ($scope.area.columns.length > 0) {
              if ($scope.area.columns[0].field === "check_mark") {
                checkboxSelector = new Slick.CheckboxSelectColumn({
                  cssClass: "slick-cell-checkboxsel"
                });
                $scope.area.columns[0] = checkboxSelector.getColumnDefinition();
              }
            }
            if (checkboxSelector) {
              grid.registerPlugin(checkboxSelector);
            }
            grid.registerPlugin(new Slick.AutoTooltips({
              enableForHeaderCells: true,
              maxToolTipLength: 2048
            }));
            dataView.onRowCountChanged.subscribe(function(e, args) {
              grid.updateRowCount();
              render();
            });
            redrawRows(newScopeData);
            if (ma.inOutput() && newScopeData.data && $scope.area.table) {
              setSelectedRows(newScopeData.data);
            }
            grid.onSort.subscribe(function(e, args) {
              var asc, col, defaultSort, isString, scol, scolId, scolNum, sign, sortFunc;
              scol = grid.getSortColumns();
              if (scol.length === 0) {
                return;
              }
              scolNum = scol[0].columnId;
              asc = scol[0].sortAsc;
              col = grid.getColumns();
              isString = col[scolNum].type === "s" || col[scolNum].type === "t";
              scolId = col[scolNum].field;
              sortAscending = asc;
              sortColumn = scolNum;
              defaultSort = true;
              setSortColumn();
              if (cb && cb.onSort) {
                defaultSort = cb.onSort(scolId, sortAscending);
              }
              if (defaultSort) {
                sign = sortAscending ? 1 : -1;
                sortFunc = ma.sortFunc(sign);
                grid.dataView.sort(function(a, b) {
                  return sortFunc(a[scolId], b[scolId]);
                });
                invalidate();
                setSelectedRows(newScopeData.data);
              }
            });
            grid.onKeyDown.subscribe(function(e, args) {
              var activeCell, col, cols, inEditor, keyCode;
              keyCode = $.ui.keyCode;
              col = void 0;
              activeCell = this.getActiveCell();
              if (activeCell) {
                col = activeCell.cell;
                inEditor = this.getCellEditor();
                cols = this.getColumns();
                if (!inEditor && cols[col].editor) {
                  if (jQuery.inArray(e.keyCode, [keyCode.LEFT, keyCode.RIGHT, keyCode.UP, keyCode.DOWN, keyCode.PAGE_UP, keyCode.PAGE_DOWN, keyCode.SHIFT, keyCode.CONTROL, keyCode.CAPS_LOCK, keyCode.HOME, keyCode.END, keyCode.INSERT, keyCode.TAB, keyCode.ENTER]) === -1) {
                    if (!(e.shiftKey || e.ctrlKey || e.altKey || e.ctrlKey || e.metaKey)) {
                      if (e.keyCode !== 20) {
                        return this.editActiveCell();
                      }
                    }
                  }
                }
              }
            });
            if (false) {
              grid.onClick.subscribe(function(e, args) {
                var item;
                if ($(e.target).hasClass("toggle")) {
                  item = dataView.getItem(args.row);
                  if (item) {
                    if (!item._collapsed) {
                      item._collapsed = true;
                    } else {
                      item._collapsed = false;
                    }
                    dataView.updateItem(item.id, item);
                    invalidate();
                  }
                  e.stopImmediatePropagation();
                }
              });
            }
            callScript = function(e, args, emitName) {
              var column, fldName, rec;
              if (currentCell) {
                args.cell = currentCell;
                currentCell = null;
              }
              cellChanged = null;
              column = $scope.area.columns[args.cell];
              fldName = column.field;
              rec = args.item;
              if (!rec) {
                rec = $scope.area.data[args.row];
                args.item = rec;
              }
              if (column.type === "r") {
                rec = $scope.area.data[args.row];
                if (rec[fldName]) {
                  rec[fldName] = ma.textToNumber(rec[fldName]);
                }
              }
              return $scope.$emit(emitName, attrs.id, args, fldName, prevValue, $scope.area);
            };
            runScript = function(e, args) {
              return callScript(e, args, "gridDataChanged");
            };
            getSelectedRows = function() {
              var rows, visibleRows;
              visibleRows = grid.getSelectedRows();
              rows = [];
              jQuery.each(visibleRows, function(index, value) {
                rows.push(dataView.getItem(value));
              });
              return rows;
            };
            showContextMenu = function(e, args) {
              var id, menu, rows;
              id = null;
              rows = getSelectedRows();
              if (!rows || rows.length < 1) {
                id = "#contextMenuSelectRows";
              } else if (ma.inInput()) {
                id = "#contextMenuInput";
              } else if (ma.inOutput()) {
                id = "#contextMenuOutput";
              } else {
                return;
              }
              menu = jQuery(id);
              menu.css('top', e.pageY - 16).css('left', e.pageX + 2).show();
              jQuery(id).click(function(e) {
                if (!jQuery(e.target).is('a')) {
                  return;
                }
                $scope.$emit("gridRowDelete", attrs.id, rows, $scope.area);
              });
              jQuery('body').one('click', function() {
                jQuery(id).hide();
              });
            };
            onCopySuccess = function(rowCount, clipText) {
              console.log("slickgrid copyManager.onCopySuccess, rows: ", rowCount);
              if (ma.isSafari()) {
                return ma.showTextDialog(clipText);
              }
            };
            copyManagerOptions = {
              includeHeaderWhenCopying: true,
              onCopySuccess: onCopySuccess
            };
            copyManager = new Slick.CellExternalCopyManager(copyManagerOptions);
            grid.registerPlugin(copyManager);

            /*
            copyManager.onCopyCells.subscribe (e, args) ->
              console.log("copyManager.onCopyCells", e, args)
             */
            grid.onHeaderClick.subscribe(function(e, args) {
              if (args.column.id === "rowNumber") {
                e.preventDefault();
                e.stopPropagation();
                showContextMenu(e, args);
              }
            });
            grid.onContextMenu.subscribe(function(e, args) {
              var cell;
              cell = grid.getCellFromEvent(e);
              grid.setSelectedRows([cell.row]);
              grid.setActiveCell(cell.row, cell.cell);
              e.preventDefault();
              return showContextMenu(e, args);
            });
            grid.onBeforeEditCell.subscribe(function(e, args) {
              var column, fldName, rec;
              currentCell = args.cell;
              column = args.column || $scope.area.columns[args.cell];
              fldName = column.field;
              rec = args.item;
              if (!rec) {
                rec = $scope.area.data[args.row];
              }
              if (!rec) {
                return;
              }
              if (rec[fldName]) {
                prevValue = rec[fldName];
              } else {
                prevValue = null;
              }
              return cellChanged = true;
            });
            grid.onActiveCellChanged.subscribe(function(e, args) {
              if (grid.runScriptOnCellExit) {
                if (grid.runScriptOnCellExit.row === args.row && grid.runScriptOnCellExit.cell === args.cell) {
                  runScript(e, args);
                }
                return grid.runScriptOnCellExit = null;
              } else if (cellChanged !== null) {
                return runScript(e, args);
              }
            });
            jQuery('.slick-viewport').on('blur', 'input.editor-text', function(e) {
              window.setTimeout((function() {
                Slick.GlobalEditorLock.commitCurrentEdit();
              }), 0);
            });
            grid.onCellChange.subscribe(function(e, args) {
              return runScript(e, args);
            });
            grid.onAddNewRow.subscribe(function(e, args) {
              var gridData, item;
              item = args.item;
              gridData = dataView.getItems();
              beginUpdate();
              gridData.push(item);
              endUpdate();
              return $scope.$emit("gridAddNewRow", attrs.id, args, $scope.area);
            });
            return dataView.onRowsChanged.subscribe(function(e, args) {
              grid.invalidateRows(args.rows);
              return render();
            });

            /* When user clicks button, fetch data via Ajax, and bind it to the dataview.
            jQuery("#mybutton").click ->
              jQuery.getJSON my_url, (data) ->
                beginUpdate()
                dataView.setItems data
                endUpdate()
             */
          };
          $scope.$watch("area", function(newValue) {
            if (newValue !== void 0) {
              console.log("$scope.$watch area", newValue);
              return redraw(newValue);
            }
          });
          $scope.$on("refresh-ma-grid", function(event, modelToRedraw) {
            if (element.grid) {
              if (modelToRedraw === void 0) {
                console.log("modelToRedraw is undefined");
                return invalidate();
              } else if (modelToRedraw === attrs.id) {
                return invalidate();
              } else if (modelToRedraw === "") {
                console.log("modelToRedraw is ''");
                return invalidate();
              }
            }
          });
          if (!$scope.area) {
            return;
          } else {
            redraw($scope.area);
          }
          moveRowsPlugin = new Slick.RowMoveManager({
            cancelEditOnDrag: true
          });
          moveRowsPlugin.onBeforeMoveRows.subscribe(function(e, data) {
            var i;
            i = 0;
            while (i < data.rows.length) {
              if (data.rows[i] === data.insertBefore || data.rows[i] === data.insertBefore - 1) {
                e.stopPropagation();
                return false;
              }
              i++;
            }
            return true;
          });
          moveRowsPlugin.onMoveRows.subscribe(function(e, args) {
            var extractedRows, gridData, i, insertBefore, left, right, row, rows, selectedRows;
            extractedRows = [];
            left = void 0;
            right = void 0;
            rows = args.rows;
            insertBefore = args.insertBefore;
            gridData = dataView.getItems();
            left = gridData.slice(0, insertBefore);
            right = gridData.slice(insertBefore, gridData.length);
            rows.sort(function(a, b) {
              return a - b;
            });
            i = 0;
            while (i < rows.length) {
              extractedRows.push(gridData[rows[i]]);
              i++;
            }
            rows.reverse();
            i = 0;
            while (i < rows.length) {
              row = rows[i];
              if (row < insertBefore) {
                left.splice(row, 1);
              } else {
                right.splice(row - insertBefore, 1);
              }
              i++;
            }
            gridData = left.concat(extractedRows.concat(right));
            selectedRows = [];
            i = 0;
            while (i < rows.length) {
              selectedRows.push(left.length + i);
              i++;
            }
            grid.resetActiveCell();
            dataView.setData(gridData);
            grid.setSelectedRows(selectedRows);
            return render();
          });
          if (grid) {
            grid.registerPlugin(moveRowsPlugin);
            grid.onDragInit.subscribe(function(e, dd) {
              return e.stopImmediatePropagation();
            });
            grid.onDragStart.subscribe(function(e, dd) {
              var cell, gridData, proxy, selectedRows;
              cell = grid.getCellFromEvent(e);
              if (!cell) {
                return;
              }
              dd.row = cell.row;
              gridData = dataView.getItems();
              if (!gridData[dd.row]) {
                return;
              }
              if (Slick.GlobalEditorLock.isActive()) {
                return;
              }
              e.stopImmediatePropagation();
              dd.mode = "recycle";
              selectedRows = grid.getSelectedRows();
              if (!selectedRows.length || jQuery.inArray(dd.row, selectedRows) === -1) {
                selectedRows = [dd.row];
                grid.setSelectedRows(selectedRows);
              }
              dd.rows = selectedRows;
              dd.count = selectedRows.length;
              proxy = jQuery("<span></span>").css({
                position: "absolute",
                display: "inline-block",
                padding: "4px 10px",
                background: "#e0e0e0",
                border: "1px solid gray",
                "z-index": 99999,
                "-moz-border-radius": "8px",
                "-moz-box-shadow": "2px 2px 6px silver"
              }).text("Drag to Recycle Bin to delete " + dd.count + " selected row(s)").appendTo("body");
              dd.helper = proxy;
              jQuery(dd.available).css("background", "pink");
              return proxy;
            });
            grid.onDrag.subscribe(function(e, dd) {
              if (dd.mode !== "recycle") {
                return;
              }
              e.stopImmediatePropagation();
              return dd.helper.css({
                top: e.pageY + 5,
                left: e.pageX + 5
              });
            });
            grid.onDragEnd.subscribe(function(e, dd) {
              if (dd.mode !== "recycle") {
                return;
              }
              e.stopImmediatePropagation();
              beginUpdate();
              dd.helper.remove();
              endUpdate();
              return jQuery(dd.available).css("background", "beige");
            });
          }
          jQuery.drop({
            mode: "mouse"
          });
          return jQuery("#dropzone").bind("dropstart", function(e, dd) {
            if (dd.mode !== "recycle") {
              return;
            }
            return jQuery(this).css("background", "yellow");
          }).bind("dropend", function(e, dd) {
            if (dd.mode !== "recycle") {
              return;
            }
            return jQuery(dd.available).css("background", "pink");
          }).bind("drop", function(e, dd) {
            var gridData, i, rowsToDelete;
            if (dd.mode !== "recycle") {
              return;
            }
            rowsToDelete = dd.rows.sort().reverse();
            i = 0;
            gridData = dataView.getItems();
            while (i < rowsToDelete.length) {
              gridData.splice(rowsToDelete[i], 1);
              i++;
            }
            invalidate();
            return grid.setSelectedRows([]);
          });
        }

        /*
        grid.onAddNewRow.subscribe (e, args) ->
          item =
            name: "New task"
            complete: false
          jQuery.extend item, args.item
          gridData = dataView.getItems()
          gridData.push item
          grid.invalidateRows [gridData.length - 1]
          grid.updateRowCount()
          render()
         */
      };
    }
  ]);

}).call(this);
