/* eslint-disable */
var fileInfo = "later_nc_extend.js"

// set later to use UTC (the default):
//   later.date.UTC();
// set later to use local time;
later.date.localTime()

var timeZoneOffset = new Date().getTimezoneOffset()*60 // to seconds
toUnixTime = function (dateArr) {
	var ret = []
	if (!dateArr.length){ // not an array, is single value
		ret[0] = Math.floor(dateArr.valueOf()/1000)
	} else {
		for(var i = 0; i < dateArr.length; i++) {
			ret[i] = Math.floor(dateArr[i].valueOf()/1000) - timeZoneOffset
			// valueOf() is unix time with milliseconds, remove milliseconds
		}};
	return ret
}

schedule = function (schedText, count) {
	var sched = later.parse.text(schedText)
	if (sched.error != -1) {
		return "err: schedule error in position " + sched.error + ", ..." + schedText.substring(sched.error-10, sched.error+10) + "..."
	};
	var ret
	if (count < 0) {
		count = Math.abs(count)
		ret = later.schedule(sched).prev(count)
	} else {
		ret = later.schedule(sched).next(count)
	}
	ret = toUnixTime(ret)
	return ret
}

// eslint-disable-next-line no-unused-expressions
fileInfo
