// plugin/vue-renderer/renderer/replace-content.js

export function replaceContent(fileName, content, vue_path, base_path) {
	if (base_path && vue_path) {
		content = content.replace(`from '/vue.js'`, `from '${base_path}/vue.js'`)
		content = content.replace(`from "vue"`, `from '${base_path}/vue.js'`)
		content = content.replace(`from '/assets/`, `from '${base_path}/assets/`)
	} else if (vue_path) {
		content = content.replace(`from '/vue.js'`, `from '${vue_path}'`)
		content = content.replace(`from "vue"`, `from '${vue_path}'`)
	} else if (fileName.indexOf('/') > 0) {
		content = content.replace(`from '/vue.js'`, `from '../../vuelib.js'`)
		content = content.replace(`from "vue"`, `from '../../vuelib.js'`)
	} else {
		content = content.replace(`from '/vue.js'`, `from '../vuelib.js'`)
		content = content.replace(`from "vue"`, `from '../vuelib.js'`)
	}
	content = content.replace(/import (.*)css'/g, '// import $1css')
	content = content.replace('import JsBarcode', '// import JsBarcode')
	content = content.replace('import icons from', '// import icons from')
	content = content.replace('import { Icon', '// import { Icon')
	content = content.replace('components: { Icon', '// components: { Icon')
	if (fileName.indexOf('.js') < 0) {
		fileName = fileName + '.js'
	}
	return `// ${fileName}\n` + content
}
