// preference/form/nc/nc-work-center/nc-work-center-old.js

// employee
function getEmployee() {
	// called from web page
	var data, emp, rec
	rec = state.rec
	data = state.data
	emp = rec.employee_id
	if (emp !== '') {
		// state.rec.data.em.data does not exist
		emp = nc.findCaseInsensitiveRecFromArr(data.em.data, 'employee_id', rec.employee_id)
	}
	if (!emp || emp === '') {
		nc.setRec(state, 'employee_id', '')
		return nc.setRec(state, 'em_whole_name', '')
	} else {
		nc.setRec(state, 'employee_id', emp.employee_id)
		return nc.setRec(state, 'em_whole_name', emp.em_whole_name)
	}
}

function documentGridCallback(eventType, event, gridVm) {
	console.debug('workGridCallback, eventType', eventType, event, event.data.id)
	documentRowClicked(event.data.id - 1)
}

function loadDocument(product_id) {
	console.debug('loadDocument', product_id)
	function callback(ret) {
		var grid, ref
		grid = state.grid && state.grid.document
		if (grid && grid.option) {
			return (grid.option.callback = documentGridCallback)
		}
	}
	nc.callServer(
		state,
		'form/nc/nc-document',
		{
			parameter: {
				state: state.rec.state,
				product: product_id
			}
		},
		callback
	)
}

function workGridCallback(eventType, event, gridVm) {
	/* if eventType is "onCellEditingStarted"
				cellEditingStarted = true
			else if eventType is "onCellEditingStopped"
				cellEditingStarted = false
			else if eventType is "onCellValueChanged"
			*/
	// console.debug("workGridCallback, eventType", eventType, event, event.data.pr_product_id)
	// rowRec = null
	debugger
	if (eventType === 'onRowClicked') {
		rowRec = event.data
		loadDocument(event.data.pr_product_id)
	}
}

function refresh() {
	console.debug('refresh, wo: ', state.data.wo)
	// return state.$forceUpdate()
}
function initButton() {}
function buttonDisabled() {
	return false
}

function editButton(edit, wpaRec, wosRec) {
	var oldWpaRec
	if (!wpaRec) {
		return
	}
	if (edit === 'edit') {
		wpaRec._web_edit = true
		wosRec._disable = true
		oldWpaRec = nc.clone(wpaRec)
	} else if (edit === 'cancel') {
		nc.copyRecord(oldWpaRec, wpaRec)
		wpaRec._web_edit = false
		wosRec._disable = false
		wpaRec._web_state_executing = null
	} else {
		// else if edit is "ok" # this calls clickButton
		//  wpaRec._web_edit = false
		alert('unknown edit state when calling editButton()')
	}
	refresh()
}

function clickButton(state) {
	var callback, parameter, woRec, wosRec, wpaRec
	if (!rowRec) {
		return
	}
	if (!state.rec.employee_id || state.rec.employee_id === '') {
		return
	}
	wosRec = rowRec
	woRec = {}
	wpaRec = {}
	// get production order (wo)
	function callback(ret) {
		var callback2, parameter
		console.debug('query production order')
		if (ret && ret.data && ret.data[0]) {
			woRec = ret.data[0]
			// get start phase (wpa)
			callback2 = function (ret) {
				console.debug('query open phase')
				if (ret && ret.data && ret.data[0]) {
					wpaRec = ret.data[0]
					state.rec.wpa_rec = wpaRec
				}
				clickButtonSave(state, wpaRec, wosRec, woRec)
			}
			parameter = {
				person: state.rec.employee_id,
				production_lot: rowRec.wos_production_lot,
				work_phase_number: rowRec.wos_work_phase
			}
			nc.callServer(
				state,
				'query/data',
				{
					name: 'query/local/product/product_work/work-center/person_open_actual_work_phase.json',
					parameter: parameter
				},
				callback2
			)
		}
	}
	parameter = {
		production_lot: rowRec.wos_production_lot
	}
	return nc.callServer(
		state,
		'query/data',
		{
			name: 'query/local/product/production_order/work-center/work_row_production_order.json',
			parameter: parameter
		},
		callback
	)
}

function clickButtonSave(state, wpaRec, wosRec, woRec) {
	var employee, parameter, pauseOther, queryParam, wo, wos, wpa
	if (!wosRec || !woRec) {
		// in "start" wpaRec is null
		return
	}
	// _web_state
	// wpaRec is nil in start
	if (state !== 'save' && wpaRec && (wpaRec._web_edit === true || wpaRec._web_state === state)) {
		return
	}
	employee = state.rec.employee_id
	parameter = {}
	pauseOther = false
	if (state === 'setup') {
		queryParam = {
			employee: employee,
			production_lot: wosRec.wos_production_lot,
			work_phase: wosRec.wos_work_phase
		}
		wos = {
			employee: employee,
			wos_production_lot: wosRec.wos_production_lot,
			wos_work_phase: wosRec.wos_work_phase,
			wos_work_load_group_id: wosRec.wos_work_load_group_id,
			wos_record_id: wosRec.wos_record_id,
			wo_record_id: woRec.wo_record_id
		}
		parameter = {
			action: state,
			query_param: queryParam,
			rec: wos
		}
	} else if (state === 'start') {
		pauseOther = state.rec.pause_other
		wos = [
			{
				wos_work_load_group_id: wosRec.wos_work_load_group_id,
				wos_production_lot: wosRec.wos_production_lot,
				wos_work_phase: wosRec.wos_work_phase,
				wos_record_id: wosRec.wos_record_id
			}
		]
		wo = [
			{
				wo_record_id: woRec.wo_record_id,
				wos: wos
			}
		]
		parameter = {
			action: state,
			structure: {
				wo: wo
			},
			parameter: {
				employee: employee,
				production_lot: wosRec.wos_production_lot,
				work_phase: wosRec.wos_work_phase
			},
			array: {}
		}
	} else if (state === 'pause') {
		// wpa = [{"wpa_info": wpaRec.wpa_info, "wpa_record_id": wpaRec.wpa_record_id}]
		wpa = [wpaRec]
		wos = [
			{
				wos_work_load_group_id: wosRec.wos_work_load_group_id,
				wos_production_lot: wosRec.wos_production_lot,
				wos_work_phase: wosRec.wos_work_phase,
				wos_record_id: wosRec.wos_record_id,
				wpa: wpa
			}
		]
		wo = [
			{
				wo_record_id: woRec.wo_record_id,
				wos: wos
			}
		]
		parameter = {
			action: state,
			structure: {
				wo: wo
			},
			parameter: {
				employee: state.rec.employee_id
			},
			array: {}
		}
		// , employee: wpaRec.start_emloyee_id
	} else if (state === 'continue') {
		pauseOther = state.rec.pause_other
		queryParam = {
			wpa_record_id: wpaRec.wpa_record_id
		}
		// wpa = [{"wpa_info": wpaRec.wpa_info, "wpa_record_id": wpaRec.wpa_record_id}]
		wpa = [wpaRec]
		wos = [
			{
				wos_work_load_group_id: wosRec.wos_work_load_group_id,
				wos_production_lot: wosRec.wos_production_lot,
				wos_work_phase: wosRec.wos_work_phase,
				wos_record_id: wosRec.wos_record_id,
				wpa: wpa
			}
		]
		wo = [
			{
				wo_record_id: woRec.wo_record_id,
				wos: wos
			}
		]
		parameter = {
			action: state,
			structure: {
				wo: wo
			},
			parameter: {
				employee: state.rec.employee_id
			},
			array: {}
		}
	} else if (state === 'stop') {
		wpaRec = state.rec.wpa_rec
		wpaRec._web_edit = true
		wpaRec._web_state_executing = 'stop'
		// clear field values because of coming from pause state
		wpaRec.wpa_date_ = '0000-00-00'
		wpaRec.wpa_end_time = '00:00:00'
		if (wpaRec.wpa_work_time__amount === 0) {
			wpaRec.wpa_work_time__amount = '' // easier to enter number
		}
		if (wpaRec.wpa_produced_amount === 0) {
			wpaRec.wpa_produced_amount = ''
		}
		editButton('edit', wpaRec, wosRec)
		return
	} else if (state === 'save' && wpaRec._web_state_executing && wpaRec._web_state_executing === 'stop') {
		wpaRec = state.rec.wpa_rec
		if (wpaRec.wpa_work_time__amount === '') {
			wpaRec.wpa_work_time__amount = 0
		}
		if (wpaRec.wpa_produced_amount === '') {
			wpaRec.wpa_produced_amount = 0
		}
		wpaRec._web_edit = false
		wpaRec._web_state_executing = null
		queryParam = {
			wpa_record_id: wpaRec.wpa_record_id
		}
		// wpa = [{"wpa_info": wpaRec.wpa_info, "wpa_record_id": wpaRec.wpa_record_id}]
		wpa = [wpaRec]
		wos = [
			{
				wos_work_load_group_id: wosRec.wos_work_load_group_id,
				wos_production_lot: wosRec.wos_production_lot,
				wos_work_phase: wosRec.wos_work_phase,
				wos_record_id: wosRec.wos_record_id,
				wpa: wpa
			}
		]
		wo = [
			{
				wo_record_id: woRec.wo_record_id,
				wos: wos
			}
		]
		parameter = {
			action: 'stop',
			structure: {
				wo: wo
			},
			parameter: {
				employee: state.rec.employee_id,
				check_previous_phase_produced_amount: state.rec.check_previous_phase_produced_amount
			},
			array: {}
		}
	} else if (state === 'save') {
		wpaRec._web_edit = false
		// wpa = [{"wpa_produced_amount": wpaRec.wpa_produced_amount, "wpa_work_time__amount": wpaRec.wpa_work_time__amount, "wpa_date_": wpaRec.wpa_date_, "wpa_end_time": wpaRec.wpa_end_time, "wpa_info": wpaRec.wpa_info, "wpa_record_id": wpaRec.wpa_record_id}]
		wpa = [wpaRec]
		wos = [
			{
				wos_record_id: wosRec.wos_record_id,
				wpa: wpa
			}
		]
		wo = [
			{
				wo_record_id: woRec.wo_record_id,
				wos: wos
			}
		]
		parameter = {
			action: state,
			structure: {
				wo: wo
			},
			parameter: {
				employee: state.rec.employee_id,
				check_previous_phase_produced_amount: state.rec.check_previous_phase_produced_amount
			},
			array: {}
		}
	}
	wosRec._disable = false
	save(parameter, pauseOther)
}

function save(parameter, pauseOther) {
	var arr, em, endTime
	em = state.data.em
	arr = [] // collect same user in run state
	endTime = ''
	function setPause() {
		function setPauseCallback() {
			if (arr.length > 0) {
				arr.shift() // Remove the first item of an array
				return setPause()
			}
		}
		parameter = {
			x: arr[0]
		}
		nc.callServer(
			state,
			'run/preference',
			{
				name: 'form/nc/nc-work-center-gig/call.json',
				parameter: parameter
			},
			setPauseCallback
		)
	}
	if (arr.length > 0) {
		setPause()
	}
	function callback(ret) {
		state.data.em = em
		if (state.rec.clear_after_save === true) {
			if (ret.data == null || typeof ret.data !== 'string' || ret.data === '') {
				// no error message from lua
				nc.setRec(state, 'employee_id', '')
				nc.setRec(state, 'em_whole_name', '')
				nc.setRec(state, 'wo_work_order_id', '')
				query()
			}
		}
		if (parameter.action === 'stop' && ret.status === 'ok' && typeof ret.data !== 'string') {
			// not error message in data
			message.setSuccess(state.hdr.work_center_gig.save_ok)
			setTimeout(() => {
				message.setSuccess('')
			}, state.rec.save_ok_show_time) // show save_ok for 5 seconds
		}
	}
	nc.callServer(
		state,
		'run/preference',
		{
			name: 'form/nc/nc-work-center-gig/call.json',
			parameter: parameter
		},
		callback
	)
}
