// preference/form/nc/erp-sync/erp-sync.js
const recData = nc.recData
const recDataSet = nc.recDataSet
const loc = reactive({
	prevCall: '',
	selectedRecord: { local: null, external: null },
	tabIndex: 0, // { local: 0, external: 0 }. tabIndex is same for both, there is only one tab for both areas
	tabPrevLoadTime: 0,
	tabRefreshSeconds: 1.0,
	sort: {},
	columnState: {}
})

function tabChanged(value, idx) {
	// tabChanged(value, idx, event, tabArrValue)
	if (idx === loc.tabIndex) {
		let newTime = new Date()
		if (dt.secondsBetween(loc.tabPrevLoadTime, newTime) < loc.tabRefreshSeconds) {
			return
		}
	}
	if (!nc.isNil(idx)) loc.tabIndex = idx
	// loc.tabIndex.external = loc.tabIndex // external tab is not shown, keep tabs in sync
	loc.selectedRecord.local = null // this.$set(loc.selectedRecord, 'local', null)
	loc.selectedRecord.external = null // this.$set(loc.selectedRecord, 'external', null)
	nc.setGrid(state, 'local', Object.assign({ data: [] }, state.grid.local))
	nc.setGrid(state, 'external', Object.assign({ data: [] }, state.grid.external))
	state.grid.local.data = []
	state.grid.external.data = [] // clear data from screen
	let table = state.rec.default_tab[state.rec.connection] // tabValue('local')
	nc.gotoUrl(state, {
		name: 'erp-sync',
		query: { table: table, connection: state.rec.connection } // + '?connection=' + state.rec.connection
	})
	if (value == 'connection') {
		loadRows('local', 0, 'created') // will call init
	} else {
		loadRows('local', 0)
		loadRows('external', 0)
	}
	loc.tabPrevLoadTime = new Date()
}

// eslint-disable-next-line no-unused-vars
function showRows() {
	nc.grid.updateFilter(state, 'local')
	nc.grid.updateFilter(state, 'external')
}

function tabRec(area) {
	area = 'local' // always use local, external tab does not exist
	let idx = loc.tabIndex
	if (nc.isNil(idx)) return
	return state.arr && state.arr.tab && state.arr.tab[area] && state.arr.tab[area][idx]
}
function tabValue(area) {
	const item = tabRec(area)
	return (item && item.value) || '' // maybe item.table?
}

function getRowTablePrefix(table) {
	return state.rec.table_prefix[table] + 'r'
}

// eslint-disable-next-line no-unused-vars
function gridSortChanged(area, columnState) {
	const areaName = tabValue(area)
	loc.columnState[areaName] = columnState
}

function gridRowClicked(area, rowIndex, selected, event) {
	// loc.selectedRecord[area] must be used in buttonEnabled() to trigger calls to buttonEnabled()
	let arr = selectedRecordArr(area)
	const area2 = otherArea(area)
	loc.selectedRecord[area] = null // force change, trigger buttonEnabled() call
	loc.selectedRecord[area2] = null
	if (event && event.data.link_rec_idx >= 0) {
		nc.grid.activateRows(state, area2, event.data.link_rec_idx + 1, 'scroll-first', 'unselectOther')
	}
	if (selected) {
		const table = tabValue(area)
		if (state.rec.one_row_select[state.rec.connection][table]) {
			nc.grid.activateRows(state, area, rowIndex + 1, 'scroll-first', 'unselectOther')
		}
		loadRecordRows(area, arr[0])
		loc.selectedRecord[area] = arr[0]
	}
}

function setCreditNoteRow(rec, data) {
	if (!rec.ordr) {
		message.setWarning(state, `no order row data for order '${rec.order_id}'`)
	} else {
		const moloniProductIdArr = nc.createIndexArray(data.ordr, 'product_id')
		// eslint-disable-next-line no-inner-declarations
		function setRow(item, moloniRec) {
			if (item.json_data == null) {
				item.json_data = {}
			}
			item.json_data.transfer_id = moloniRec.json_data.document_product_id
		}
		rec.ordr.forEach((item, index) => {
			if (!data.ordr) {
				message.setWarning(state, `no Moloni order row data for product '${item.product_id}' invoice row ${index + 1}`)
			} else {
				const moloniRecArr = moloniProductIdArr[item.product_id]
				if (!moloniRecArr || moloniRecArr.length < 1) {
					message.setWarning(state, `no Moloni order row product found, product '${item.product_id}', invoice row ${index + 1}`)
				} else {
					moloniRecArr.sort(nc.dynamicSort(['delivery_amount', '>', 'unit_price', '>']))
					let used = false
					let amount = item.delivery_amount
					if (amount < 0) {
						amount = -amount
					}
					for (let moloniRec of moloniRecArr) {
						if (!used && !moloniRec.calc_used && amount === moloniRec.delivery_amount && item.unit_price <= moloniRec.unit_price) {
							used = true
							moloniRec.calc_used = true
							setRow(item, moloniRec)
							break
						}
					}
					if (!used) {
						for (let moloniRec of moloniRecArr) {
							if (!used && !moloniRec.calc_used && amount <= moloniRec.delivery_amount && item.unit_price <= moloniRec.unit_price) {
								used = true
								moloniRec.calc_used = true
								setRow(item, moloniRec)
								break
							}
						}
					}
					if (!used) {
						for (let moloniRec of moloniRecArr) {
							if (!used && amount <= moloniRec.delivery_amount && item.unit_price <= moloniRec.unit_price) {
								used = true
								moloniRec.calc_used = true
								setRow(item, moloniRec)
								break
							}
						}
					}
					if (!used) {
						message.setWarning(state, `could not find Moloni invoice row for, product '${item.product_id}', invoice row ${index + 1}`)
					}
				}
			}
		})
	}
}

function loadRecordRows(area, rec) {
	console.debug('loadRecordRows', area, rec)
	let grid = state.grid[area]
	let table = tabValue(area)
	const rowTable = state.rec.load_row_table[table]
	if (area === 'local' && grid && rowTable) {
		const rowTablePrefix = getRowTablePrefix(table)
		const compareField = state.rec.compare_field[table]
		const param = {
			name: `form/nc/erp-sync/${state.rec.connection}/query-${state.rec.main_connection}/${rowTable}.json`,
			parameter: {
				[compareField]: rec[compareField],
				column: `form/nc/erp-sync/${state.rec.connection}/column/${rowTable}.json`
			}
		}
		nc.callServer(state, 'query/data', param, ret => {
			if (ret.data) {
				rec[rowTablePrefix] = ret.data
				console.debug(`loadRecordRows callback rec, result: `, rec, ret)
			}
		})
		const externalRowTable = state.rec.load_external_row_table[table]
		if (externalRowTable) {
			const param = {
				name: `form/nc/erp-sync/${state.rec.connection}/query/${externalRowTable.table}.json`,
				parameter: {
					[externalRowTable.parameter]: recData(rec, externalRowTable.field),
					column: `form/nc/erp-sync/${state.rec.connection}/column/${externalRowTable.table}.json`
				}
			}
			nc.callServer(state, 'query/data', param, ret => {
				if (ret.data && ret.data.length > 0) {
					const data = ret.data[0]
					rec[rowTablePrefix + '-' + state.rec.connection] = data
					if (externalRowTable.set_field) {
						externalRowTable.set_field.forEach(item => {
							const val = recData(data, item.from)
							if (val != null) {
								recDataSet(rec, item.to, val)
							}
						})
						if (rowTable == 'order_row-credit_note') {
							setCreditNoteRow(rec, data)
						}
						nc.grid.redrawRows(state, area)
					}
					console.debug(`loadRecordRows external callback rec, result: `, rec, ret)
				}
			})
		}
	}
}

function loadRows(area, rowIndex, event) {
	let table = tabValue(area)
	const call = {}
	let callback = data => {
		if (data) {
			changeConnection()
			let arr = data?.grid
			if (state.rec.sort_order && arr && arr[area]?.data && state.rec.sort_allowed?.[state.rec.connection]?.[table] != false) {
				arr = arr[area].data
				let compareField = state.rec.compare_field[table]
				if (compareField && arr && arr[0] && arr[0][compareField]) {
					arr.sort(nc.dynamicSort([compareField, state.rec.sort_order]))
				}
			}
			setGridData(area, loc.grid || state.grid, data)
			if (loc.grid) {
				table = tabValue(area)
				if (table && state.grid && state.grid.sort) {
					if (loc.columnState[table]) {
						state.grid.sort = loc.columnState[table]
					} else {
						loc.columnState[table] = state.grid.sort
					}
				}
				if (!nc.isNil(rowIndex)) {
					gridRowClicked(otherArea(area), rowIndex, true)
				}
			}
		}
	}
	function queryTab(area) {
		call.name = 'form/nc/erp-sync/' + state.rec.connection + '/grid.json'
		call.return = {
			grid: [
				{
					name: area,
					tab: tabValue(area),
					organization_id: area == 'external' ? state.rec.connection : undefined
				}
			]
		}
		nc.callServer(state, 'query', call, callback)
	}
	if (event !== 'created' && table !== '') {
		queryTab(area)
	} else {
		// first call, set tab index on callback
		call.name = 'form/nc/erp-sync/init.json'
		let connection = nc.searchParameter('connection')
		table = nc.searchParameter('table')
		if (connection || table) {
			call.parameter = {}
			if (connection) {
				// todo: check connection validity
				call.parameter.connection = connection
				state.rec.connection = connection
			}
			if (table) {
				call.parameter.table = table // todo: check table validity
				state.rec.table = table
			}
		}
		nc.setGrid(state, 'local', null)
		nc.setGrid(state, 'external', null)
		if (state.rec.connection) {
			call.grid = 'form/nc/erp-sync/' + state.rec.connection + '/grid.json'
		}
		nc.callServer(state, 'query', call, ret => {
			if (ret && ret.rec && ret.rec.tab) {
				for (let area in ret.rec.tab) {
					if (area === 'local') {
						// only local tab is in use
						let idx = nc.recordArrayIndex(state.arr.tab[area], 'value', ret.rec.tab[area])
						if (!nc.isNil(idx) && idx !== loc.tabIndex) {
							if (idx < 0) {
								// ne need this for error, we may have changed connection and old table does not exist any more
								// message.setError(state, `tab index default value '${ret.rec.tab[area]}' was not found from tab array`)
								idx = 0
							}
							console.debug('+++++ loc.tabIndex', idx, loc.tabIndex)
							loc.tabPrevLoadTime = new Date() // prevent double-load
							loc.tabIndex = idx // this.$set(loc.tabIndex, area, idx)
						}
						loadRows('local') // local load is much faster, better to draw it first
						loadRows('external')
					}
					callback(ret)
				}
			}
		})
	}
}

function selectedRecordArr(area) {
	return nc.grid.activatedRecordArr(state, area)
}

// eslint-disable-next-line no-unused-vars
function buttonEnabled(button) {
	if (!state.rec.import_allowed) {
		return false // page has not been initialized yet
	}
	if (button === 'export') {
		let area = 'local'
		let table = tabValue(area)
		let allowed = state.rec.export_allowed[state.rec.connection]
		allowed = allowed && allowed[table]
		if (loc.selectedRecord[area] && allowed) {
			let arr = selectedRecordArr(area)
			if (arr.length < 1) return
			if (state.rec.load_row_table[table]) {
				let rowPrefix = getRowTablePrefix(table)
				return arr[0][rowPrefix] != null
			}
			return true
		}
		return false
	} else if (button === 'import') {
		let area = 'external'
		let table = tabValue(area)
		let allowed = state.rec.import_allowed[state.rec.connection]
		allowed = allowed && allowed[table]
		if (loc.selectedRecord[area] && allowed) {
			let arr = selectedRecordArr(area)
			if (arr.length > 0) {
				let updateAllowed = state.rec.update_allowed[state.rec.connection]
				updateAllowed = updateAllowed && updateAllowed[table]
				if (updateAllowed) {
					return arr.every(item => {
						if (item.product_id) {
							return item.product_id && (item.change_status === 'new' || item.change_status === 'changed')
						}
						return item.change_status === 'new' || item.change_status === 'changed'
					})
				}
				return arr.every(item => {
					return item.change_status === 'new'
				})
			}
		}
		return false
	} else if (button === 'delete') {
		let area = 'external'
		let table = tabValue(area)
		let deleteAllowed = state.rec.update_allowed[state.rec.connection]
		deleteAllowed = deleteAllowed && deleteAllowed[table]
		if (loc.selectedRecord[area] && deleteAllowed) {
			let arr = selectedRecordArr(area)
			if (arr.length < 1) return false
			if (arr[0][state.rec.compare_field] === '') {
				return false
			}
			return true
		}
		return false
	}
	return false
}

// eslint-disable-next-line no-unused-vars
function isExternalFilterPresent() {
	if (state.rec.show_new !== true || state.rec.show_changed !== true || state.rec.show_equal !== true) {
		return true
	}
	return false
}

// eslint-disable-next-line no-unused-vars
function doesExternalFilterPass(node) {
	switch (node.data.change_status) {
		case 'new':
			return !(state.rec.show_new === false)
		case 'equal':
			return !(state.rec.show_equal === false)
		case 'changed':
			return !(state.rec.show_changed === false)
		default:
			return true
	}
}

function setGridData(area, grid) {
	let table = tabValue(area)
	let localData = grid && grid.local && grid.local.data
	let externalData = grid && grid.external && grid.external.data
	let otherIdx = -1
	let tablePrefix = state.rec.table_prefix[table]
	let compareField = state.rec.compare_field[table]
	const exportField = state.rec.export_save_field[table]
	const exportSaveArr = []
	const roundDecimals = state.rec.round_decimals
	const fixVatPrice = state.rec.fix_vat_price[state.rec.connection] && state.rec.fix_vat_price[state.rec.connection][table]
	let fixVatPriceError = false
	if (localData && localData.length > 0) {
		// init local calculated data
		for (let i = 0; i < localData.length; i++) {
			let rec = localData[i]
			rec.link_rec_idx = -1
			rec.link_rec = null
			rec.change_status = 'new'
			if (fixVatPrice) {
				const price = nc.round(rec.price_without_vat + rec.vat_price, roundDecimals)
				if (isNaN(price) == true) {
					if (!fixVatPriceError) {
						fixVatPriceError = true
						message.setWarning(
							state,
							`Vat price could not be calculated, check fields price_without_vat: ${rec.price_without_vat}, vat_price: ${rec.vat_price}, price_with_vat: ${rec.price_with_vat}`
						)
					}
				} else {
					rec.price_with_vat = price
					if (rec.price_with_vat < 0) {
						rec.price_with_vat = -rec.price_with_vat
					}
					if (rec.vat_price < 0) {
						rec.vat_price = -rec.vat_price
					}
					if (rec.price_without_vat < 0) {
						rec.price_without_vat = -rec.price_without_vat
					}
				}
			}
		}
	}
	if (externalData && externalData.length > 0) {
		// init external calculated data and set status on both data
		if (fixVatPrice && externalData[0].price_with_vat == null) {
			for (let i = 0; i < externalData.length; i++) {
				let rec = externalData[i]
				rec.price_with_vat = Number(rec.price_without_vat)
				rec.vat_price = Number(rec.vat_price)
				rec.price_without_vat = nc.round(rec.price_with_vat - rec.vat_price, roundDecimals)
			}
		}
		/* if (localData && localData.length > 0) {
			const setFromField = grid.external.column
				.filter(rec => rec.set_from_field != null)
				.reduce((acc, rec) => {
					acc.push({ from: peg.parseAfter(rec.set_from_field, tablePrefix + '.'), to: peg.parseAfter(rec.field, tablePrefix + '.') })
					return acc
				}, [])
			setFromField.forEach(item => {}) // copy data from local to external
		} */
		let dateField = grid.external.column
			.filter(rec => rec.type === 'date')
			.reduce((acc, rec) => {
				acc.push(peg.parseAfter(rec.field, tablePrefix + '.'))
				return acc
			}, [])
		let doNotCompareField = grid.external.column
			.filter(rec => rec.change_compare === false)
			.reduce((acc, rec) => {
				let fld = rec.field || rec.variable
				fld = peg.parseAfter(fld, tablePrefix + '.')
				acc[fld] = fld.change_compare || true
				return acc
			}, {})
		doNotCompareField.link_rec_idx = true
		doNotCompareField.link_rec = true
		doNotCompareField.change_status = true
		const compareAmount = state.rec.compare_amount
		window.recDataCompare = function (rec, field, value) {
			// function for grid cell_class_rules compare
			const fldValue = recData(rec, field)
			if (fldValue == value) {
				return true
			}
			if (compareAmount && (typeof fldValue === 'number' || typeof value === 'number')) {
				if (Math.abs(Number(fldValue) - Number(value)) < compareAmount) {
					return true
				}
			}
			return false
		}
		const loadExternalTable = state.rec.load_external_table && state.rec.load_external_table[state.rec.connection] && state.rec.load_external_table[state.rec.connection][table]

		const compareRecord = (extRec, i) => {
			if (compareField == null) return
			let compareData = recData(extRec, compareField)
			if (!extRec || nc.isNil(compareData)) {
				message.setWarning(state, `table '${table}' local data compare field '${compareField}' data is null`)
				return false
			}
			for (const key of dateField) {
				extRec[key] = peg.parseBefore(extRec[key], 'T') // does not work with object fields
			}
			if (localData && localData.length > 0 && localData[0] && externalData[0]) {
				let prevErrorField
				otherIdx = localData.findIndex(localRec => {
					let localCompareData = recData(localRec, compareField)
					if (!localRec || nc.isNil(localCompareData)) {
						if (extRec && !nc.isNil(compareData)) {
							// no warning if both are null
							if (prevErrorField !== compareField) {
								message.setWarning(state, `table '${table}' external data compare field '${compareField}' data is null`)
							}
						}
						return false
					}
					// 1 and "1" must be true here. so do not use ===, use ==
					// eslint-disable-next-line eqeqeq
					// compareData.toString().toLowerCase() == localCompareData.toString().toLowerCase()
					compareData = compareData.toString().toLowerCase().trimEnd()
					localCompareData = localCompareData.toString().toLowerCase().trimEnd()
					const equal = compareData == localCompareData
					if (equal) {
						return true
					}
					return false
				})
			}
			if (loadExternalTable && loadExternalTable.set_field) {
				// loadExternalTable has been set to state.rec.load_external_table[connection][table]
				loadExternalTable.set_field.forEach(item => {
					let localValue
					if (otherIdx >= 0) {
						localValue = recData(localData[otherIdx], item.from)
					}
					if (localValue != null) {
						recDataSet(extRec, item.to, localValue) // set local data to external
					} else if (item.default_value != null) {
						recDataSet(extRec, item.to, item.default_value) // set local data to external
					}
				})
			}
			if (otherIdx >= 0) {
				extRec.link_rec_idx = otherIdx
				const localRec = localData[otherIdx]
				extRec.link_rec = localRec
				// extRec.record_id = localRec.record_id
				const failField = {} // for debugging changes
				if (extRec.note) {
					// only \n in local version, remove \r
					extRec.note = peg.replace(extRec.note, '\r', '')
				}
				extRec.change_status = nc.isEqualLoose(extRec, localRec, doNotCompareField, state.rec.warning_char, failField, null, compareAmount) ? 'equal' : 'changed'
				if (extRec.change_status === 'changed') {
					console.log(`🚀 ~ file: erp-sync.js ~ compareRecord ~ failField`, failField)
				}
				localData[otherIdx].link_rec_idx = i
				localData[otherIdx].link_rec = extRec // link_rec will be circular reference
				localData[otherIdx].change_status = extRec.change_status
				if (exportField) {
					const localId = recData(localRec, exportField)
					const extId = recData(extRec, exportField)
					if (localId != extId) {
						// != means allow num / string comparison
						const saveItem = {
							record_id: localRec.record_id,
							[exportField]: extId
						}
						exportSaveArr.push(saveItem)
					}
				}
			} else {
				// console.debug(state, `   local record was not found for compareData, tablePrefix '${tablePrefix}' compareField '${compareField}', table '${table}'`)
				extRec.link_rec = null
				extRec.link_rec_idx = -1
				extRec.change_status = 'new'
				/* 	if (compareData != null) {
							recDataSet(extRec, compareField, '')
						} */
				extRec.record_id = ''
			}
		}
		// debugger
		for (let i = 0; i < externalData.length; i++) {
			compareRecord(externalData[i], i)
		}
		if (exportField && exportSaveArr.length > 0) {
			if (loc.prevCall === 'area-local') {
				loc.prevCall = '' // exit save/load loop after local rows load
			} else {
				if (loc.prevCall === 'export-id') {
					loc.prevCall = 'area-local' // load local rows after save
					loadRows('local')
				} else {
					loc.prevCall = 'export-id'
					saveRows('local', 'export-id', [{ table: table, data: exportSaveArr }]) // save_preference: save/generic_save.json
				}
			}
		}
		// update grids
		nc.setGrid(state, 'local', Object.assign({}, state.grid.local))
		nc.setGrid(state, 'external', Object.assign({}, state.grid.external))
	}
}

function changeConnection(updateData) {
	if (updateData) {
		tabChanged('connection')
	}
	if (state.rec && state.rec.logo_path_external_template)
		nc.setRec(state, 'logo_path_external', state.rec.logo_path_external_template.replace('_connection_', state.rec.connection))
}

function otherArea(area) {
	return area === 'local' ? 'external' : 'local'
}
function saveRows(area, action, saveData) {
	let table = tabValue(area)
	const tablePrefix = state.rec.table_prefix[table]
	if (!tablePrefix) {
		alert(`save table '${table}' is not valid`)
		return
	}
	const column = state.grid[area].column
	if (!column || column.length < 1) {
		alert(`save table '${table}' column do not exist`)
		return
	}
	// debugger
	let arr, changeStatus
	if (action !== 'export-id') {
		let arrOrig = selectedRecordArr(area)
		changeStatus = arrOrig[0].change_status
		if (changeStatus && changeStatus !== 'new' && changeStatus !== 'changed') {
			alert(`You can ${action} only new or changed records, table '${table}'`)
			return
		}
		let deleteKey
		if (action === 'import' || action === 'export') {
			deleteKey = column
				.filter(item => item[action] === false)
				.reduce((acc, rec) => {
					acc.push(peg.parseAfter(rec.field, tablePrefix + '.'))
					return acc
				}, [])
		}
		const doNotCloneFields = ['link_rec_idx', 'link_rec'] // , 'record_id'
		arr = nc.clone(arrOrig, doNotCloneFields)
		for (const item of arr) {
			// this will delete fields from grid array, reload later to fix them
			if (item.change_status !== changeStatus) {
				alert(`Save can contain only one type at a same time, table '${table}', save type '${changeStatus}'`)
				return
			}
			if (deleteKey) {
				for (const key of deleteKey) {
					delete item[key]
				}
			}
			if (item.change_status === 'new') {
				delete item.record_id
				delete item.change_id
			}
			delete item.change_status
		}
	}
	let param = {}
	let preferenceName
	if (action === 'import') {
		preferenceName = 'form/nc/erp-sync/' + state.rec.main_connection + '/save/' + table + '.json'
		param.save = [{ table: table, data: arr, save_preference: preferenceName }]
	} else if (action === 'export-id') {
		param.save = saveData
	} else if (action === 'export') {
		preferenceName = 'form/nc/erp-sync/' + state.rec.connection + '/save/' + table + '.json'
		param.save = [{ table: table, data: arr, save_preference: preferenceName }]
	} else if (action === 'delete') {
		const compareField = state.rec.compare_field[table]
		const doDelete = confirm(`Are you sure you want to delete ${table} id ${recData(arr[0], compareField)} ?`)
		if (doDelete === false) {
			return
		}
		const arr2 = arr.map(rec => {
			return rec.json_data.transfer_id
		})
		param.delete = [{ table: table, data: arr2 }]
	} else {
		message.setWarning(state, 'action is not export or delete')
		return
	}
	if (param.save && changeStatus === 'changed') {
		param.save[0].parameter = { call_tag: 'call_update_url' }
	}
	let run = state.rec.export_allowed[state.rec.connection]
	run = run && run[table] && run[table].run
	if (typeof run === 'string' || typeof run === 'object') {
		param.run = run
		// param.save = [{ table: table, data: arr, save_preference: preferenceName }]
	}
	nc.callServer(state, 'save', param, ret => {
		if (ret.status === 'ok') {
			loadRows(otherArea(area))
		}
		if (ret.result) {
			alert(ret.result)
		}
	})
}

function init() {
	console.debug('nc-erp-sync created')
	if (!state.grid?.local?.data?.length) {
		// lod if grid does not exist or length is 0
		loadRows('local', 0, 'created') // first call will be init, it will load both areas at the same call
	} else if (!state.grid?.external?.data) {
		loadRows('external', 0) //  local data is loaded on first load, but external is not
	}
}
init()
