// form/nc/report/delivery-reliability/delivery-reliability.js

function pageInit(ret) {
	const selectionId = nc.searchParameter('id')
	if (selectionId) {
		rec.query_type = 'selection'
		rec.selection_id = selectionId
	} else {
		rec.query_type = 'time_period'
		rec.selection_id = ''
	}
	if (ret) {
		return callServerCallback(ret)
	}
}

let queryType, selectionId, updateTimeout
function callServerCallback(ret) {
	rec.query_type = queryType // restore after init call
	rec.selection_id = selectionId
	rec.company = ''
	rec.days_total = 0
	rec.query_start_date = rec.start_date
	rec.query_end_date = rec.end_date
	rec.query_warning = ''
	const data = state.grid?.order_row?.data
	if (data) {
		// add mapped columns for debug
		ret.grid.order_row.columns.push({
			field: 'day_difference',
			width: 80,
			name: 'day_difference'
		})
		ret.grid.order_row.columns.push({
			field: 'target_date',
			width: 160,
			name: 'target_date'
		})
	}
	// setDropdown(state, data)
	if (updateTimeout) {
		clearTimeout(updateTimeout)
	}
	if (rec.update_seconds > 0) {
		updateTimeout = setTimeout(() => {
			callServer('init')
		}, rec.update_seconds * 1000)
	}
}

function callServer(action) {
	queryType = rec.query_type // save now and restore aftef rest call
	selectionId = rec.selection_id
	if (action === 'update') {
		if (rec.query_type === 'selection') {
			const param = {
				selection_id: rec.selection_id
			}
			nc.callServer(
				state,
				'query',
				{
					name: 'dialog/delivery_reliability/delivery_reliability_grid_selection.json',
					parameter: param
				},
				callServerCallback
			)
		} else {
			const param = {
				start_date: rec.start_date, // dt.dateToString(rec.start_date),
				end_date: rec.end_date // dt.dateToString(rec.end_date)
			}
			nc.callServer(
				state,
				'query',
				{
					name: 'form/nc/report/delivery-reliability/grid.json',
					parameter: param
				},
				callServerCallback
			)
		}
	} else {
		if (rec.query_type === 'selection') {
			const param = {
				selection_id: rec.selection_id
			}
			nc.callServer(
				state,
				'query',
				{
					name: 'dialog/delivery_reliability/query_init_selection.json',
					parameter: param
				},
				callServerCallback
			)
		} else {
			nc.callServer(
				state,
				'query',
				{
					name: 'dialog/delivery_reliability/query_init.json'
				},
				callServerCallback
			)
		}
	}
}

function setDropdown(state, data) {
	const found = {}
	debugger
	let dropdown = data
		.filter(function (rec) {
			var date
			// filter out data that is not in selected date range
			if (rec.query_type !== 'time_period') {
				return true
			}
			date = nc.parseDate(rec.order_row_delivery_date)
			return date >= rec.start_date && date <= rec.end_date
		})
		.reduce(function (result, rec) {
			if (!found[rec.so_company_id]) {
				found[rec.so_company_id] = true
				// if data.find( (element) -> return element.so_company_id is rec.so_company_id )
				result.push({
					show: rec.co_name + ' - ' + rec.so_company_id,
					value: rec.so_company_id
				})
			}
			return result
		}, [])
	dropdown.order_rowt(nc.dynamicSort('show', '>'))
	dropdown.unshift({
		show: state.hdr.delivery_reliability && state.hdr.delivery_reliability.all_suppliers,
		value: ''
	})
	return nc.setDropdownup(state, 'company', dropdown)
}

// eslint-disable-next-line no-unused-vars
function drawChart(chartId) {
	// called from layout html
	// debugger
	const rowData = state.grid?.order_row?.data
	if (!rowData) {
		return
	}
	// return
	const data = rec.chart_data
	const chart = null // rec.chart // fis this
	if (!(chartId && data && chart && chart.definition)) {
		return
	}
	const param = {}
	const retArr = nc.map(state, rowData, 'day_difference', param) // todo: create nc.map() function
	let count = 0
	let inTimeCount = 0
	const warning = []
	setDropdown(state, rowData)
	let filteredData = data.map(function (dataRec) {
		dataRec.amount = retArr
			.filter(function (rec) {
				var date
				if (rec.so_company_id !== rec.company && rec.company !== '') {
					return false
				}
				if (rec.query_type !== 'time_period') {
					return true
				}
				date = nc.parseDate(rec.order_row_delivery_date)
				return date >= rec.start_date && date <= rec.end_date
			})
			.reduce(function (sum, rec) {
				// use nc.arrayStartStopRecord()
				if ((dataRec.start === null || rec.day_difference > dataRec.start) && (dataRec.stop === null || rec.day_difference <= dataRec.stop)) {
					count = count + 1
					if (dataRec.stop !== null && dataRec.stop <= 0) {
						inTimeCount = inTimeCount + 1
					}
					if (rec.graph_warning) {
						warning.push(rec.graph_warning)
					}
					return sum + 1
				}
				return sum
			}, 0)
		return dataRec
	})
	filteredData = filteredData.map(function (dataRec) {
		dataRec.category = dataRec.label + ' (' + nc.percent(dataRec.amount, count) + '%)'
		return dataRec
	})
	console.log(`🚀 ~ file: delivery-reliability.js:194 ~ filteredData:`, filteredData)
	rec.number_of_deliveries = count
	rec.delivery_percent = nc.percent(inTimeCount, count)
	rec.graph_warning = warning.join('') // default join char is ","
	/*
	embedSpec = {
		mode: 'vega',
		spec: chart.definition,
		renderer: 'svg',
		actions: {
			export: false,
			source: false,
			editor: false // https://github.com/vega/vega/wiki/Embed-Vega-Web-Components
		},
		hover: true
	}
	// Embed the visualization in the container with id `chart`
	// Vue.nextTick
	var elem, ref2, runtimeSpec, view
	embedSpec.spec.data[0].values = filteredData
	if ((ref2 = state.hdr.delivery_reliability) != null ? ref2.difference_in_delivery_date : void 0) {
		embedSpec.spec.axes[0].title = state.hdr.delivery_reliability.difference_in_delivery_date
	}
	if (document.getElementById(chartId)) {
		// check that id exists
		// debugger
		if (window.vega) {
			// vega_v3, d3v4
			elem = document.querySelector('#' + chartId)
			embedSpec.spec = rec.chart_v3.definition
			// embedSpec.spec.schema = {"language": "vega", "version": "3.0.0"}
			// * coped from: https://github.com/vega/vega/blob/master/web/group.html
          data = [
          	{'cat':'a'},
          	{'cat':'b'}, {'cat':'b'}, {'cat':'b'}, {'cat':'b'}, {'cat':'b'}
          ].map (d) ->
          	d.x = Math.random()
          	d.y = Math.random()
          	d.xscale = 'sx'
          	d.yscale = 'sy'
          	return d
          embedSpec.spec.data[0].values = data // * /
			debugger
			runtimeSpec = vega.parse(embedSpec.spec)
			view = new vega.View(runtimeSpec).logLevel(vega.Warn).initialize(elem).hover().run()
			view
				.toImageURL('svg')
				.then(function (url) {
					return (elem.src = url)
				})
				.catch(function (err) {
					console.error('vega3 view.toImageURL error:', err)
				})
		} else {
			vg.embed('#' + chartId, embedSpec, function (error, result) {
				// Callback receiving the View instance and parsed Vega spec
				// result.view is the View, which resides under the '#chart' element
				if (error) {
					if (document.getElementById(chartId)) {
						// check that id still exists, it may have been deleted from DOM
						console.error('vega draw error:', chartId, error, result)
					}
				}
			})
		}
	}
	*/
}

pageInit()
callServer('update')
