/* eslint-disable no-unused-vars */
// preference/form/nc/nc-work-center/nc-work-center.js

// storage map svg
let mapSelected = ref([])
let mapHover = ref([])

function storageMapToggleSelected(param) {
	console.debug('map click', param.id, param.event)
	const i = mapSelected.value.indexOf(param.id)
	if (i === -1) mapSelected.value.push(param.id)
	else mapSelected.value.splice(i, 1)
}

function storageMapDoubleClick(param) {
	console.debug('map double click', param.id, param.event)
}

// update data
function setIndex(data, arr) {
	if (arr.length === 0) {
		return arr
	}
	const productIdx = data.dataIdx['product']
	const productionOrderIdx = data.dataIdx['production_order']
	arr.forEach(item => {
		if (item.product_id && productIdx[item.product_id]) {
			item.pr = productIdx[item.product_id]
		} else {
			item.pr = { json_data: {} }
		}
		if (item.production_order_id && productionOrderIdx[item.production_order_id]) {
			item.pro = productionOrderIdx[item.production_order_id]
		} else {
			item.pro = { json_data: {} }
		}
	})
	return arr
}

function updateAfter(ret) {
	if (ret.data) {
		if (ret.data.work) {
			// state.grid.work = Object.assign({}, state.grid.work)
			state.grid.work.data = setIndex(ret.data, ret.data.work)
			if (state.rec.selected_work_row == 1) {
				nc.grid.activateRows(state, 'work', state.rec.selected_work_row) // first load
			}
			// nc.grid.redrawRows(state, 'work', true) // this does not work at all, must assign a new grid object for refresh
		}
		if (ret.data.work_phase) {
			state.grid.work_phase.data = setIndex(ret.data, ret.data.work_phase)
			state.grid.work_phase = Object.assign({}, state.grid.work_phase)
			setTimeout(() => {
				if (state.rec.selected_work_row > 0 && state.grid.work.data && state.grid.work_phase.data) {
					const phase = state.grid.work.data[state.rec.selected_work_row - 1]
					if (phase) {
						setTimeout(() => {
							const index = state.grid.work_phase.data.findIndex(item => item.work_phase_number === phase.work_phase_number)
							nc.grid.activateRows(state, 'work_phase', index + 1)
						}, 0)
					}
				}
			}, 0)
		}
		if (ret.data.product_material) {
			state.grid.product_material.data = ret.data.product_material
			state.grid.product_material = Object.assign({}, state.grid.product_material)
		}
	}
}

function callParameter(rowIndex, reload) {
	const rowRec = nc.grid.activatedRow(state, 'work')
	return {
		// {"production_order_id": state.rec.work_order_id, "employee": state.rec.em_employee_id, "days_before": state.rec.days_before}
		organization_id: state.rec.connection,
		reload_data: reload != null ? reload : state.rec.reload_data,
		prev_resource: state.rec.prev_resource,
		prev_organization_id: state.rec.prev_organization_id,
		selected_org_id_resource: state.rec.selected_org_id_resource,
		employee: state.rec.employee_id,
		production_order_id: rowRec && rowRec.production_order_id,
		// selected_work_row: rowIndex || state.rec.selected_work_row,
		resource: state.rec.resource
	}
}

function update(area, rowIndex, reload) {
	if (area != null) {
		state.rec.selected_work_row = rowIndex
		nc.callServer(
			state,
			'calc/work-center',
			{
				rec: callParameter(rowIndex, false)
			},
			updateAfter
		)
		return
	}
	const prevReload = state.rec.reload_data
	nc.callServer(
		state,
		'query',
		{
			name: 'form/nc/nc-work-center/grid.json',
			parameter: callParameter(rowIndex, reload)
		},
		ret => {
			state.rec.reload_data = prevReload
			updateAfter(ret)
		}
	)
}
updateAfter(state) // first call

// grid ui
function gridRowClicked(area, rowIndex, selected, event) {
	console.log(`🚀 nc-work-center.js gridRowClicked ~ area, rowIndex, selected, event:`, area, rowIndex, selected, event)
	state.rec.started = false
	state.rec.selected_work_row = rowIndex
	if (selected) {
		if (area === 'work') {
			const rowRec = nc.grid.activatedRow(state, 'work')
			state.rec.started = rowRec && rowRec.work_phase_state === 'AL'
			update('work', rowIndex + 1)
			// } else if (area === 'local_field' || area === 'external_field') {
			// 	// selectMatchField(area, rowIndex)
		}
	}
}

function gridRowDoubleClicked(area, rowIndex, event) {
	gridRowClicked(area, rowIndex, 'selected', event)
}

// --- work phase start, continue, stop ---

function clickButton(action) {
	// debugger
	const rowRec = nc.grid.activatedRow(state, 'work')
	if (!rowRec) {
		return
	}
	if (!state.rec.employee_id || state.rec.employee_id === '') {
		return
	}
	// fake demo start and stop
	if (action === 'start' || action === 'stop') {
		const arr = nc.grid.activatedRecordArr(state, 'work')
		arr.forEach(item => {
			if (action === 'start') item.work_phase_state = 'AL'
			else item.work_phase_state = 'LT'
		})
		state.rec.started = rowRec && rowRec.work_phase_state === 'AL'
		nc.grid.redrawRows(state, 'work', false) // need to update the grid
	}
	// message.setInfo(state, 'Work start, pause and stop is not implemented yet.')
	console.warn('Work start, pause and stop are not implemented yet.')
	return
	const wosRec = rowRec
	const woRec = {}
	const wpaRec = {}
	function callback(ret) {
		console.debug('query production order')
		if (ret && ret.data && ret.data[0]) {
			woRec = ret.data[0]
			// get start phase (wpa)
			const parameter = {
				person: state.rec.employee_id,
				production_order_id: rowRec.production_order_id,
				work_phase_number: rowRec.work_phase
			}
			nc.callServer(
				state,
				'query',
				{
					name: 'form/nc/nc-work-center/query/person-open-work-phase-actual.json',
					parameter: parameter
				},
				ret => {
					console.debug('query open phase')
					if (ret && ret.data && ret.data[0]) {
						wpaRec = ret.data[0]
						state.rec.wpa_rec = wpaRec
					}
					clickButtonSave(action, wpaRec, wosRec, woRec)
				}
			)
		}
	}
	// get production order (wo)
	const parameter = {
		production_order_id: rowRec.production_order_id
	}
	return nc.callServer(
		state,
		'query',
		{
			name: 'form/nc/nc-work-center/query/person-open-actual-work-phase.json',
			parameter: parameter
		},
		callback
	)
}

function clickButtonSave(action, wpaRec, wosRec, woRec) {
	if (!wosRec || !woRec) {
		// in "start" wpaRec is null
		return
	}
	// _web_state
	// wpaRec is nil in start
	if (action !== 'save' && wpaRec && (wpaRec._web_edit === true || wpaRec._web_state === action)) {
		return
	}
	let employee = state.rec.employee_id
	let parameter = {}
	let pauseOther = false
	let queryParam, wo, wos, wpa
	if (action === 'setup') {
		queryParam = {
			employee: employee,
			production_order_id: wosRec.production_order_id,
			work_phase: wosRec.work_phase
		}
		wos = {
			employee: employee,
			production_order_id: wosRec.production_order_id,
			work_phase: wosRec.work_phase,
			work_load_group_id: wosRec.work_load_group_id,
			record_id: wosRec.record_id
			// record_id: woRec.record_id
		}
		parameter = {
			action: action,
			query_param: queryParam,
			rec: wos
		}
	} else if (action === 'start') {
		pauseOther = state.rec.pause_other
		wos = [
			{
				work_load_group_id: wosRec.work_load_group_id,
				production_order_id: wosRec.production_order_id,
				work_phase: wosRec.work_phase,
				record_id: wosRec.record_id
			}
		]
		wo = [
			{
				record_id: woRec.record_id,
				wos: wos
			}
		]
		parameter = {
			action: action,
			structure: {
				wo: wo
			},
			parameter: {
				employee: employee,
				production_order_id: wosRec.production_order_id,
				work_phase: wosRec.work_phase
			},
			array: {}
		}
	} else if (action === 'pause') {
		// wpa = [{"wpa_info": wpaRec.info, "wpa_record_id": wpaRec.record_id}]
		wpa = [wpaRec]
		wos = [
			{
				work_load_group_id: wosRec.work_load_group_id,
				production_order_id: wosRec.production_order_id,
				work_phase: wosRec.work_phase,
				record_id: wosRec.record_id,
				wpa: wpa
			}
		]
		wo = [
			{
				record_id: woRec.record_id,
				wos: wos
			}
		]
		parameter = {
			action: action,
			structure: {
				wo: wo
			},
			parameter: {
				employee: state.rec.employee_id
			},
			array: {}
		}
	} else if (action === 'continue') {
		pauseOther = state.rec.pause_other
		queryParam = {
			wpa_record_id: wpaRec.record_id
		}
		// wpa = [{"wpa_info": wpaRec.info, "wpa_record_id": wpaRec.record_id}]
		wpa = [wpaRec]
		wos = [
			{
				work_load_group_id: wosRec.work_load_group_id,
				production_order_id: wosRec.production_order_id,
				work_phase: wosRec.work_phase,
				record_id: wosRec.record_id,
				wpa: wpa
			}
		]
		wo = [
			{
				record_id: woRec.record_id,
				wos: wos
			}
		]
		parameter = {
			action: action,
			structure: {
				wo: wo
			},
			parameter: {
				employee: state.rec.employee_id
			},
			array: {}
		}
	} else if (action === 'stop') {
		debugger
		wpaRec = state.rec.wpa_rec
		wpaRec._web_edit = true
		wpaRec._web_state_executing = 'stop'
		// clear field values because of coming from pause action
		wpaRec.date_ = '0000-00-00'
		wpaRec.end_time = '00:00:00'
		if (wpaRec.work_time__amount === 0) {
			wpaRec.work_time__amount = '' // easier to enter number
		}
		if (wpaRec.produced_amount === 0) {
			wpaRec.produced_amount = ''
		}
		editButton('edit', wpaRec, wosRec) // TODO: show edit area
		return
	} else if (action === 'save' && wpaRec._web_state_executing && wpaRec._web_state_executing === 'stop') {
		wpaRec = state.rec.wpa_rec
		if (wpaRec.work_time__amount === '') {
			wpaRec.work_time__amount = 0
		}
		if (wpaRec.produced_amount === '') {
			wpaRec.produced_amount = 0
		}
		wpaRec._web_edit = false
		wpaRec._web_state_executing = null
		queryParam = {
			wpa_record_id: wpaRec.record_id
		}
		// wpa = [{"wpa_info": wpaRec.info, "wpa_record_id": wpaRec.record_id}]
		wpa = [wpaRec]
		wos = [
			{
				work_load_group_id: wosRec.work_load_group_id,
				production_order_id: wosRec.production_order_id,
				work_phase: wosRec.work_phase,
				record_id: wosRec.record_id,
				wpa: wpa
			}
		]
		wo = [
			{
				record_id: woRec.record_id,
				wos: wos
			}
		]
		parameter = {
			action: 'stop',
			structure: {
				wo: wo
			},
			parameter: {
				employee: state.rec.employee_id,
				check_previous_phase_produced_amount: state.rec.check_previous_phase_produced_amount
			},
			array: {}
		}
	} else if (action === 'save') {
		wpaRec._web_edit = false
		// wpa = [{"wpa_produced_amount": wpaRec.produced_amount, "wpa_work_time__amount": wpaRec.work_time__amount, "wpa_date_": wpaRec.date_, "wpa_end_time": wpaRec.end_time, "wpa_info": wpaRec.info, "wpa_record_id": wpaRec.record_id}]
		wpa = [wpaRec]
		wos = [
			{
				record_id: wosRec.record_id,
				wpa: wpa
			}
		]
		wo = [
			{
				record_id: woRec.record_id,
				wos: wos
			}
		]
		parameter = {
			action: action,
			structure: {
				wo: wo
			},
			parameter: {
				employee: state.rec.employee_id,
				check_previous_phase_produced_amount: state.rec.check_previous_phase_produced_amount
			},
			array: {}
		}
	}
	wosRec._disable = false
	save(parameter, pauseOther)
}

function save(parameter, pauseOther) {
	var arr, em, endTime
	em = state.data.em
	arr = [] // collect same user in run action
	endTime = ''
	function setPause() {
		function setPauseCallback() {
			if (arr.length > 0) {
				arr.shift() // Remove the first item of an array
				return setPause()
			}
		}
		parameter = {
			x: arr[0]
		}
		nc.callServer(
			state,
			'run/preference',
			{
				name: 'form/nc/nc-work-center/call/call.json',
				parameter: parameter
			},
			setPauseCallback
		)
	}
	if (arr.length > 0) {
		setPause()
	}
	function callback(ret) {
		state.data.em = em
		if (state.rec.clear_after_save === true) {
			if (ret.data == null || typeof ret.data !== 'string' || ret.data === '') {
				// no error message from lua
				nc.setRec(state, 'employee_id', '')
				nc.setRec(state, 'em_whole_name', '')
				nc.setRec(state, 'work_order_id', '')
				query()
			}
		}
		if (parameter.action === 'stop' && ret.status === 'ok' && typeof ret.data !== 'string') {
			// not error message in data
			message.setSuccess(state.hdr.work_center_gig.save_ok)
			setTimeout(() => {
				message.setSuccess('')
			}, state.rec.save_ok_show_time) // show save_ok for 5 seconds
		}
	}
	nc.callServer(
		state,
		'run/preference',
		{
			name: 'form/nc/nc-work-center/call/call.json',
			parameter: parameter
		},
		callback
	)
}

function editButton(edit, wpaRec, wosRec) {
	var oldWpaRec
	if (!wpaRec) {
		return
	}
	if (edit === 'edit') {
		wpaRec._web_edit = true
		wosRec._disable = true
		oldWpaRec = nc.clone(wpaRec)
	} else if (edit === 'cancel') {
		nc.copyRecord(oldWpaRec, wpaRec)
		wpaRec._web_edit = false
		wosRec._disable = false
		wpaRec._web_state_executing = null
	} else {
		// else if edit is "ok" # this calls clickButton
		//  wpaRec._web_edit = false
		alert('unknown edit action when calling editButton()')
	}
	refresh()
}

function importFile(fileName, data) {
	// debugger
	if (fileName == null) {
		return
	}
	let txt = data
	if (typeof txt == 'object' && txt[0]) {
		txt = txt[0]
		if (txt[0]) {
			txt = txt[0]
		}
	}
	if (typeof txt == 'string' && txt.length > 200) {
		txt = txt.substring(0, 200) + '...'
	}
	message.setInfo(state, `Import from file '${fileName}' was successful, content: ${txt}`)
	/* state.rec.progress_bar.percent += 40
	// rec.progress_bar.message = `Import from file '${fileName}' was successful, imported ${data.length} rows`
	setTimeout(() => {
		// give first message time to show
		addDataToGrid(state, area, data, fileName, callBack)
	}, 100) */
}
