import { openBlock as _openBlock, createBlock as _createBlock } from '../../vuelib.js'

function render(_ctx, _cache) {
	return (
		_openBlock(),
		_createBlock(
			'img',
			{
				class: 'nc-barcode',
				id: _ctx.id,
				model: _ctx.model,
				format: _ctx.format,
				'code-width': _ctx.codeWidth,
				'code-height': _ctx.codeHeight
			},
			null,
			16 /* FULL_PROPS */,
			['id']
		)
	)
}

// src/components/nc-draw/nc-barcode.vue - template functional?
/* import nc from '/src/core/nc-util.js'
import { inject, onMounted, watchEffect } from '../vuelib.js'
import JsBarcode from 'jsbarcode' */

export default {
	render: render,
	name: 'NcBarcode',
	props: {
		id: {
			type: String,
			default: 'nc-barcode-1'
		},
		model: {
			type: String,
			default: undefined,
			required: true
		},
		format: {
			type: String,
			default: 'CODE128'
		},
		codeWidth: {
			type: [Number, String],
			default: undefined,
			description: 'Width of a single bar in pixels, default is 2.'
		},
		codeHeight: {
			type: [Number, String],
			default: undefined
		}
	} /* ,
	setup(props) {
		const state = inject('state')
		onMounted(() => {
			watchEffect(() => {
				const value = nc.recData(state, props.model)
				const options = {
					format: props.format
				}
				if (props.codeHeight) {
					options.height = props.codeHeight // setting undefined or null will prevent drawing
				}
				if (props.codeWidth) {
					options.width = props.codeWidth
				}
				JsBarcode('#' + props.id, value, options)
			})
		})
	} */
}
