// form/nc/report/delivery-reliability/delivery-reliability.js

function pageInit(ret) {
	const selectionId = nc.searchParameter('id')
	if (selectionId) {
		rec.query_type = 'selection'
		rec.selection_id = selectionId
	} else {
		rec.query_type = 'time_period'
		rec.selection_id = ''
	}
	callServerCallback(ret)
}

let updateTimeout
function callServerCallback() {
	// rec.query_type = queryType // restore after init call
	// rec.selection_id = selectionId
	rec.company = '' // dropdown selected
	rec.query_start_date = rec.start_date // in html, update button as red if out of date range
	rec.query_end_date = rec.end_date
	rec.query_warning = ''
	drawChart() // will call setDropdown(state, data)
	if (updateTimeout) {
		clearTimeout(updateTimeout)
	}
	if (rec.update_seconds > 0) {
		updateTimeout = setTimeout(() => {
			callServer('init')
		}, rec.update_seconds * 1000)
	}
}

function callServer() {
	// queryType = rec.query_type // save now and restore aftef rest call
	// selectionId = rec.selection_id
	// if (action === 'update') {
	let param
	if (rec.query_type === 'selection') {
		param = {
			selection_id: rec.selection_id
		}
	} else {
		param = {
			start_date: rec.start_date, // dt.dateToString(rec.start_date),
			end_date: rec.end_date // dt.dateToString(rec.end_date)
		}
	}
	nc.callServer(
		state,
		'query',
		{
			name: 'form/nc/report/delivery-reliability/grid.json',
			parameter: param
		},
		callServerCallback
	)
	// }
}

function setDropdown(state, data) {
	let date, item
	const companyFound = {}
	let dropdown = data.filter(function (ordr) {
		// filter out data that is not in selected date range
		if (rec.query_type !== 'time_period') {
			return true
		}
		date = ordr.calc.target_date // nc.parseDate(ordr.calc.target_date)
		return date >= rec.start_date && date <= rec.end_date
	})
	const filteredCount = dropdown.length
	dropdown = dropdown.reduce(function (result, ordr) {
		if (!companyFound[ordr.ord.company_id]) {
			item = {
				count: 1,
				show: ordr.co.name + ' - ' + ordr.ord.company_id,
				value: ordr.ord.company_id
			}
			companyFound[ordr.ord.company_id] = item
			// if data.find( (element) -> return element.ord.company_id is ordr.ord.company_id )
			result.push(item)
		} else {
			item = companyFound[ordr.ord.company_id]
			item.count = item.count + 1
		}
		return result
	}, [])
	dropdown.forEach(function (item) {
		item.show = item.show + ' (' + item.count + ')'
	})
	dropdown.sort(nc.dynamicSort('show', '>'))
	dropdown.unshift({
		// unshift adds to start of array
		show: state.hdr?.delivery_reliability?.all_companies + ' (' + filteredCount + ')',
		value: ''
	})
	nc.setArr(state, 'company', dropdown)
}

// eslint-disable-next-line no-unused-vars
function drawChart() {
	// called from layout html
	const rowData = state.grid?.order_row?.data
	if (!rowData) {
		return
	}
	// return
	const data = rec.chart_data
	if (!(data && rec.chart?.reliability)) {
		return
	}
	const translate = state.hdr?.delivery_reliability
	if (data.length > 2) {
		data[0].label = translate?.ahead_of_time
		data[1].label = translate?.on_time
		data[data.length - 1].label = translate?.over + ' ' + data[data.length - 1].start
	}
	// const retArr = nc.map(state, rowData, 'day_difference', param) // todo: create nc.map() function
	const chart = rec.chart.reliability
	const warning = []
	const retArr = rowData.map(ordr => {
		ordr.calc = {}
		if (ordr.confirmed_delivery_date > '1970-01-01') {
			ordr.calc.target_date = ordr.confirmed_delivery_date
			ordr.calc.day_difference = dt.dayDifference(ordr.confirmed_delivery_date, ordr.delivery_date)
		} else if (ordr.delivery_date > '1970-01-01') {
			ordr.calc.target_date = ordr.delivery_date
			ordr.calc.day_difference = dt.dayDifference(ordr.delivery_date, ordr.actual_delivery_date)
		} else {
			ordr.calc.target_date = ordr.actual_delivery_date
			ordr.calc.day_difference = 0
			warning.push(
				`Error in sales order: ${ordr.order_id}€${ordr.row_number}, delivery date = ${ordr.delivery_date}, actual delivery date = ${ordr.actual_delivery_date}, confirmed delivery date = ${ordr.confirmed_delivery_date}, delivery state = ${ordr.delivery_state}`
			)
		}
		return ordr
	})
	let count = 0
	let max = 10
	let inTimeCount = 0
	let date
	data.forEach(item => {
		item.deliveries = 0
	})
	let filteredData = data.map(function (item) {
		item.deliveries = retArr
			.filter(function (ordr) {
				if (ordr.ord.company_id !== rec.company && rec.company !== '') {
					return false
				}
				if (rec.query_type !== 'time_period') {
					return true
				}
				date = ordr.calc.target_date // dt.parseDate(ordr.calc.target_date)
				return date >= rec.start_date && date <= rec.end_date
			})
			.reduce(function (sum, ordr) {
				// use nc.arrayStartStopRecord()
				if ((item.start === null || ordr.calc.day_difference > item.start) && (item.stop === null || ordr.calc.day_difference <= item.stop)) {
					item.deliveries = item.deliveries + 1
					count = count + 1
					if (item.stop !== null && item.stop <= rec.days_late_allowed) {
						inTimeCount = inTimeCount + 1
					}
					sum = sum + 1
					if (item.deliveries > max) {
						max = item.deliveries
					}
				}
				return sum
			}, 0)
		return item
	})
	filteredData = filteredData.map(function (item) {
		item.category = item.label + ' (' + nc.percent(item.deliveries, count) + '%)'
		return item
	})
	rec.number_of_deliveries = count
	rec.delivery_percent = nc.percent(inTimeCount, count)
	rec.graph_warning = warning.join('\n') // default join char is ","
	chart.dataset[0].source = filteredData
	/* if (max > 10) {
		max = Math.round((max + 5) / 5) * 5 // round to next nearest 5
	} */
	chart.yAxis[0].max = max
	chart.yAxis[0].name = translate?.deliveries
	chart.series[0].name = translate?.days_late
	rec.update_chart = rec.update_chart + 1 // update chart
	setDropdown(state, rowData)
	// console.debug(`🚀 ~ file: delivery-reliability.js ~ filteredData:`, filteredData)
}

pageInit()
