// nc-input/nc-input.js
import { withKeys as _withKeys, normalizeClass as _normalizeClass, normalizeStyle as _normalizeStyle, createElementVNode as _createElementVNode, openBlock as _openBlock, createElementBlock as _createElementBlock } from '../../vuelib.js'

const _hoisted_1 = ["required", "type", "disabled", "value", "placeholder", "autocomplete", "tabindex"]

export function render(_ctx, _cache) {
  return (_openBlock(), _createElementBlock("div", {
    class: _normalizeClass(["ui input nc-input", { "left icon": _ctx.isCalendar }]),
    style: _normalizeStyle(_ctx.container_style)
  }, [
    _createElementVNode("input", {
      "data-lpignore": "true",
      required: _ctx.required,
      type: _ctx.type,
      style: _normalizeStyle(_ctx.calculatedStyle),
      class: _normalizeClass(_ctx.styleClass),
      disabled: _ctx.disabled,
      value: _ctx.recValueFormatted,
      placeholder: _ctx.placeholder,
      autocomplete: _ctx.autocomplete,
      tabindex: _ctx.disabled && -1,
      onKeydown: _cache[0] || (_cache[0] = _withKeys((...args) => (_ctx.onEnterKey && _ctx.onEnterKey(...args)), ["enter"])),
      onInput: _cache[1] || (_cache[1] = (...args) => (_ctx.updateValue && _ctx.updateValue(...args))),
      onFocus: _cache[2] || (_cache[2] = (...args) => (_ctx.onFocus && _ctx.onFocus(...args))),
      onBlur: _cache[3] || (_cache[3] = (...args) => (_ctx.onBlur && _ctx.onBlur(...args)))
    }, null, 46 /* CLASS, STYLE, PROPS, HYDRATE_EVENTS */, _hoisted_1)
  ], 6 /* CLASS, STYLE */))
}
// /src/components/nc-input/nc-input.vue

//LastPass ignore: data-lpignore='true'
// <style src="../../lib/fomantic-ui/dist/components/label.css"></style>
// <style src="../../lib/fomantic-ui/dist/components/input.css"></style>
/*
LastPass ignore: data-lpignore='true'
*/
// /src/components/nc-input/nc-input.vue
// import '../../lib/fomantic-ui/dist/components/input.css
import createComponent from './nc-input-component.js'
// import * as math from 'mathjs'
// import NcDatePicker from './nc-date-picker.vue'
// component.components = { NcDatePicker }
export default { ...createComponent('NcInput') }
