// form/nc/report/label/pallet-label.js

onMounted(() => {
	update() // first data load
})

function setRecord(item) {
	nc.mergeState(state, 'rec', item, 'pallet-label.js')
	loadPdf()
}

function pdfCallback(ret) {
	if (ret && ret.page) {
		// pdf render result
		state.rec.document_data = {
			data: ret.page,
			mime_type: 'application/pdf',
			document_name: state?.rec?.dispatch_note ? 'Pallet-label-' + state.rec.dispatch_note + '.pdf' : 'Pallet label.pdf'
		}
		return
	}
}

function callback(ret) {
	pdfCallback(ret)
	const arr = state.grid && state.grid.order_row && state.grid.order_row.data
	state.rec.ord = {}
	state.rec.co = {}
	if (arr && arr.length > 0) {
		setRecord(arr[0])
		nc.grid.activateRows(state, 'order_row', 1)
	}
}

// eslint-disable-next-line no-unused-vars
function gridRowClicked(area) {
	const arr = nc.grid.activatedRecordArr(state, area)
	if (arr.length > 0) {
		setRecord(arr[0])
	}
}

function loadPdfFunc() {
	if (rec.show_pdf) {
		nc.callServer(
			state,
			'print',
			{
				render_preference: {
					document_type: 'pdf',
					paper_type: rec.paper_type,
					paper_orientation: (rec.landscape && 'landscape') || 'portrait'
				},
				state: {
					rec: state.rec,
					hdr: state.hdr
				}
			},
			pdfCallback
		)
	}
}
const loadPdf = nc.debounce(loadPdfFunc, (rec.update_pdf_seconds && rec.update_pdf_seconds * 1000) || 200, false) // default delay of 200 ms

function update() {
	const param = {
		dispatch_note: state.rec.dispatch_note
	}
	nc.callServer(
		state,
		'query',
		{
			name: 'form/nc/report/label/grid.json',
			return: {
				grid: [
					{
						name: 'order_row'
					}
				]
			},
			parameter: param
		},
		callback
	)
}
