// ../core/nc-peg.js
// ../../core/nc-peg.js

const peg = {}
export default peg

peg.replace = function (str, from, replacement) {
	return str.replace(new RegExp(from, 'g'), replacement) // todo: should we use new replaceAll()?
}

peg.concatWith = function (sep, a, b) {
	// TODO: multiple params, see code from lua
	/* for i = 1, #param do
		if param[i] ~= "" and param[i] ~= nil then
	if ret == "" then
	ret = ret..tostring(param[i])
			else
	ret = ret..tostring(separator)..tostring(param[i])
	end */
	if (a && b) {
		return a + sep + b
	}
	if (a) {
		return arguments
	}
	return b
}

export function parseBefore(subjectString, separator) {
	if (subjectString == null) {
		return subjectString
	}
	const pos = subjectString.indexOf(separator)
	if (pos >= 0) {
		return subjectString.substring(0, pos)
	}
	return subjectString
}
peg.parseBefore = parseBefore

peg.parseAfter = function (subjectString, separator) {
	if (subjectString == null) {
		return subjectString
	}
	const pos = subjectString.indexOf(separator)
	if (pos >= 0) {
		return subjectString.substring(pos + separator.length)
	}
	return subjectString
}

peg.parseAfterStart = function (subjectString, separator) {
	if (subjectString == null || separator == null) {
		return subjectString
	}
	if (subjectString.substring(0, separator.length) === separator) {
		return subjectString.substring(separator.length)
	}
	return subjectString
}

peg.parseBeforeLast = function (subjectString, separator) {
	if (subjectString == null) {
		return subjectString
	}
	let pos = subjectString.lastIndexOf(separator)
	if (pos >= 0) {
		return subjectString.substring(0, pos)
	}
	return subjectString
}

peg.parseAfterLast = function (subjectString, separator) {
	if (subjectString == null) {
		return subjectString
	}
	let pos = subjectString.lastIndexOf(separator)
	if (pos >= 0) {
		return subjectString.substring(pos + separator.length)
	}
	return subjectString
}

peg.startsWith = function (subjectString, startString) {
	if (typeof subjectString !== 'string') return false
	if (startString === '') {
		return true
	}
	return subjectString.indexOf(startString) === 0 // use substring?
}

peg.endsWith = function (subjectString, endString) {
	// test nc.isString(variable)
	if (typeof subjectString !== 'string') return false
	if (endString === '') {
		return true
	}
	return subjectString.substring(subjectString.length - endString.length) === endString
}

peg.toCamelCase = function (str) {
	// https://stackoverflow.com/questions/2970525/converting-any-string-into-camel-case
	if (typeof str !== 'string') return str
	return str.replace(/^([A-Z])|[\s-_](\w)/g, function (match, p1, p2) {
		if (p2) return p2.toUpperCase()
		return p1.toLowerCase()
	})
}

peg.toKebabCase = function (str) {
	// https://gist.github.com/thevangelist/8ff91bac947018c9f3bfaad6487fa149
	if (typeof str !== 'string') return str
	return str
		.replace(/([a-z])([A-Z])/g, '$1-$2') // get all lowercase letters that are near to uppercase ones
		.replace(/[\s_]+/g, '-') // replace all spaces and low dash
		.toLowerCase()
}

peg.cleanBeforeAfterDoubleSpace = function (txt) {
	return txt.trim().replace(/ +(?= )/g, '')
}

/* for future need
peg.trimCrLf = function (str) {
	return str.replace(/\s+/g, ' ').replace(/\0/g, '').trim()
}
*/

/* peg.toPascalCase = function (str) {
	// https://stackoverflow.com/questions/4068573/convert-string-to-pascal-case-aka-uppercamelcase-in-javascript
	if (typeof str !== 'string') return str
	return str
		.replace('-', ' ') // .replace('_', '')
		.split(' ')
		.map(word => {
			return word.charAt(0).toUpperCase() + word.slice(1).toLowerCase()
		})
		.join('')
} */

/* peg.removeFromEnd = function (str, remove) {
	while (peg.endsWith(str, remove)) {
		str = str.subs(1, -(remove.length + 1))
	}
	return str
} */

/* peg.trimEnd = function (str) {
	let lastChar = str.substring(str.length - 1)
	while (lastChar === ' ' || lastChar === '\n' || lastChar === '\t' || lastChar === '\r') {
		str = str.substring(1, str.length - 2)
		lastChar = str.substring(str.length - 1)
	}
	return str
} */
