# Moloni Invoce

https://www.moloni.pt/dev/documents/invoices/insert/

- company_id int
- in connection prf call_body -tag
  Mandatory

- date date
- order_date
  Mandatory

- expiration_date date
- due_date (json_data.expiration_date)
  Mandatory

- maturity_date_id int
- terms_of_payment_id 1262141

- document_set_id int
- order_type 438501
  Mandatory

- customer_id int
- invoicing_company_id
  Mandatory

alternate_address_id int

- our_reference string
- our_reference

- your_reference string
- your_reference

- financial_discount float
- discount_price

eac_id int

salesman_id int

salesman_commission float

special_discount float
The field special_discount, if filled in, must be a monetary value.

associated_documents array

    associated_id int
    Mandatory

    value float
    Mandatory

related_documents_notes string

- products array
  Mandatory

      product_id int
      	-
      Mandatory

      - name string
      	- description
      Mandatory

      summary string

      - qty float
      	- order_amount
      Mandatory

      - price float
      	- unit_price
      Mandatory

      discount float
      deduction_id int
      order int
      origin_id int
      exemption_reason string
      warehouse_id int

      properties array
      		title string
      		value string

      taxes array
      		tax_id int
      		Mandatory

      		value float
      		order int
      		cumulative int

      child_products array
      		product_id int
      		Mandatory

      		name string
      		Mandatory

      		summary string
      		qty float
      		Mandatory

      		price float
      		Mandatory

      		discount float
      		deduction_id int
      		order int
      		origin_id int
      		exemption_reason string
      		warehouse_id int
      		properties array
      		title string
      		value string
      		taxes array
      		tax_id int
      		Mandatory

      		value float
      		order int
      		cumulative int

exchange_currency_id int
exchange_rate float
delivery_method_id int

delivery_datetime date

delivery_departure_address string
delivery_departure_city string
delivery_departure_zip_code string
delivery_departure_country int
delivery_destination_address string
delivery_destination_city string
delivery_destination_zip_code string
delivery_destination_country int
vehicle_id int
vehicle_name string
vehicle_number_plate string

- notes string
- note

status int
generate_mb_reference int

---

Enter a new invoice.

The fields financial_discount, salesman_commission and even the field discountof each element of the set products, if filled in, must be values in percentage, from 0 to 100.

The field exemption_reason of each element of the set productsbecomes mandatory if the set taxesis empty, does not contain elements whose corresponding tax is of the VAT type or which have a zero value.

The structure propertiesof each element of the set productsis optional. However, if the article in question has properties but they are not sent on this endpoint , they will be automatically filled. On the other hand, if at least one property is sent, the original properties will be ignored.

The field origin_idrefers to the associated document from which this product originates. If you have global guides associated with the document, there is a legal obligation to declare articles originating from that document and you must use this field. If you try to use a document id that is not present in the associates, you will get an error.

If the company only has one CAE and the eac_idone is not sent, or the one that was sent is invalid, the eac_idwill be automatically filled in with the only existing CAE. If the company has more than one CAE, this will be kept blank.

The field valueof each element of the existing tax sets becomes mandatory if the tax defined by tax_idis a tax whose value is defined by article.

All fields \*\_idonly accept valid values. These values ​​can be consulted on the respective API endpoints . In the case of associated_idthe elements of the set associated_documents, they must belong to documents whose type can be associated with invoices, that is, delivery notes.

The field maturity_date_idis optional, and you must choose an expiration date that matches the expiration date sent, both in terms of days and in the description of that one. The expiration date is merely presentational. If you don't send it, the printout of the document will say "payment prompt", regardless of the due date.

The field deduction_id, so far existing in document, has been deprecated, and will be removed from the API in the future. It is recommended to use a deduction_idin the structure elements products. During this transition phase, if sent in document, it will be propagated to all elements of the structure productsthat do not have it.

Fields delivery_departure_countryand delivery_destination_countryjust accept id valid countries. Furthermore, if the country is Portugal ( id 1), the postal code must be valid (4 digits, dash, 3 digits).

You can submit the vehicle_name and vehicle_number_plate fields to define a transport vehicle without recording it in your company. If you also send the vehicle_id field, the vehicle identified by it will be used instead of those fields.

The field statusaccepts the values ​​0 (by default, if not filled in) and 1, which correspond, respectively, to the draft and closed states. When inserting an invoice with the status closed, the associated documents, if any, will be reconciled with the defined values ​​and will be communicated to the Tax Authority, if the company has this option active.

If the company has adhered to the cash VAT regime, only document_set_idseries created for that regime can be used . An error will be issued if another series is chosen.

To create documents in other currencies, the exchange_currency_idand fields exchange_ratemust be filled out. The field exchange_currency_idmust be filled in with a valid currency id , which you can look up in the endpointcurrencies/getAll. O campo exchange_rate deverá ser preenchido com o valor monetário apropriado. Pode consultar as tabelas de conversão que actualizamos todos os dias, no endpoint currencyExchange/getAll.

If you close the document ( status = 1) and you have configured the company's ATM reference generation system, you can send the field generate_mb_reference = 1to generate an ATM reference for this document, for its total value. If the reference is successfully generated, the response will contain the mb_referenceproperly filled-in structure .

When closing the document, stocks will be moved if one or more of your items has stock management . If your company has defined warehouses, you can fill in the field warehouse_idfor each item, so that the stock is moved in a specific warehouse. If you do not indicate the warehouse, the stock will be moved in the pre-defined warehouse for the item or, if none is pre-defined, in the pre-defined warehouse for the company.

If the article you are trying to insert is a composite article, you must send the structure child_productsof each article, which corresponds to the "children" articles. If you do not submit this structure, the "parent" article is added to the document as a normal article. Please note the following:

- "Children" articles must already be configured in moloni as "children" of the composite article. It is mandatory that the "children" belong to the "father", but it is not mandatory to send all the "children" of a "parent".

- The field priceof the "parent" item must correspond to the sum of the prices of the "children" items, for example, a child item with a price1.5 and qtya 2, must have a "parent" with a price3 and qtya 1, or price1.5 and qty2 so that the totals are equal.

- If the item "father" has discounts, they should be applied to "children", and not to "father". If you send different discounts for each "child", the "parent" item calculates the correct discount percentage on the total.

- Taxes must be applied to "children" articles, after which they will be replicated in the "parent" article.

If you intend to use transport data in the document, the data referring to the loading address and the unloading address must be filled in and one of the following parameters must also be filled in:

```json
{
	"lastmodifiedby": "Pasi Mankinen",
	"lastmodifiedby_id": 135498,
	"lastmodified": "2022-01-21T16:17:44+0000",
	"set_from_api": 0,
	"plugin_id": 0,
	"doc_unico": null,
	"terminal_id": 0,
	"cash_vat_scheme_indicator": 0,
	"rsa_hash": "",
	"hash_control": 0,
	"timezone_id": 0,
	"document_id": 457106801,
	"company_id": 200001,
	"document_type_id": 1,
	"customer_id": 58814391,
	"supplier_id": 0,
	"salesman_id": 0,
	"document_set_id": 438501,
	"document_set_name": "M",
	"number": -1,
	"date": "2022-01-05T00:00:00+0000",
	"expiration_date": "2022-02-04T00:00:00+0000",
	"year": 2022,
	"maturity_date_days": null,
	"maturity_date_id": 1262141,
	"maturity_date_name": "30 Dias",
	"your_reference": "",
	"our_reference": "",
	"entity_number": "1057",
	"entity_name": "BRUNSWICK MARINE - EMEA OPERATIONS, LDA",
	"entity_vat": "502319224",
	"entity_address": "Zona Industrial Polo 1",
	"entity_city": "Campos",
	"entity_zip_code": "4920-012",
	"entity_country": "Portugal",
	"entity_country_id": 1,
	"cash_vat_scheme_entity": 0,
	"alternate_address_id": 0,
	"attached_file": "",
	"notes": "",
	"salesman_commission": 0,
	"deduction_id": 0,
	"deduction_percentage": 0,
	"deduction_name": "",
	"special_discount": 0,
	"financial_discount": 0,
	"gross_value": 283.2,
	"comercial_discount_value": 0,
	"financial_discount_value": 0,
	"taxes_value": 65.14,
	"deduction_value": 0,
	"net_value": 348.34,
	"reconciled_value": 0,
	"eac_id": 0,
	"eac_code": "",
	"delivery_method_id": 1446286,
	"delivery_method_name": "Nossa Viatura",
	"vehicle_id": 0,
	"vehicle_name": "",
	"vehicle_number_plate": "",
	"delivery_datetime": null,
	"delivery_departure_address": "",
	"delivery_departure_city": "",
	"delivery_departure_zip_code": "",
	"delivery_departure_country": 0,
	"delivery_destination_address": "",
	"delivery_destination_city": "",
	"delivery_destination_zip_code": "",
	"delivery_destination_country": 0,
	"related_documents_notes": "",
	"status": 0,
	"transport_code": "",
	"transport_code_set_by": 0,
	"global_guide": 0,
	"generate_mb_reference": 0,
	"exchange_currency_id": 0,
	"exchange_total_value": 0,
	"exchange_rate": 0,
	"document_type": { "document_type_id": 1, "saft_code": "FT" },
	"document_set": { "document_set_id": 438501, "name": "M" },
	"products": [
		{
			"ean": "0000000034562",
			"document_product_id": 1218580737,
			"origin_id": 0,
			"order": 1,
			"product_id": 108146709,
			"category_id": 4396386,
			"reference": "VK_UTS53EN1",
			"name": "UTT S53 - 19 Enclosure 2323787",
			"summary": "expl",
			"price": 141.6,
			"price_class_id": 0,
			"unit_id": 1750191,
			"unit_name": "Unidade",
			"unit_short_name": "Uni.",
			"discount": 0,
			"qty": 2,
			"exemption_reason": "",
			"deduction_id": 0,
			"deduction": 0,
			"deduction_name": "",
			"warehouse_id": 118661,
			"properties": "",
			"parent_id": 0,
			"related_id": 0,
			"taxes": [
				{
					"tax_id": 2329476,
					"type": 1,
					"saft_type": 1,
					"vat_type": "NOR",
					"stamp_tax": "",
					"name": "IVA Normal",
					"value": 23,
					"fiscal_zone": "PT",
					"order": 1,
					"cumulative": 0,
					"incidence_value": 283.2,
					"total_value": 65.136
				}
			]
		}
	],
	"associated_documents": [],
	"reverse_associated_documents": [],
	"mb_references": [],
	"payments": [],
	"document_calc_method": { "document_id": 457106801, "calc_method_id": 2 }
}
```

,
"example_data": {
"associated_documents": [],
"comercial_discount_value": 0,
"customer_id": 13712052,
"date": "2019-08-30T00:00:00+0100",
"deduction_value": 0,
"document_id": 259097595,
"document_set": {
"name": "M",
"document_set_id": 144808
},
"document_set_id": 144808,
"document_set_name": "M",
"document_type": {
"document_type_id": 28,
"saft_code": "NE"
},
"document_type_id": 28,
"entity_address": "Zona Industrial\r\nCampos - Vnc",
"entity_name": "Brunswick Marine - Emea Operations Lda",
"entity_number": "1057",
"entity_vat": "502319224",
"exchange_currency_id": 0,
"exchange_rate": 0,
"exchange_total_value": 0,
"expiration_date": "2019-09-29T00:00:00+0100",
"financial_discount_value": 0,
"global_guide": 0,
"gross_value": 3251.5,
"lastmodified": "2019-08-30T13:46:57+0100",
"maturity_date_days": userdata,
"maturity_date_id": 507393,
"maturity_date_name": "30 Dias",
"net_value": 3999.35,
"number": 1,
"our_reference": "",
"reconciled_value": 0,
"reverse_associated_documents": [],
"salesman_id": 0,
"status": 1,
"supplier_id": 0,
"taxes_value": 747.85,
"terminal_id": 0,
"transport_code": "",
"transport_code_set_by": 0,
"your_reference": "19/503829 test"
},
