// nc-form/nc-form.js

// /src/components/nc-form.vue, see nc-main.css
import { inject, ref, computed, onMounted } from '../../vuelib.js' // server component must have vue imports
import nc from '../../core/nc-util.js'
// import createComponent from './nc-form-col-row.js'

export default {
	render: render,
	name: 'NcForm',
	props: {
		showMessage: {
			type: Boolean,
			description: 'Do not show messages if this nc-form.',
			default: true
		},
		id: {
			type: String,
			description: 'Form message id.',
			default: undefined
		},
		size: {
			type: String,
			description: 'Form size.',
			default: undefined
		}
	},
	setup(props) {
		const state = inject(`state`)
		const form = ref()

		const messageObject = computed(() => {
			return state.message && state.message.id && (state.message.id === props.id ? state.message : null)
		})

		function submit() {
			console.debug('* form submit')
			return false
		}

		if (typeof window === 'undefined') {
			return // server render fix
		}
		onMounted(function () {
			if (form.value && !state.form) {
				nc.setState(state, 'form', form.value)
			}
		})
		return { messageObject, submit, form }
	}
}

// render code
import {
	resolveComponent as _resolveComponent,
	createVNode as _createVNode,
	renderSlot as _renderSlot,
	normalizeClass as _normalizeClass,
	openBlock as _openBlock,
	createElementBlock as _createElementBlock
} from '../../vuelib.js'

const _hoisted_1 = ['id']

export function render(_ctx, _cache) {
	const _component_nc_message_ui = _resolveComponent('nc-message-ui')

	return (
		_openBlock(),
		_createElementBlock(
			'form',
			{
				class: _normalizeClass([
					'ui form nc-form',
					{
						mini: _ctx.size === 'mini',
						tiny: _ctx.size === 'tiny',
						small: _ctx.size === 'small',
						large: _ctx.size === 'large',
						big: _ctx.size === 'big',
						huge: _ctx.size === 'huge',
						massive: _ctx.size === 'massive'
					}
				]),
				id: _ctx.id,
				ref: 'form',
				autocomplete: 'off',
				onSubmit: _cache[0] || (_cache[0] = (...args) => _ctx.submit && _ctx.submit(...args))
			},
			[
				_createVNode(
					_component_nc_message_ui,
					{
						size: _ctx.size,
						msg: _ctx.messageObject
					},
					null,
					8 /* PROPS */,
					['size', 'msg']
				),
				_renderSlot(_ctx.$slots, 'default')
			],
			42 /* CLASS, PROPS, NEED_HYDRATION */,
			_hoisted_1
		)
	)
}
