// plugin/vue-renderer/render.js
// idea taken from: https://lachlan-miller.me/articles/vue-3-pdf-customer-renderer
// TODO: this is better version, but it does not work with spiderjs version: 'JavaScript-C115.0a1'

// import fs from 'fs'
import { provide, defineComponent, compile, createRenderer } from '../vuelib.js' // 'vue', vue is using: 'vue/dist/vue.esm-bundler.js'
import { newDocument } from './element.js'
import { createNodeOps } from './nodeOps.js'

let startTime = performance.now()
const componentPath = '../component-2/'
// const elementArr = JSON.parse(fs.readFileSync('./element-arr.json', 'utf8')).element
const elementArr = [
	'nc-form/nc-form',
	'nc-form/nc-row',
	'nc-form/nc-col',
	'nc-form/nc-form-field',
	'nc-form/nc-form-fields',
	'nc-input/nc-span',
	'nc-input/nc-label',
	'nc-input/nc-input',
	'nc-input/nc-label-input',
	'nc-input/nc-label-textarea',
	'nc-input/nc-textarea',
	'nc-draw/nc-line',
	'nc-draw/nc-line-v',
	'nc-draw/nc-rect',
	'nc-draw/nc-image',
	'nc-draw/nc-icon',
	'nc-barcode/nc-barcode'
]
const componentPromise = []
let componentArray
elementArr.forEach(fileName => {
	componentPromise.push(import(componentPath + fileName + '.js'))
})
const importPromise = Promise.allSettled(componentPromise).then(ret => {
	componentArray = ret.reduce((arr, item) => {
		if (item.status === 'fulfilled') {
			item = item.value
			if (item.default.render) {
				console.warn(`component ${item.default.name} has render -tag in default export`)
			}
			if (item.ssrRender) {
				item.default.ssrRender = item.ssrRender
			} else {
				item.default.render = item.render
			}
			arr.push(item.default)
			return arr
		} else {
			console.error('importing copiled vue component failed, error: ', item.reason)
		}
	}, [])
	startTime = performance.now() - startTime
	const msg = `%c••• importing copiled vue componens succeeded in ` + (startTime / 1000).toFixed(4) + ` seconds •••\n`
	console.log(msg, 'font-weight: bold; font-style: italic;')
})

const App = defineComponent({
	name: 'NcRenderApp' /* ,
	setup() {
		provide('state', state)
		return { rec: state.rec, hdr: state.hdr } // ...toRefs(state) if state is reactive
	},
	render: compile(`${html}`) */
})

async function createApp(...args) {
	await importPromise
	const nodeMap = []
	const nodeOps = createNodeOps(nodeMap) // createNodeOps generates nodeMap
	const renderer = createRenderer(nodeOps)
	const app = renderer.createApp(...args) // vue call
	for (let key in componentArray) {
		app.component(key, componentArray[key])
	}
	const { mount } = app
	app.mount = doc => {
		const proxy = mount(doc)
		doc.nodeMap = nodeMap
		return proxy
	}
	return app
}

const replaceVShow = new RegExp('v-show=', 'g')
export function renderPage(param) {
	const html = param.html.replace(replaceVShow, 'v-if=')
	const state = param.state
	// state.rec = param.state.rec
	// state.hdr = param.state.hdr
	// console.log('html', html)
	// console.log('stateRec', stateRec)
	// const state = newState('nc-render', stateRec)
	state.rec.printing = true

	// return Object.assign({ style: appStyle }, toRefs(state)) // this is old-browser compatible version of '...state'
	// return { ...state, state } // ...toRefs(state) if state is reactive
	// components: componentArray, // create later by app.component(), components must be in app, here is not enough
	// Modelled after https://github.com/vuejs/vue-next/blob/master/packages/runtime-dom/src/index.ts#L61
	App.setup = () => {
		provide('state', state)
		return { rec: state.rec, hdr: state.hdr } // ...toRefs(state) if state is reactive
	}
	App.render = compile(`${html}`)

	const doc = newDocument()
	const app = createApp(App)
	app.mount(doc) // this creates doc.nodeMap
	// app.unmount() // not needed, let gc handle it
	doc.nodeMap.shift() // The shift() method removes the first item of an array, we don't need first root
	delete doc.nodeMap[0].parent

	const nodeMap = doc.nodeMap.map(item => {
		const ret = {}
		for (const key in item) {
			if (!key.startsWith('_') && key !== 'nodeMap') {
				ret[key] = item[key]
			}
		}
		if (item.__vnode && item.__vnode.props) {
			const item2 = item.__vnode.props
			ret.props = {}
			for (const key2 in item2) {
				if (item2[key2] != null && typeof item2[key2] !== 'function') {
					ret.props[key2] = item2[key2]
				}
			}
		}
		return ret
	})
	return JSON.stringify(nodeMap, null, 2)
}
