// plugin/vue-renderer/renderer/render.js

import './render-init.js' // inits globals like console.warn = print
import { compileVueComponent } from './compileVueComponent.js'
import { renderPage } from './render-page.js' // 'vue', vue is using: 'vue/dist/vue.esm-bundler.js'

globalThis.renderPage = paramText => {
	try {
		const param = JSON.parse(paramText)
		return renderPage(param)
	} catch (error) {
		const err = 'error: ' + ((error && error.message) || 'unknown try/catch renderPage() error')
		console.error(`file: render.js:`, err)
		return err
	}
}
globalThis.compileVueComponent = paramText => {
	try {
		const param = JSON.parse(paramText)
		const ret = compileVueComponent(param) // ({ "style":false, file_name, js, html, pug, ssr, base_path, vue_path })
		return ret
	} catch (error) {
		const err = 'error: ' + ((error && error.message) || 'unknown try/catch compileVueComponent() error')
		console.error(`file: render.js:`, err)
		return err
	}
}

//*
const callArgument = `{"fileName":"jsform/nc/report/pallet-label/pallet-label", "state":{"rec":{},"hdr":{}}, "style":false, "js":"let a = ''", "html":"<nc-form id='pallet-label'><nc-span>Hello</nc-span></nc-form>"}`
const ret = globalThis.renderPage(callArgument)
console.log(`🚀 ~ file: render.js:`, ret)
// */
