// nc-input/nc-textarea.js

// :id='editor'
// :style='calculatedStyle'
// :class='styleClass'
// /src/components/nc-input/nc-textarea.vue
/* <template>
	<div
		class='ui input'
		style='width: 100%'>
		<textarea
			:rows='rows'
			:disabled='disabled'
			:value='recValueFormatted'
			class='nc-input'
			@input='updateValue($event)'
			@focus='onFocus($event)'
			@blur='onBlur($event)'/>
	</div>
</template> */
// todo: sync with input, should this be same?
import createComponent from './nc-input-component.js'
export default { render: render, ...createComponent('NcTextarea') }

// render code
import {
	withKeys as _withKeys,
	normalizeClass as _normalizeClass,
	normalizeStyle as _normalizeStyle,
	createElementVNode as _createElementVNode,
	openBlock as _openBlock,
	createElementBlock as _createElementBlock
} from '../../vuelib.js'

const _hoisted_1 = ['id']
const _hoisted_2 = ['rows', 'required', 'type', 'disabled', 'value', 'placeholder', 'autocomplete', 'tabindex']

export function render(_ctx, _cache) {
	return (
		_openBlock(),
		_createElementBlock(
			'div',
			{
				class: 'ui input nc-textarea',
				id: _ctx.id,
				style: _normalizeStyle(_ctx.containerStyle)
			},
			[
				_createElementVNode(
					'textarea',
					{
						'data-lpignore': 'true',
						rows: _ctx.rows,
						required: _ctx.required,
						type: _ctx.type,
						style: _normalizeStyle(_ctx.calculatedStyle),
						class: _normalizeClass(_ctx.styleClass),
						disabled: _ctx.disabled,
						value: _ctx.recValueFormatted,
						placeholder: _ctx.placeholder,
						autocomplete: _ctx.autocomplete,
						tabindex: _ctx.disabled && -1,
						onKeydown: _cache[0] || (_cache[0] = _withKeys((...args) => _ctx.onEnterKey && _ctx.onEnterKey(...args), ['enter'])),
						onInput: _cache[1] || (_cache[1] = (...args) => _ctx.updateValue && _ctx.updateValue(...args)),
						onFocus: _cache[2] || (_cache[2] = (...args) => _ctx.onFocus && _ctx.onFocus(...args)),
						onBlur: _cache[3] || (_cache[3] = (...args) => _ctx.onBlur && _ctx.onBlur(...args))
					},
					null,
					46 /* CLASS, STYLE, PROPS, NEED_HYDRATION */,
					_hoisted_2
				)
			],
			12 /* STYLE, PROPS */,
			_hoisted_1
		)
	)
}
