// plugin/vue-renderer/renderer/render.js

import './render-init.js' // inits globals like console.warn = print

import { compileVueComponent } from './compileVueComponent.js'
import { renderPage } from './render-page.js' // 'vue', vue is using: 'vue/dist/vue.esm-bundler.js'

globalThis.renderPage = paramText => {
	try {
		const param = JSON.parse(paramText)
		return renderPage(param)
	} catch (error) {
		const err = 'error in vue-renderer/renderer/render.js, renderPage(): ' + ((error && error.message) || 'unknown try/catch renderPage() error')
		console.error(`file: render.js:`, err)
		return err
	}
}
globalThis.compileVueComponent = paramText => {
	try {
		const param = JSON.parse(paramText)
		const ret = compileVueComponent(param) // ({ "style":false, file_name, js, html, pug, ssr, base_path, vue_path })
		return ret
	} catch (error) {
		const err = 'error in vue-renderer/renderer/render.js, compileVueComponent(): ' + ((error && error.message) || 'unknown try/catch compileVueComponent() error')
		console.error(`file: render.js:`, err)
		return err
	}
}
