import { renderSlot as _renderSlot, openBlock as _openBlock, createBlock as _createBlock } from '../vuelib.js'

function render(_ctx) {
	return (
		_openBlock(),
		_createBlock(
			'div',
			{
				style: _ctx.calculatedStyle,
				class: ['nc-col', _ctx.width == 'auto' ? 'nc-col-auto' : '']
			},
			[_renderSlot(_ctx.$slots, 'default')],
			6 /* CLASS, STYLE */
		)
	)
}

// /src/components/nc-col.vue, see nc-main.css
import createComponent from './nc-form-col-row.js'
export default {
	render: render,
	...createComponent('NcCol', 'auto')
} // true == set default width:100%;
