import {
	renderSlot as _renderSlot,
	resolveComponent as _resolveComponent,
	withCtx as _withCtx,
	createVNode as _createVNode,
	openBlock as _openBlock,
	createBlock as _createBlock
} from '../../vuelib.js'

function render(_ctx, _cache) {
	const _component_nc_label = _resolveComponent('nc-label')
	const _component_nc_textarea = _resolveComponent('nc-textarea')
	const _component_nc_form_field = _resolveComponent('nc-form-field')

	return (
		_openBlock(),
		_createBlock(
			_component_nc_form_field,
			{ class: 'nc-label-textarea' },
			{
				default: _withCtx(() => [
					_createVNode(
						_component_nc_label,
						{
							model: _ctx.hdrModel,
							hdr: _ctx.hdr,
							'label-style': _ctx.labelStyle
						},
						{
							default: _withCtx(() => [_renderSlot(_ctx.$slots, 'default')]),
							_: 3 /* FORWARDED */
						},
						8 /* PROPS */,
						['model', 'hdr', 'label-style']
					),
					_createVNode(
						_component_nc_textarea,
						{
							style: _ctx.inputStyle,
							rows: _ctx.rows,
							disabled: _ctx.disabled,
							value: _ctx.recValueFormatted,
							onInput: _cache[1] || (_cache[1] = $event => _ctx.updateValue($event)),
							onFocus: _cache[2] || (_cache[2] = $event => _ctx.onFocus($event)),
							onBlur: _cache[3] || (_cache[3] = $event => _ctx.onBlur($event))
						},
						null,
						8 /* PROPS */,
						['style', 'rows', 'disabled', 'value']
					)
				]),
				_: 1 /* STABLE */
			}
		)
	)
}

// /src/components/nc-input/nc-label-input.vue
import createComponent from './nc-input-component.js'
export default {
	render: render,
	...createComponent('NcLabelTextarea')
}
