// plugin/vue-renderer/renderer/render-page-promise.js
// idea taken from: https://lachlan-miller.me/articles/vue-3-pdf-customer-renderer
// TODO: this is better version, but it does not work with spiderjs version: 'JavaScript-C115.0a1'

// import fs from 'fs'
import { renderPageApp } from './render-page-app.js'

let startTime = performance.now()
const componentPath = '../component-2/'
// const elementArr = JSON.parse(fs.readFileSync('./element-arr.json', 'utf8')).element
const elementArr = [
	'nc-form/nc-form',
	'nc-form/nc-row',
	'nc-form/nc-col',
	'nc-form/nc-form-field',
	'nc-form/nc-form-fields',
	'nc-input/nc-span',
	'nc-input/nc-label',
	'nc-input/nc-input',
	'nc-input/nc-label-input',
	'nc-input/nc-label-textarea',
	'nc-input/nc-textarea',
	'nc-draw/nc-line',
	'nc-draw/nc-line-v',
	'nc-draw/nc-rect',
	'nc-draw/nc-image',
	'nc-draw/nc-icon',
	'nc-barcode/nc-barcode'
]
const componentPromise = []
let componentArray
elementArr.forEach(fileName => {
	componentPromise.push(import(componentPath + fileName + '.js'))
})
const importPromise = Promise.allSettled(componentPromise).then(ret => {
	componentArray = ret.reduce((arr, item) => {
		if (item.status === 'fulfilled') {
			item = item.value
			if (item.default.render) {
				console.warn(`component ${item.default.name} has render -tag in default export`)
			}
			if (item.ssrRender) {
				item.default.ssrRender = item.ssrRender
			} else {
				item.default.render = item.render
			}
			arr.push(item.default)
			return arr
		} else {
			console.error('importing copiled vue component failed, error: ', item.reason)
		}
	}, [])
	startTime = performance.now() - startTime
	const msg = `%c••• importing copiled vue componens succeeded in ` + (startTime / 1000).toFixed(4) + ` seconds •••\n`
	console.log(msg, 'font-weight: bold; font-style: italic;')
})

export async function renderPage(arg) {
	await importPromise
	return renderPageApp(componentArray, arg)
}
