// nc-input/nc-input.js

// src/components/nc-input/nc-input.vue

// import * as math from 'mathjs'
// import NcDatePicker from './nc-date-picker.vue'
// component.components = { NcDatePicker }
import createComponent from './nc-input-component.js'
export default { render: render, ...createComponent('NcInput') }

// render code
import {
	withKeys as _withKeys,
	normalizeClass as _normalizeClass,
	normalizeStyle as _normalizeStyle,
	createElementVNode as _createElementVNode,
	openBlock as _openBlock,
	createElementBlock as _createElementBlock
} from '../../vuelib.js'

const _hoisted_1 = ['id']
const _hoisted_2 = ['autocomplete', 'name', 'required', 'type', 'disabled', 'readonly', 'value', 'placeholder', 'tabindex']

export function render(_ctx, _cache) {
	return (
		_openBlock(),
		_createElementBlock(
			'div',
			{
				class: _normalizeClass(['ui input nc-input', { 'left icon': _ctx.isCalendar }]),
				id: _ctx.id,
				style: _normalizeStyle(_ctx.containerStyle)
			},
			[
				_createElementVNode(
					'input',
					{
						autocomplete: _ctx.autocomplete,
						name: _ctx.name,
						required: _ctx.required,
						type: _ctx.type,
						style: _normalizeStyle(_ctx.calculatedStyle),
						class: _normalizeClass(_ctx.styleClass),
						disabled: _ctx.disabled,
						readonly: _ctx.readonly,
						value: _ctx.recValueFormatted,
						placeholder: _ctx.placeholder,
						tabindex: _ctx.disabled && -1,
						onKeydown: _cache[0] || (_cache[0] = _withKeys((...args) => _ctx.onEnterKey && _ctx.onEnterKey(...args), ['enter'])),
						onInput: _cache[1] || (_cache[1] = (...args) => _ctx.updateValue && _ctx.updateValue(...args)),
						onFocus: _cache[2] || (_cache[2] = (...args) => _ctx.onFocus && _ctx.onFocus(...args)),
						onBlur: _cache[3] || (_cache[3] = (...args) => _ctx.onBlur && _ctx.onBlur(...args))
					},
					null,
					46 /* CLASS, STYLE, PROPS, NEED_HYDRATION */,
					_hoisted_2
				)
			],
			14 /* CLASS, STYLE, PROPS */,
			_hoisted_1
		)
	)
}
