// form/nc/nc-load/nc-load.js
if (!state.rec.gantt_data.grid) {
	update('first-load')
}

function update(action) {
	if (action == 'capacity' && state.rec.old_capacity) {
		state.rec.old_work_date = true
	}
	if (action == 'work_date' && state.rec.old_work_date) {
		state.rec.old_capacity = true
		action = 'capacity'
	}
	if (action !== 'work_date') {
		let oldRec
		if (action !== 'first-load') {
			oldRec = nc.clone(state.rec)
		}
		nc.callServer(state, 'calc/loading', { old_capacity: state.rec.old_capacity, reload_data: state.rec.reload_data }, ret => {
			if (oldRec) {
				state.rec = oldRec
			}
			if (!ret.grid) {
				message.setWarning(state, `Return grid was not found.`)
				return
			}
			if (state.rec && ret.grid?.gridIdx?.capacityIdx) {
				state.rec.gantt_data = { grid: state.grid } // trigger watch in nc-gantt-chart.vue
			}
		})
	}
}
