const Yoga = require('../src/dist/entry-browser')

function expect(a, b) {
	if (a !== b) {
		console.error(`value ${a} is not equal to${b}`)
	}
}
// describe('yoga-layout', () => {
//   test('layout works', () => {
const config = Yoga.Config.create()

const root = Yoga.Node.create(config)
root.setWidth(100)
root.setHeight(100)

const firstChild = Yoga.Node.create(config)
firstChild.setFlexGrow(1)
firstChild.setFlexBasis(50)
root.insertChild(firstChild, 0)

const secondChild = Yoga.Node.create(config)
secondChild.setFlexGrow(1)
root.insertChild(secondChild, 1)
root.calculateLayout(Yoga.UNDEFINED, Yoga.UNDEFINED, Yoga.DIRECTION_LTR)

expect(root.getComputedLeft(), 0)
expect(root.getComputedTop(), 0)
expect(root.getComputedWidth(), 100)
expect(root.getComputedHeight(), 100)

expect(firstChild.getComputedLeft(), 0)
expect(firstChild.getComputedTop(), 0)
expect(firstChild.getComputedWidth(), 100)
expect(firstChild.getComputedHeight(), 75)

expect(secondChild.getComputedLeft(), 0)
expect(secondChild.getComputedTop(), 75)
expect(secondChild.getComputedWidth(), 100)
expect(secondChild.getComputedHeight(), 25)

root.calculateLayout(Yoga.UNDEFINED, Yoga.UNDEFINED, Yoga.DIRECTION_RTL)

expect(root.getComputedLeft(), 0)
expect(root.getComputedTop(), 0)
expect(root.getComputedWidth(), 100)
expect(root.getComputedHeight(), 100)

expect(firstChild.getComputedLeft(), 0)
expect(firstChild.getComputedTop(), 0)
expect(firstChild.getComputedWidth(), 100)
expect(firstChild.getComputedHeight(), 75)

expect(secondChild.getComputedLeft(), 0)
expect(secondChild.getComputedTop(), 75)
expect(secondChild.getComputedWidth(), 100)
expect(secondChild.getComputedHeight(), 25)
//   });
// });
