// preference/form/nc/nc-define/nc-layout-editor/nc-layout-element.js

// import elementProperty from './element-property.json'
import { isContainer, addNode, deleteNode } from '/plugin/nc-layout-editor/nc-layout-editor-util.js'

console.debug('* nc-layout-element lazy-loaded')

const elementArr = rec.element
rec.add_element = elementArr.element[0]

function deleteItem() {
	deleteNode(state, rec.selected_node)
}

function addItem(location) {
	const ncNode = rec.selected_node
	const newNode = nc.clone(rec.add_element)
	delete newNode.icon
	addNode(newNode, ncNode, location)
}

function componentButtonDisabled(location) {
	const ncNode = rec.selected_node
	if (!ncNode) return true
	let disabled = !ncNode.component || !ncNode.ncElem
	if (!disabled) {
		if (location == 'delete') {
			return false
		}
		const component = rec.add_element
		disabled = !component // location == 'after'
		if (!disabled && location == 'before') {
			if (!disabled && isContainer(ncNode)) {
				// empty container
				disabled = !ncNode.element || ncNode.element.length < 1
			}
			// else we have normal component selected and new can be inserted to parent component before selected component
		}
	}
	return disabled
}

function elemArrLoop() {
	const ret = []
	let i = 0
	let first, second, third, fourth
	while (i < elementArr.element.length) {
		while (i < elementArr.element.length && elementArr.element[i].show === false) {
			i++
		}
		if (i >= elementArr.element.length) break
		first = elementArr.element[i]
		if (rec.tool_column_count >= 2) {
			i++
			while (i < elementArr.element.length && elementArr.element[i] && elementArr.element[i].show === false) {
				i++
			}
			second = elementArr.element[i]
		}
		if (rec.tool_column_count >= 3) {
			i++
			while (i < elementArr.element.length && elementArr.element[i] && elementArr.element[i].show === false) {
				i++
			}
			third = elementArr.element[i]
		}
		if (rec.tool_column_count >= 4) {
			i++
			while (i < elementArr.element.length && elementArr.element[i] && elementArr.element[i].show === false) {
				i++
			}
			fourth = elementArr.element[i]
		}
		ret.push({ first, second, third, fourth })
		i++
	}
	return ret
}
