// preference/form/core/nc-toolbar/nc-toolbar.js

export default {
	setup() {
		const rec = state.rec

		// let grid = null
		// let out = null // use loadParam() later
		// let prevOut = null // use SaveParam() when out changes
		// let prevTable = ''
		// let table = ''

		function changeTable() {
			const param = {
				name: 'form/core/nc-list-form/grid.json',
				parameter: {
					return: {
						grid: [
							{
								name: 'list',
								tab: rec.table
							}
						]
					}
				}
			}
			nc.callServer(state, 'query', param, () => {})
		}

		function changeTab() {
			debugger
			nc.callServer(state, 'query', { name: 'form/core/nc-list-form/grid.json', parameter: { tab: rec.tab } })
		}

		return { changeTable, changeTab }
		/*
		function selectedIdArr() {
			var colName, idArr, output, ref, ref1, sel
			if (!table || table === '') {
				return
			}
			if (((ref = state.grid) != null ? ((ref1 = ref.list) != null ? ref1.grid : void 0) : void 0) == null) {
				// this is ok here, grid may not be drawn yet
				return null
			}
			output = state.grid.list
			if (!output.data || output.data.length < 1) {
				return
			}
			sel = output.grid.getSelectedRows().sort(nc.compareNumbers)
			// console.log("selectedIdArr", sel)
			colName = table + '_record_id'
			if (output.data[0][colName] == null) {
				colName = 'id'
			}
			if (output.data[0][colName] == null) {
				alert(l("Field '" + colName + l("' was not found or is empty")))
				return []
			}
			// debugger
			//for i of output.data
			// output.data[i][colName] = i
			// return null
			if (sel.length < 1) {
				return []
			}
			// sel = nc.range(0, data.length-1) # select all
			// alert(l "Select some rows before this action")
			idArr = sel.map(i => {
				// map function, gets called once for every element of array 'sel'
				return output.data[i][colName]
			})
			if (idArr === null) {
				alert(l('Selection is empty'))
			}
			return idArr
		}

		function saveParam() {
			var idArr, output, param
			if (table && table !== '') {
				idArr = selectedIdArr()
				if (idArr !== null) {
					param = {}
					param.selection = idArr // this is common for input/output/begin
					param.selection_record = 0 // 0-based array index of idArr
					nc.setParam(param, 'ma_selection_' + table)
				}
				output = nc.getParam('ma_output')
				if (output === null) {
					output = {}
				}
				output[table] = out
				nc.setParam(output, 'ma_output')
				prevOut = nc.clone(out)
			}
		}

		function updateToolbar(rec, pop) {
			var key, rec2, val
			rec2 = {}
			for (key in rec) {
				val = rec[key]
				if (key === 'tab' || key.search('order') >= 0) {
					// ?
				} else if (key === 'query_field') {
					rec2.field = val
				} else {
					rec2[key] = val
				}
			}
			mainScope.updateToolbar(rec2, pop)
		}

		function setQueryField(order_field) {
			out.query_field = '["' + order_field + '"]'
			updateToolbar({
				field: out.query_field
			})
			return saveParam()
		}

		function updateSortIndicator() {
			grid = state.grid.list
			if (grid.setSortColumn && out.order_field !== '') {
				if (out.order_ascend === '>') {
					return grid.setSortColumn(out.order_field, true)
				} else if (out.order_ascend === '<') {
					return grid.setSortColumn(out.order_field, false)
				}
			}
		}

		function loadParam() {
			var output, param
			if (!table || table === '') {
				param = nc.getParam()
				if (param && param.table) {
					table = param.table
				} else {
					table = mainScope.table() || ''
				}
			}
			if (table && table !== '') {
				output = nc.getParam('ma_output')
				if (output !== null) {
					out = output[table]
				}
			}
			if (!out) {
				out = {}
				out.order_field = ''
				out.order_ascend = ''
				out.query_field = ''
				out.operator = ''
				out.query_value1 = ''
				out.query_value2 = ''
				out.tab = ''
			}
			// param =  nc.getParam("ma_selection_" + table)
			prevOut = nc.clone(out)
		}

		function triggerAction(action, option) {
			var deleteCallback, docName, docType, idArr, ok, param, printCallback, save, selectionToStructureCallback
			param = {}
			if (!option || option !== 'no-selection') {
				idArr = selectedIdArr()
				if (idArr === null || idArr.length < 1) {
					alert('select record(s) for action: ' + action)
					return
				}
				param.selection = idArr
			}
			if (option) {
				param.option = option
			}
			param.table = table
			console.log('output: triggerMenu()', action, param)
			if (action === 'delete') {
				ok = false
				if (idArr.length === 1) {
					ok = confirm('Do you really want to delete 1 record?')
				} else {
					ok = confirm('Do you really want to delete ' + idArr.length + ' records?')
				}
				if (ok) {
					out.tab = state.rec.tab
					deleteCallback = function (ret) {
						return nc.callServer('query', out.tab)
					}
					return nc.callServer(state, action, param, deleteCallback)
				}
			} else if (action.search('download') === 0) {
				return nc.callServer(state, action, param, ret => {
					var txt
					txt = nc.toJson(ret.selection)
					return mainScope.showTextDialog(txt)
				})
				// else if action is "upload"
				// nc.callServer(state, action, param, selectionToStructureCallback)
			} else if (action.search('print') === 0) {
				docName = option.report_name
				docType = option.document_type
				save = option.save || false
				printCallback = function (ret) {

            // if nc.isSafari()
            //   mainScope.showPictureDialog(data)
            // else
            //   blob = new Blob([data], {'type': "image/svg+xml"})
            //   url = URL.createObjectURL(blob)
            //   win = window.open(url, docName)
            //   win.focus()

					var blob, data, ref, url, win
					data = ret != null ? ((ref = ret.rec) != null ? ref.picture : void 0) : void 0
					if (!data) {
						// show error message?
						return
					}
					docName = docName + '.' + docType
					if (docType === 'svg') {
						mainScope.showPictureDialog(data)
					} else {
						blob = nc.base64toBlob(data, 'application/' + docType)
						if (save || nc.isSafari()) {
							// window.location = url
							saveAs(blob, docName)
						} else {
							url = URL.createObjectURL(blob)
							win = window.open(url, docName) // , title ,'_blank')
							// win.document.write("<title>" + docName + "." + docType + "</title>")
							if (win) {
								win.focus()
							} else {
								nc.info(
									state,
									'Opening window for print failed, allow popup windows for this url to see report in browser.'
								)
							}
						}
					}
				}
				nc.callServer(state, action, param, printCallback)
			} else {
				nc.callServer(state, action, param) // , selectionToStructureCallback)
			}
		}

		function modifyRecord() {
			var url
			saveParam()
			url = table + '_input1'
			console.log(url)
			nc.gotoUrl('input/modify')
		}

		function gridOnSelectedRowsChangedCallback(e, args) {
			// item = args.grid.getData()[args.row]
			// console.log('gridOnSelectedRowsChangedCallback: ', args, e) #, item)
			saveParam()
		}

		let rowsLoaded = 0
		let rowsInSelection = 0
		let rowsInTable = 0
		let rowsLoadedArr = []
		let preloadCount = 75
		let rowLoadBatchHalfSize = 100
		let rowViewportPrev = {}
		let rowUpdateCalled = false

		function gridOnDblClick(e, args) {
			let item = args.grid.getDataItem(args.row)
			// console.log("gridOnDblClick:", args, e, item)
			let count = 0
			for (let key in item) {
				count++
				if (count > 1) {
					break
				}
			}
			if (count > 1) {
				// if item has only 1 key (id) => is virtual not-loaded row
				return state.modifyRecord()
			}
		}

		function viewportChanged(vp, prealod) {
			var bottom, i, limit, param, prevTop, top, up
			prevTop = rowViewportPrev.top
			top = vp.top
			bottom = vp.bottom
			rowViewportPrev.top = top
			rowViewportPrev.bottom = bottom
			if (!rowUpdateCalled) {
				up = top < prevTop
				if (bottom > rowsInSelection - 1) {
					// bottom is 0-based
					bottom = rowsInSelection - 1
				}
				i = 0
				while (i < rowsLoadedArr.length) {
					if (top >= rowsLoadedArr[i].top && bottom <= rowsLoadedArr[i].bottom) {
						if (prealod) {
							if (up && top - rowsLoadedArr[i].top <= preloadCount) {
								// start loading rows before top == has time to load before drawing
								top = rowsLoadedArr[i].top
								if (top <= 0) {
									// no scroll before first row
									return
								}
								break // do load
							}
							if (!up && rowsLoadedArr[i].bottom - bottom <= preloadCount) {
								bottom = rowsLoadedArr[i].bottom
								if (bottom >= rowsInSelection - 1) {
									// no scroll after last row
									return
								}
								break // is in loaded range, do nothing
							}
						}
						return
					}
					i = i + 1
				}
				if (i >= rowsLoadedArr.length) {
					// not inside any block, search near block
					i = 0
					while (i < rowsLoadedArr.length) {
						// fill small gaps
						if (up && top <= rowsLoadedArr[i].top && rowsLoadedArr[i].top - top <= rowLoadBatchHalfSize) {
							// debugger
							top = rowsLoadedArr[i].top
							break
						}
						if (!up && bottom >= rowsLoadedArr[i].bottom && bottom - rowsLoadedArr[i].bottom <= rowLoadBatchHalfSize) {
							// debugger
							bottom = rowsLoadedArr[i].bottom
							break
						}
						i = i + 1
					}
				}
				rowUpdateCalled = true
				console.log('gridOnViewportChanged:', top, rowViewportPrev.top, bottom, rowViewportPrev.bottom)
				param = {}
				param.add_to_grid = {}
				param.add_to_grid.up = up
				limit = 0 // set limit, bottom -> next top
				if (i >= rowsLoadedArr.length) {
					// not inside any block or near any block, moved by mouse in scrollbar
					// load half of data up and half down from scroll point because we don't know the next direction
					param.add_to_grid.offset = top - 1 - rowLoadBatchHalfSize
				} else if (up) {
					param.add_to_grid.offset = top - 1
				} else {
					param.add_to_grid.offset = bottom + 1
				}
				param.add_to_grid.limit = limit
				nc.callServer('load', null, param)
			}
		}

		function gridOnViewportChanged(e, args) {
			const vp = args.grid.getViewport()
			viewportChanged(vp, true)
		}

		function loadRows(param) {
			var bottom, i, top
			if (state.grid && state.grid.list) {
				state.grid.list.table = table
				if (!state.grid.list.callback) {
					state.grid.list.callback = {}
					state.grid.list.callback.onSelectedRowsChanged = gridOnSelectedRowsChangedCallback
					state.grid.list.callback.onDblClick = gridOnDblClick
					state.grid.list.callback.onViewportChanged = gridOnViewportChanged
					state.grid.list.callback.onRedraw = gridOnRedraw
					state.grid.list.callback.onSort = onSort
				}
			}
			if (param.load_batch_size) {
				// debugger
				rowLoadBatchHalfSize = Math.floor(param.load_batch_size / 2)
				if (param.preload_count) {
					preloadCount = param.preload_count
				}
			}
			if (param.info) {
				rowsInSelection = param.info.rowCountTotal
				rowsInTable = param.info.rowCountTable
				if (rowsLoaded === 0 && param.grid && param.grid.list && param.grid.list.data) {
					rowsLoaded = param.grid.list.data.length // param.info.rowCount
					rowsLoadedArr = []
					rowsLoadedArr.push({
						top: 0,
						bottom: rowsLoaded - 1
					})
				}
				if (param.add_to_grid && param.grid_data.length > 0) {
					grid.beginUpdate()
					top = param.add_to_grid.offset // array index is 0-based
					i = 0
					while (i < param.grid_data.length) {
						grid.data[top + i] = param.grid_data[i]
						grid.data[top + i].id = top + i + 1 // id is 1-based
						i++
					}
					bottom = top + i - 1
					grid.endUpdate()
					grid.updateRowCount()
					// debugger
					grid.refreshRows()
					i = 0
					while (i < rowsLoadedArr.length) {
						// make previous block bigger
						if (top <= rowsLoadedArr[i].bottom + 1 && bottom >= rowsLoadedArr[i].top - 1) {
							// debugger
							if (top < rowsLoadedArr[i].top) {
								rowsLoadedArr[i].top = top
							}
							if (bottom > rowsLoadedArr[i].bottom) {
								rowsLoadedArr[i].bottom = bottom
							}
							break
						} else if (bottom < rowsLoadedArr[i].top) {
							rowsLoadedArr.splice(i, 0, {
								top: top,
								bottom: bottom // insert in array
							})
							break
						}
						i++
					}
					if (i >= rowsLoadedArr.length) {
						// new block
						rowsLoadedArr.push({
							top: top,
							bottom: bottom
						})
					}
					rowsLoaded = rowsLoaded + param.grid_data.length
					rowUpdateCalled = false
					// check if current viewport is loaded after previous load
					if (rowViewportPrev.top) {
						viewportChanged(rowViewportPrev, false)
					}
				}
				rowUpdateCalled = false // must be also here to recover from errors
				// debugger
				if (param.rec) {
					if (param.rec.order_field && param.rec.order_ascend) {
						if (param.rec.order_field !== out.order_field || param.rec.order_ascend !== out.order_ascend) {
							out.order_ascend = param.rec.order_ascend
							out.order_field = param.rec.order_field
							updateSortIndicator()
						}
					}
				}
				if (!param.add_to_grid && grid && grid.redrawRows) {
					return grid.redrawRows()
				}
			}
		}

		function onSort(field, ascend) {
			out.order_field = field
			if (ascend) {
				out.order_ascend = '>'
			} else {
				out.order_ascend = '<'
			}
			nc.deleteParam('ma_selection_' + table) // saveParam()
			if (rowsLoaded === rowsInSelection) {
				// false and
				return true // better to use db sort always
			}
			nc.callServer('load', null)
			return false // do not let grid do it's default sort
		}

		function gridOnRedraw(area, newScopeData) {
			var add
			updateSortIndicator()
			if (rowsInSelection > rowsLoaded && newScopeData.data.length < rowsInSelection) {
				console.log('gridOnRedraw change:', rowsLoaded, rowsInSelection, newScopeData.data.length)
				add = rowsInSelection - rowsLoaded
				if (newScopeData.data.length > rowsLoaded) {
					add = rowsInSelection - newScopeData.data.length
				}
				return add
			}
			return null
		}

		function query(keyCode) {
			// keyCode, shiftKey
			if (!keyCode || keyCode === 13) {
				out.query_field = mainScope.toolbar.rec.field
				out.operator = mainScope.toolbar.rec.operator
				out.query_value1 = mainScope.toolbar.rec.query_value1 || ''
				out.query_value2 = mainScope.toolbar.rec.query_value1 || ''
				callServer('query')
				return true // run event.preventDefault()
			}
			return false
		}

		function callServer(action, tabRec, option) {
			var callb, key, param, return_object, val
			callb = function (param) {
				var mainParam, pop, rec
				prevOut = nc.clone(out)
				loadRows(param)
				// get new values from server (rec) or use previous values (out) adn refresh main toolbar
				pop = param.popup
				rec = param.rec
				if (rec) {
					if (rec.table && rec.table !== out.table) {
						out.table = rec.table
						mainParam = nc.getParam()
						if (mainParam === null) {
							mainParam = {} // do not clear other data
						}
						mainParam.table = out.table
						nc.setParam(mainParam)
					}
					if (rec.field) {
						out.query_field = rec.field
					}
					if (rec.operator) {
						out.operator = rec.operator
					}
					if (rec.query_value1) {
						out.query_value1 = rec.query_value1
					}
					if (rec.query_value2) {
						out.query_value2 = rec.query_value2
					}
					if (!nc.equals(out, prevOut)) {
						saveParam()
					}
					// $timeout ->
					rec = nc.clone(out)
					rec.rowsLoaded = rowsLoaded
					rec.rowsInSelection = rowsInSelection
					rec.rowsInTable = rowsInTable
					return updateToolbar(rec, pop)
				}
			}
			param = {}
			param.rec = {}
			return_object = []
			if (action === 'init') {
				return_object.push('load_batch_size')
				return_object.push('grid')
				return_object.push('popup.tab')
				if (!mainScope.toolbar.popup.table || mainScope.toolbar.popup.table.length === 0) {
					return_object.push('popup.table')
				}
				if (!mainScope.toolbar.popup.operator || mainScope.toolbar.rec.operator === '') {
					return_object.push('popup.operator')
				}
				if (table !== prevTable || table === '') {
					prevTable = table
					return_object.push('popup.field')
				}
				action = 'query'
			}
			// else if action is "query" or action is "load"
			if (action === 'query' || action === 'tab') {
				rowsLoaded = 0
			}
			return_object.push('grid')
			if (out.order_field) {
				param.order_field = out.order_field
				param.order_ascend = out.order_ascend
			}
			if (tabRec) {
				// called by clicking the tab
				rec.tab = tabRec
			}
			param.rec.tab = rec.tab || ''
			param.rec.field = out.query_field
			param.rec.operator = out.operator
			param.rec.value1 = out.query_value1
			param.rec.value2 = out.query_value2
			out.tab = param.rec.tab
			if (!param.rec.table) {
				param.rec.table = table
			}
			param.return_object = return_object
			param.action = action
			// param.action = action
			if (!nc.equals(out, prevOut)) {
				saveParam()
			}
			if (option) {
				for (key in option) {
					val = option[key]
					param[key] = val
				}
			}
			nc.callServer(state, 'output', param, callb)
		}

		function init() {
			console.log('output: init()')
			loadParam()
			nc.callServer('init')
		}
		init()
 */
	}
}
