// plugin/vue-renderer/copy-files.js

import fs from 'fs'
import path from 'path'
import { replaceContent } from './replace-content.js'

export const newComponentPath = '../component2/'
export let srcPath = '../../../../nc-designer/src/components/'

export function sourcePath() {
	return srcPath
}

export function copyFiles() {
	/* while (!fs.existsSync(srcPath)) {
		srcPath = srcPath.substring(3)
	} */
	console.log(`🚀 copy missing files, srcPath:`, srcPath)
	const copyFiles = [
		'nc-form/nc-form-col-row.js',
		'nc-input/nc-input-component.js',
		'nc-input/nc-translate.js',
		'../lib/font-awesome/nc-regular-icons.json',
		'../core/nc-dt.js',
		'../core/nc-peg.js',
		'../core/nc-state.js',
		'../core/nc-util.js'
	]
	fs.mkdirSync(path.resolve(newComponentPath, 'nc-form'), { recursive: true })
	fs.mkdirSync(path.resolve(newComponentPath, 'nc-input'), { recursive: true })
	fs.mkdirSync(path.resolve(newComponentPath, '../lib/font-awesome'), { recursive: true })
	fs.mkdirSync(path.resolve(newComponentPath, '../core/'), { recursive: true })
	copyFiles.forEach(fileName => {
		const toPath = path.resolve(newComponentPath, fileName)
		if (!fs.existsSync(toPath)) {
			const fromPath = path.resolve(srcPath, fileName)
			console.log(`🚀 copy file: ${fromPath} \n   --> ${toPath}`)
			let content = fs.readFileSync(fromPath, 'utf-8')
			content = replaceContent(fileName, content)
			fs.writeFileSync(toPath, content)
		}
	})
}
