import { createSSRApp, ref } from '/vue.js'
import { renderToString } from '@vue/server-renderer'

const App = {
	template: `
	<div>Current user is: {{ user }}</div>
	<input v-model='user' @change=change>
	`,
	setup() {
		const user = ref('John Doe')
		function change(event) {
			user.value = event
		}
		return { user, change }
	}
}

// export a factory function for creating a root component
export default async function (req) {
	const app = createSSRApp(App)
	const appContent = await renderToString(app)
	console.log(`🚀 ~ file: server.js ~ url: '${req.url}' ~ result: '${appContent}'`)
	const html = `
  <html>
    <body>
      <h2>Vue server renderer</h2>
      <div id="app">${appContent}</div>
    </body>
  </html>
  `
	return html
}
