# preference/cert/osx-nginx-cert.sh
# https://nickolaskraus.io/articles/how-to-create-a-self-signed-certificate-for-nginx-on-macos/

cp /System/Library/OpenSSL/openssl.cnf openssl.cnf
echo "
# copied
cp /System/Library/OpenSSL/openssl.cnf openssl.cnf

fix openssl.cnf, set your machine network name to nc.local or change nc.local yourMachineName.local
[v3_ca]
subjectAltName = DNS:nc.local

also fix this osx-nginx-cert.sh CN=nc.local to yourMachineName.local

press y and return to create certificate, or return to exit: "
read input

if [[ $input == "y" ]]; then
	sudo openssl req \
		-x509 -nodes -days 3650 -newkey rsa:1024 \
		-subj "/CN=nc.local" \
		-config openssl.cnf \
		-keyout self-signed.key \
		-out self-signed.crt

	sudo openssl dhparam -out dhparam.pem 1024
	echo "
	installing the certificate:

	sudo security add-trusted-cert -d -r trustRoot -k /Library/Keychains/System.keychain self-signed.crt
	"
	sudo security add-trusted-cert -d -r trustRoot -k /Library/Keychains/System.keychain self-signed.crt
fi

echo "
copy self-signed.crt to client machine and run this command to install the certificate:

sudo security add-trusted-cert -d -r trustRoot -k /Library/Keychains/System.keychain self-signed.crt
"
