// /Volumes/nc/nc-frontend/eslint.config.js

// plugins
import html from 'eslint-plugin-html'
import json from 'eslint-plugin-json'
import prettier from 'eslint-plugin-prettier'
import prettierVue from 'eslint-plugin-prettier-vue'
import vue from 'eslint-plugin-vue'
import vuePug from 'eslint-plugin-vue-pug'
import codeCept from 'eslint-plugin-codeceptjs'
// parsers
import vueParser from 'vue-eslint-parser'
// configs
import confPrettier from 'eslint-config-prettier'

const vueConst = [
	// nc
	'state',
	'rec',
	'arr',
	'hdr',
	// lifecycle
	'onActivated',
	'onBeforeMount',
	'onBeforeUnmount',
	'onBeforeUpdate',
	'onMounted',
	'onUnmounted',
	'onUpdated',
	// reactivity,
	'computed',
	'customRef',
	'isReadonly',
	'isRef',
	'markRaw',
	'reactive',
	'readonly',
	'ref',
	'shallowReactive',
	'shallowReadonly',
	'shallowRef',
	'triggerRef',
	'toRaw',
	'toRef',
	'toRefs',
	'unref',
	'watch',
	'watchEffect',
	'defineOptions', // <script> options in <script setup>
	// component
	'defineComponent',
	'defineAsyncComponent',
	'getCurrentScope',
	'onScopeDispose',
	'getCurrentInstance',
	'h',
	'inject',
	'nextTick',
	'provide',
	'useCssModule',
	'createApp',
	// vue3 only
	'onDeactivated',
	'onServerPrefetch',
	'onErrorCaptured',
	'onRenderTracked',
	'onRenderTriggered',
	'useAttrs',
	'useSlots',
	'resolveDirective',
	// vue 3 compiler-only
	'defineProps',
	'defineEmits',
	'defineExpose',
	// echarts theme
	'define'
]
const vueGlobal = vueConst.reduce((map, key) => {
	map[key] = 'readonly'
	return map
}, {})

export default [
	confPrettier,
	{
		languageOptions: {
			parser: vueParser,
			ecmaVersion: 'latest',
			sourceType: 'module',
			globals: {
				...vueGlobal,
				globalThis: 'readonly',
				state: 'readonly',
				nc: 'readonly',
				dt: 'readonly',
				peg: 'readonly',
				message: 'readonly',
				watch: 'readonly',
				watchEffect: 'readonly',
				onMounted: 'readonly',
				onBeforeUnmount: 'readonly',
				onActivated: 'readonly',
				onDeactivated: 'readonly',
				computed: 'readonly',
				reactive: 'readonly',
				ref: 'readonly',
				toRefs: 'readonly',
				sql: 'readonly',
				defineProps: 'readonly',
				defineEmits: 'readonly',
				browser: true,
				es6: true,
				node: true
			}
		},
		plugins: {
			html: html,
			json: json,
			prettier,
			prettierVue,
			vue,
			vuePug,
			codeCept
		},
		rules: {
			'prettier/prettier': 'error',
			semi: ['error', 'never'],
			'spaced-comment': ['error', 'always'],
			'vue/html-self-closing': [
				'error',
				{
					html: {
						void: 'any',
						normal: 'any',
						component: 'any'
					},
					svg: 'always',
					math: 'always'
				}
			],
			'vue/singleline-html-element-content-newline': 'off',
			'no-debugger': 'off',
			'vue/html-indent': ['error', 'tab'],
			'vue/first-attribute-linebreak': [
				'error',
				{
					singleline: 'ignore',
					multiline: 'ignore'
				}
			],
			'vue/max-attributes-per-line': [
				'error',
				{
					singleline: {
						max: 9
					},
					multiline: {
						max: 4
					}
				}
			],
			'vue/component-definition-name-casing': 'off',
			'vue/component-tags-order': [
				'error',
				{
					order: [['template', 'script', 'style']]
				}
			],
			'vue/no-unused-vars': [
				'error',
				{
					ignorePattern: '^_'
				}
			]
		},
		ignores: [
			'*.svg',
			'*.c',
			'*.cpp',
			'*.cc',
			'**/umami.js',
			'.DS_Store',
			'stats.html',
			'dist/**/*',
			'tests/unit/coverage/**/*',
			'tests/e2e/specs/**/*',
			'tool/**/*',
			'**/vuelib.js',
			'**/fontawesome.min.js',
			'**/viewer-nc.js',
			'**/pdf.*',
			'**/pdf-*',
			'**/vue.*',
			'**/javascript/**/*',
			'**/lib/**/*',
			'**/pdf-viewer/**/*',
			'**/build/**/*',
			'**/nc/**/*',
			'**/yoga/**/*',
			'**/assets/**/*'
		]
	}
]
