function esm(templateStrings, ...substitutions) {
	let js = templateStrings.raw[0]
	for (let i = 0; i < substitutions.length; i++) {
		js += substitutions[i] + templateStrings.raw[i + 1]
	}
	// return 'data:text/javascript;base64,' + btoa(js) // btoa does not exist in node
	return 'data:text/javascript;charset=utf-8,' + encodeURIComponent(js)
}
// in browser: const esm = ({ raw }, ...vals) => URL.createObjectURL(new Blob([String.raw({ raw }, ...vals)], { type: 'text/javascript' }))

const code = `import { fn } from 'file:///${process.cwd()}/dyn-import-existing.js'; fn(10);`
const dataUri = esm`${code}` // 'data:text/javascript;charset=utf-8,' + encodeURIComponent(code)
import(dataUri)
