// preference/form/nc/nc-work-center/nc-work-center.js

const recData = nc.recData
const recDataSet = nc.recDataSet
// storage map svg
let mapSelected = ref([])
// eslint-disable-next-line no-unused-vars
let mapHover = ref([])

// let updateFunc
let findText = ''
onMounted(() => {
	// TODO: is nc.debounce() flawed? it does not update all the time
	// updateFunc = nc.debounce(updateFilter, (rec.find_delay_seconds && rec.find_delay_seconds * 1000) || 1000, true)
	updateAfter(state) // the first call
	setWorkRow(0) // selects the first row
})

// --- find ---
function updateFilter() {
	nc.grid.updateFilter(state, 'work') // triggers isExternalFilterPresent() and doesExternalFilterPass()
}
// eslint-disable-next-line no-unused-vars
function findChanged(text, action) {
	if (action === 'clear_find') {
		rec.find_text = ''
		findText = ''
		updateFilter()
		return
	}
	findText = text && text.toLowerCase()
	// updateFunc()
	updateFilter()
}
// eslint-disable-next-line no-unused-vars
function isExternalFilterPresent() {
	return rec.virtual_production_order === false || findText !== ''
}
// eslint-disable-next-line no-unused-vars
function doesExternalFilterPass(node) {
	if (rec.virtual_production_order === false && node.data.virtual) {
		return false
	}
	let value
	for (const key of rec.find_field) {
		value = recData(node.data, key)
		if (typeof value !== 'string') {
			if (!rec.find_field_allow_null[key]) {
				console.error(`find field '${key}' is not a string, fix rec.find_field`)
			}
		} else if (value.toLowerCase().includes(findText)) {
			return true
		}
	}
	if (!findText) {
		return false // should not come here if findText is empty because isExternalFilterPresent() should return false
	}
	return false
}

// eslint-disable-next-line no-unused-vars
function storageMapToggleSelected(param) {
	console.debug('map click', param.id, param.event)
	const i = mapSelected.value.indexOf(param.id)
	if (i === -1) {
		mapSelected.value.push(param.id)
	} else {
		mapSelected.value.splice(i, 1)
	}
}

// eslint-disable-next-line no-unused-vars
function storageMapDoubleClick(param) {
	console.debug('map double click', param.id, param.event)
}

// eslint-disable-next-line no-unused-vars
function refresh() {
	nc.grid.updateFilter(state, 'work') // causes a call to isExternalFilterPresent() and then to doesExternalFilterPass()
}

// --- work phase start, continue, stop ---
function getCurrentValues(rowRec) {
	for (const key of rec.current_field_get) {
		if (key.includes('amount')) {
			recDataSet(rowRec, key, Number(recData(rec.current, key)))
		} else {
			recDataSet(rowRec, key, recData(rec.current, key))
		}
	}
}

function setCurrentValues(rowRec) {
	for (const key of rec.current_field_set) {
		recDataSet(rec.current, key, recData(rowRec, key))
	}
}

function setWorkRow(rowIndex, rowRec) {
	rec.selected_work_row = rowIndex
	if (rowIndex === 0) {
		return
	}
	if (!rowRec) {
		if (rowIndex > 0) {
			nc.grid.activateRows(state, 'work', rowIndex) // param can be number or array
		} else {
			nc.grid.activateRows(state, 'work', [])
		}
		rowRec = nc.grid.activatedRow(state, 'work')
	}
	setCurrentValues(rowRec)
}

// eslint-disable-next-line no-unused-vars
function clickButton(workState) {
	// called from layout
	const rowRec = nc.grid.activatedRow(state, 'work')
	if (!rowRec) {
		return
	}
	if (!rec.employee_id || rec.employee_id === '') {
		message.setWarning(state, 'Please select an employee first')
		return
	}
	if (workState === 'setup') {
		rowRec.previous_work_phase_state = rowRec.work_phase_state
	}
	if (workState === 'cancel') {
		rowRec.work_phase_state = rowRec.previous_work_phase_state
		rec.person_state = rec.constant.phase_state.stopped
		rec.person_state_unproductive = 'work change'
	} else if (workState === 'continue') {
		rec.person_state = rec.constant.phase_state.started
		rowRec.work_phase_state = rec.person_state
	} else if (workState === 'finish') {
		let prevRec = nc.clone(rowRec)
		getCurrentValues(rowRec)
		rowRec.failed_amount += prevRec.failed_amount
		rowRec.produced_amount += prevRec.produced_amount
		rowRec.setup_hours += prevRec.setup_hours
		if (rowRec.produced_amount >= rowRec.pro.amount_to_produce) {
			rowRec.work_phase_state = rec.constant.phase_state.finished
		} else {
			rowRec.work_phase_state = rec.constant.phase_state.started
			if (rec.constant.production_order_state_not_started.includes(rowRec.pro.production_order_state)) {
				rowRec.pro.production_order_state = rec.constant.production_order_state.started
			}
		}
		rec.person_state = rec.constant.phase_state.stopped
		rec.person_state_unproductive = 'work change'
	} else {
		if (workState === 'setup') {
			rec.current.started_amount = 0
		} else if (workState === 'started') {
			getCurrentValues(rowRec)
		}
		rowRec.work_phase_state = workState
		rec.person_state = workState
	}
	if (rowRec.calc.started_person == null) {
		rowRec.calc.started_person = []
	}
	const index = rowRec.calc.started_person.indexOf(rec.employee_id)
	if (workState === 'setup' || workState === 'started') {
		rec.person_state_unproductive = ''
		if (index === -1) {
			rowRec.calc.started_person.push(rec.employee_id) // only splice array when item is found, 2nd parameter means remove one item only
		}
	} else if (workState === 'finish' || workState === 'cancel') {
		if (index > -1) {
			rowRec.calc.started_person.splice(index, 1) // only splice array when item is found, 2nd parameter means remove one item only
		}
	}
	if (workState === 'started' || workState === 'finish') {
		setCurrentValues(rowRec)
	} else if (workState === 'cancel') {
		setCurrentValues(rowRec) // todo: cancel time to work change
	} else {
		return
	}
	nc.grid.redrawRows(state, 'work') // need to update the grid
	nc.grid.refreshCells(state, 'work')
	setTimeout(() => {
		nc.grid.redrawRows(state, 'work') // timeout for grid resize
	}, 150)
	let fieldPrwo, fieldPro
	if (workState === 'save') {
		fieldPrwo = rec.save_field_stop_prwo
		fieldPro = rec.save_field_stop_pro
	} else {
		fieldPrwo = rec.save_field_start_prwo
		fieldPro = rec.save_field_start_pro
	}
	const saveRec = {}
	let value
	for (const field of fieldPrwo) {
		value = recData(rowRec, field)
		if (value == null) {
			console.warn(`field '${field}' is null in rowRec, fix rec.save_field_start_prwo`)
		} else {
			recDataSet(saveRec, field, value)
		}
	}
	const saveRecPro = {}
	for (const field of fieldPro) {
		value = recData(rowRec, field)
		if (value == null) {
			console.warn(`field '${field}' is null in rowRec, fix rec.save_field_start_prwo`)
		} else {
			recDataSet(saveRecPro, field, value)
		}
	}
	saveRec.record_id = '' // clear for new record insert sql statement, otherwise it will be update statement
	// TODO: set start end end times, they can be se also in save/product_work-actual.json to get the server time because we don't trust browser time
	saveRec.pro = saveRecPro // production_order is inside product_work-actual record as table prefix pro, server side will handle saving
	// TODO: in server: how to handle sql upsert if production_order is not in local database?
	// TODO: in server: add window sql function to make atomic save(solved, but not implemented)
	/* const param = {
		organization_id: '',
		save: [{ table: 'product_work-actual', save_preference: 'form/nc/nc-work-center/save/product_work-actual.json', data: [saveRec], rec: state.rec }]
	}
	// save to database
	nc.callServer(state, 'save', param, ret => {
		if (ret.save) {
			console.debug(`🚀 ~ clickButton ~ ret.save:`, ret.save)
			let msg = ''
			ret.save.forEach(item => {
				item.data.forEach(data => {
					msg = item.table + ' saved, event time: ' + data.event_time || 'undefined' + '\n'
				})
			})
			message.setInfo(state, msg) // TODO: use console.debug() if this is too disturbing during development
		}
	}) */
}

// eslint-disable-next-line no-unused-vars
function clickUnproductiveButton(workState) {
	rec.person_state_unproductive = workState
}

function callParameter(reload, rowRec) {
	if (rowRec == null) {
		rowRec = nc.grid.activatedRow(state, 'work')
	}
	return {
		// {"production_order_id": rec.work_order_id, "employee": rec.em_employee_id, "days_before": rec.days_before}
		organization_id: rec.connection,
		virtual_production_order: rec.virtual_production_order,
		actual_work_phase: rec.actual_work_phase,
		actual_material: rec.actual_material,
		old_work_date: rec.old_work_date,
		reload_data: reload != null ? reload : rec.reload_data,
		prev_resource: rec.prev_resource,
		prev_organization_id: rec.prev_organization_id,
		selected_org_id_resource: rec.selected_org_id_resource,
		employee: rec.employee_id,
		production_order_id: (rowRec && rowRec.production_order_id) || '',
		resource: rec.resource
	}
}

function update(area, rowRec, reload) {
	// called also from layout
	if (area != null) {
		if (rowRec == null) {
			rowRec = nc.grid.activatedRow(state, area)
		}
		if (rowRec != null) {
			rec.selected_work_row = rowRec.idx
		}
		nc.callServer(
			state,
			'calc/work-center',
			{
				rec: callParameter(reload, rowRec)
			},
			updateAfter
		)
		return
	}
	const prevReload = rec.reload_data
	nc.callServer(
		state,
		'query',
		{
			name: 'form/nc/nc-work-center/grid.json',
			parameter: callParameter(reload)
		},
		ret => {
			if (reload) {
				rec.reload_data = prevReload
			}
			updateAfter(ret)
		}
	)
}

function gridRowClicked(area, rowIndex, event, selected, doubleClick) {
	// , event) // console.debug(`🚀 nc-work-center.js gridRowClicked ~ area, rowIndex, event, selected:`, area, rowIndex, event, selected)
	if (area === 'document') {
		const rowRec = event.data || nc.grid.activatedRow(state, 'document')
		if (rowRec) {
			if (documentShown === rowRec.name) {
				return
			}
			rec.document_data.document_name = rowRec.name
			if (doubleClick || rec.document_view) {
				openDocumentPreview('modal', rowRec)
			} else {
				openDocumentPreview('preview', rowRec)
			}
		} else {
			rec.document_data.document_name = ''
			rec.document_preview = false
			rec.document_preview_modal = false
		}
		return
	}
	if (area === 'work') {
		if (!selected) {
			rowIndex = 0
			setWorkRow(rowIndex)
			updateAfter()
			return
			// } else if (area === 'local_field' || area === 'external_field') {
			// 	// selectMatchField(area, rowIndex)
		}
		setWorkRow(rowIndex, event?.data)
		update('work', event?.data)
	}
}

// eslint-disable-next-line no-unused-vars
function gridRowDoubleClicked(area, rowIndex, event) {
	if (area === 'document') {
		openDocumentPreview('modal')
	} else {
		gridRowClicked(area, rowIndex, event, 'selected', true)
	}
}

// eslint-disable-next-line no-unused-vars
function importFile(fileRec, data) {
	if (fileRec.name == null) {
		return
	}
	let productId
	if (rec.selected_work_row > 0 && state.grid.work.data) {
		const phase = state.grid.work.data[rec.selected_work_row - 1]
		if (phase) {
			productId = phase.product_id
		}
	}
	if (!productId) {
		message.setWarning(state, `Import from file '${fileRec.name}' can't be done, please select a work row first`)
		return
	}
	let type = fileRec.type
	if (type === '') {
		type = peg.parseAfterLast(fileRec.name, '.')
		if (type === 'txt') {
			type = 'text/plain'
		} else if (type === 'md') {
			type = 'text/markdown'
		}
	}
	if (rec.allow_document_type && !rec.allow_document_type.includes(type)) {
		message.setWarning(state, `Import from file '${fileRec.name}' can't be done because it's type '${type}' is not allowed type`)
		return
	}
	const document = {
		name: fileRec.name,
		attachment_type: 'document', // peg.parseAfter(type, '/'),
		// attachment_status: '',
		// file_version: '',
		// document_path: '',
		json_data: { content: data, file_size: fileRec.size, mime_type: type, last_modified: fileRec.lastModified, product_id: productId } // fileRec.size is not the same as txt.length
	}
	let txt = data
	if (typeof txt == 'object' && txt[0]) {
		const length = txt.length
		txt = txt[0]
		if (txt[0]) {
			txt = txt[0]
		}
		if (typeof txt == 'object') {
			txt = JSON.stringify(txt)
		} else {
			txt = txt.toString()
		}
		txt = `${length} rows, data: [${txt.substring(0, 40)}, ...]`
	} else {
		txt = txt.toString()
		if (txt.length > 40) {
			txt = txt.substring(0, 40) + '...'
		}
	}
	const param = { save: [{ table: 'attachment', data: [document], save_preference: `form/nc/nc-document/save-document.json` }] }
	nc.callServer(state, 'save', param, ret => {
		message.setInfo(state, `Import from file '${fileRec.name}' to product '${productId}' was successful, content: ${txt}`)
		if (state.grid?.document?.data && ret?.save?.[0]?.data?.length > 0) {
			state.grid.document.data.unshift(ret.save[0].data[0]) // add to first row
			nc.grid.dataChanged(state.grid.document, state.grid.document.data)
			// state.grid.document = Object.assign({}, state.grid.document) // force redraw
			nc.grid.activateRows(state, 'document', 1)
		}
	})
}

// grid ui
let prevDocumentRow = -1
function setDocumentRow() {
	setTimeout(() => {
		// we need timeout to wait for grid to draw itself after the preview
		nc.grid.activateRows(state, 'document', prevDocumentRow)
	}, 50)
}

let documentShown = ''
function showDocumentPreview(viewType) {
	rec.document_preview_modal = false
	setTimeout(() => {
		if (viewType === 'modal') {
			rec.document_preview = true
			rec.document_preview_modal = true
		} else {
			rec.document_preview_modal = false
			rec.document_preview = true
		}
		documentShown === rec.document_path
	}, 50)
}

// eslint-disable-next-line no-unused-vars
function documentPreviewDoubleClick() {
	rec.document_preview_modal = 0
	openDocumentPreview('modal')
}

function openDocumentPreview(viewType, rowRec) {
	if (viewType !== 'preview' && !rec.document_preview === false && !rec.document_preview_modal === false) {
		if (prevDocumentRow > 0) {
			setDocumentRow()
		}
		return
	}
	if (viewType === 'preview') {
		rec.document_preview_modal = false
	}
	if (!rowRec) {
		rowRec = nc.grid.activatedRow(state, 'document')
		if (!rowRec) {
			return
		}
	}
	prevDocumentRow = rowRec.idx
	if (rowRec.document_path === rec.document_path && rec.document_data.data !== '') {
		showDocumentPreview(viewType)
		return
	}
	if (rowRec.document_data?.data && rowRec.document_data.data !== '') {
		rec.document_path = rowRec.document_path
		rec.document_data = rowRec.document_data
		showDocumentPreview(viewType)
		return
	}
	let jsonData = rowRec.json_data
	if (typeof jsonData === 'string') {
		jsonData = JSON.parse(jsonData)
	}
	nc.callServer(
		state,
		'calc/work-center-document',
		{
			rec: {
				document_data: { data: '', viewer_show_type: rec.document_data.viewer_show_type, mime_type: jsonData.mime_type, document_name: rowRec.name },
				document_path: rowRec.document_path
			}
		},
		ret => {
			if (ret.rec?.document_data) {
				rowRec.document_data = ret.rec.document_data
			}
			setDocumentRow()
			showDocumentPreview(viewType)
		}
	)
}

function setGrid(area) {
	if (area == 'product_material') {
		if (rec.actual_material) {
			nc.grid.dataChanged(state.grid.product_material_actual, state.data.product_material_actual)
		} else {
			nc.grid.dataChanged(state.grid.product_material, state.data.product_material)
		}
	} else if (area == 'work_phase') {
		if (rec.actual_work_phase) {
			nc.grid.dataChanged(state.grid.work_phase_actual, setIndex(state.data, state.data.work_phase_actual))
		} else {
			nc.grid.dataChanged(state.grid.work_phase, setIndex(state.data, state.data.work_phase))
			setTimeout(() => {
				if (rec.selected_work_row > 0 && state.grid.work.data && state.grid.work_phase.data) {
					const phase = state.grid.work.data[rec.selected_work_row - 1]
					if (phase) {
						setTimeout(() => {
							const index = state.grid.work_phase.data.findIndex(item => item.work_phase_number === phase.work_phase_number) // todo: remove findIndex(), create a real index
							nc.grid.activateRows(state, 'work_phase', index + 1)
						}, 0)
					}
				}
			}, 0)
		}
	} else {
		message.setError(state, `unknown area '${area}' in setGrid()`)
	}
}

function setupStartedPerson(workArr) {
	if (!workArr || !state.data?.work_phase_actual || state.data.work_phase_actual.length === 0) {
		return
	}
	const actualProductionOrderIdx = nc.createIndexArray(state.data.work_phase_actual, 'production_order_id')
	workArr.forEach(item => {
		if (item.calc.started_person == null) {
			item.calc.started_person = []
		}
		if (actualProductionOrderIdx[item.production_order_id]) {
			actualProductionOrderIdx[item.production_order_id].forEach(actual => {
				if (actual.work_phase_state === rec.constant.phase_state.started && !item.calc.started_person.includes(actual.person_id)) {
					item.calc.started_person.push(actual.person_id)
				}
			})
		}
	})
}

// update data
function setWorkRowValue(item) {
	if (item.calc == null) {
		item.calc = {}
	}
	item.calc.done = item.produced_amount / item.pro.amount_to_produce
}

function setIndex(data, arr) {
	if (arr.length === 0) {
		return arr
	}
	const productIdx = data.dataIdx['product']
	const productionOrderIdx = data.dataIdx['production_order']
	arr.forEach(item => {
		if (item.product_id && productIdx[item.product_id]) {
			item.pr = productIdx[item.product_id]
		} else {
			item.pr = { json_data: {} }
		}
		if (item.production_order_id && productionOrderIdx[item.production_order_id]) {
			item.pro = productionOrderIdx[item.production_order_id]
		} else {
			item.pro = { json_data: {} }
		}
		setWorkRowValue(item)
	})
	return arr
}

function updateAfter(ret) {
	if (!ret?.data) {
		nc.grid.dataChanged(state.grid.product_material_actual, [])
		nc.grid.dataChanged(state.grid.product_material, [])
		nc.grid.dataChanged(state.grid.work_phase_actual, [])
		nc.grid.dataChanged(state.grid.work_phase, [])
	} else {
		if (ret.data.work) {
			setupStartedPerson(ret.data.work)
			nc.grid.dataChanged(state.grid.work, setIndex(ret.data, ret.data.work))
			if (rec.selected_work_row == 1) {
				nc.grid.activateRows(state, 'work', rec.selected_work_row) // first load
			}
		}
		if (ret.data.work_phase || ret.data.work_phase_actual) {
			if (!ret.data.work && ret.data.work_phase_actual) {
				setupStartedPerson(state.data.work)
			}
			setGrid('work_phase')
		}
		if (ret.data.product_material || ret.data.product_material_actual) {
			setGrid('product_material')
		}
	}
}

// eslint-disable-next-line no-unused-vars
function toggleMaterialCheckbox(input) {
	if (input == 'storage_map') {
		rec.document_preview = false
		rec.actual_material = false
	} else if (input == 'actual_material') {
		rec.storage_map = false
		rec.document_preview = false
		setGrid('product_material')
	} else if (input == 'rec.document_preview') {
		rec.actual_material = false
		rec.storage_map = false
	}
}

/* Why is this code in here and not in css?
I could have put the stylings that doesn't require dynamic values to css, but because of their size I don't think it would have made the code any easier to manage. The reason why this cannot be put in css file is because the height of the element needs to be declared dynamically. And why didn't I use css dynamic values, because they have no effect. Is there a better way? Probably, but at the moment I don't have better approach in mind. */

// eslint-disable-next-line no-unused-vars
function slideDownBeforeEnter(el) {
	el.style.height = '0'
	el.style.overflow = 'hidden'
}
// eslint-disable-next-line no-unused-vars
function slideDownEnter(el) {
	el.style.height = el.scrollHeight + 'px'
}
// eslint-disable-next-line no-unused-vars
function slideDownAfterEnter(el) {
	el.style.height = 'auto'
}
// eslint-disable-next-line no-unused-vars
function slideDownBeforeLeave(el) {
	el.style.height = el.scrollHeight + 'px'
	el.style.overflow = 'hidden'
}
function forceReflow(el) {
	return el.offsetHeight // https://stackoverflow.com/questions/21664940/force-browser-to-trigger-reflow-while-changing-css
}
// eslint-disable-next-line no-unused-vars
function slideDownLeave(el) {
	forceReflow(el) // Force reflow
	el.style.height = '0'
}
// eslint-disable-next-line no-unused-vars
function slideDownAfterLeave(el) {
	el.style.height = ''
}

/*
clickButton(action) {
	const prwoRec = rowRec
	const woRec = {}
	const wpaRec = {}
	function callback(ret) {
		console.debug('query production order')
		if (ret && ret.data && ret.data[0]) {
			woRec = ret.data[0]
			// get start phase (wpa)
			const parameter = {
				person: rec.employee_id,
				production_order_id: rowRec.production_order_id,
				work_phase_number: rowRec.work_phase
			}
			nc.callServer(
				state,
				'query',
				{
					name: 'form/nc/nc-work-center/query/person-open-work-phase-actual.json',
					parameter: parameter
				},
				ret => {
					console.debug('query open phase')
					if (ret && ret.data && ret.data[0]) {
						wpaRec = ret.data[0]
						rec.wpa_rec = wpaRec
					}
					clickButtonSave(action, wpaRec, prwoRec, woRec)
				}
			)
		}
	}
	// get production order (wo)
	const parameter = {
		production_order_id: rowRec.production_order_id
	}
	return nc.callServer(
		state,
		'query',
		{
			name: 'form/nc/nc-work-center/query/person-open-actual-work-phase.json',
			parameter: parameter
		},
		callback
	) // * /
}

function clickButtonSave(action, wpaRec, prwoRec, woRec) {
	if (!prwoRec || !woRec) {
		// in "start" wpaRec is null
		return
	}
	// _web_state
	// wpaRec is nil in start
	if (action !== 'save' && wpaRec && (wpaRec._web_edit === true || wpaRec._web_state === action)) {
		return
	}
	let employee = rec.employee_id
	let parameter = {}
	let pauseOther = false
	let queryParam, wo, prwo, wpa
	if (action === 'setup') {
		queryParam = {
			employee: employee,
			production_order_id: prwoRec.production_order_id,
			work_phase: prwoRec.work_phase
		}
		prwo = {
			employee: employee,
			production_order_id: prwoRec.production_order_id,
			work_phase: prwoRec.work_phase,
			work_load_group_id: prwoRec.work_load_group_id,
			record_id: prwoRec.record_id
			// record_id: woRec.record_id
		}
		parameter = {
			action: action,
			query_param: queryParam,
			rec: prwo
		}
	} else if (action === 'start') {
		pauseOther = rec.pause_other
		prwo = [
			{
				work_load_group_id: prwoRec.work_load_group_id,
				production_order_id: prwoRec.production_order_id,
				work_phase: prwoRec.work_phase,
				record_id: prwoRec.record_id
			}
		]
		wo = [
			{
				record_id: woRec.record_id,
				prwo: prwo
			}
		]
		parameter = {
			action: action,
			structure: {
				wo: wo
			},
			parameter: {
				employee: employee,
				production_order_id: prwoRec.production_order_id,
				work_phase: prwoRec.work_phase
			},
			array: {}
		}
	} else if (action === 'pause') {
		// wpa = [{"wpa_info": wpaRec.info, "wpa_record_id": wpaRec.record_id}]
		wpa = [wpaRec]
		prwo = [
			{
				work_load_group_id: prwoRec.work_load_group_id,
				production_order_id: prwoRec.production_order_id,
				work_phase: prwoRec.work_phase,
				record_id: prwoRec.record_id,
				wpa: wpa
			}
		]
		wo = [
			{
				record_id: woRec.record_id,
				prwo: prwo
			}
		]
		parameter = {
			action: action,
			structure: {
				wo: wo
			},
			parameter: {
				employee: rec.employee_id
			},
			array: {}
		}
	} else if (action === 'continue') {
		pauseOther = rec.pause_other
		queryParam = {
			wpa_record_id: wpaRec.record_id
		}
		// wpa = [{"wpa_info": wpaRec.info, "wpa_record_id": wpaRec.record_id}]
		wpa = [wpaRec]
		prwo = [
			{
				work_load_group_id: prwoRec.work_load_group_id,
				production_order_id: prwoRec.production_order_id,
				work_phase: prwoRec.work_phase,
				record_id: prwoRec.record_id,
				wpa: wpa
			}
		]
		wo = [
			{
				record_id: woRec.record_id,
				prwo: prwo
			}
		]
		parameter = {
			action: action,
			structure: {
				wo: wo
			},
			parameter: {
				employee: rec.employee_id
			},
			array: {}
		}
	} else if (action === 'stop') {
		debugger
		wpaRec = rec.wpa_rec
		wpaRec._web_edit = true
		wpaRec._web_state_executing = 'stop'
		// clear field values because of coming from pause action
		wpaRec.date_ = '0000-00-00'
		wpaRec.end_time = '00:00:00'
		if (wpaRec.work_time__amount === 0) {
			wpaRec.work_time__amount = '' // easier to enter number
		}
		if (wpaRec.produced_amount === 0) {
			wpaRec.produced_amount = ''
		}
		editButton('edit', wpaRec, prwoRec) // TODO: show edit area
		return
	} else if (action === 'save' && wpaRec._web_state_executing && wpaRec._web_state_executing === 'stop') {
		wpaRec = rec.wpa_rec
		if (wpaRec.work_time__amount === '') {
			wpaRec.work_time__amount = 0
		}
		if (wpaRec.produced_amount === '') {
			wpaRec.produced_amount = 0
		}
		wpaRec._web_edit = false
		wpaRec._web_state_executing = null
		queryParam = {
			wpa_record_id: wpaRec.record_id
		}
		// wpa = [{"wpa_info": wpaRec.info, "wpa_record_id": wpaRec.record_id}]
		wpa = [wpaRec]
		prwo = [
			{
				work_load_group_id: prwoRec.work_load_group_id,
				production_order_id: prwoRec.production_order_id,
				work_phase: prwoRec.work_phase,
				record_id: prwoRec.record_id,
				wpa: wpa
			}
		]
		wo = [
			{
				record_id: woRec.record_id,
				prwo: prwo
			}
		]
		parameter = {
			action: 'stop',
			structure: {
				wo: wo
			},
			parameter: {
				employee: rec.employee_id,
				check_previous_phase_produced_amount: rec.check_previous_phase_produced_amount
			},
			array: {}
		}
	} else if (action === 'save') {
		wpaRec._web_edit = false
		// wpa = [{"wpa_produced_amount": wpaRec.produced_amount, "wpa_work_time__amount": wpaRec.work_time__amount, "wpa_date_": wpaRec.date_, "wpa_end_time": wpaRec.end_time, "wpa_info": wpaRec.info, "wpa_record_id": wpaRec.record_id}]
		wpa = [wpaRec]
		prwo = [
			{
				record_id: prwoRec.record_id,
				wpa: wpa
			}
		]
		wo = [
			{
				record_id: woRec.record_id,
				prwo: prwo
			}
		]
		parameter = {
			action: action,
			structure: {
				wo: wo
			},
			parameter: {
				employee: rec.employee_id,
				check_previous_phase_produced_amount: rec.check_previous_phase_produced_amount
			},
			array: {}
		}
	}
	prwoRec._disable = false
	save(parameter, pauseOther)
}

function save(parameter) {
	// , pauseOther
	let em = state.data.em
	let arr = [] // collect same user in run action
	function setPause() {
		function setPauseCallback() {
			if (arr.length > 0) {
				arr.shift() // Remove the first item of an array
				return setPause()
			}
		}
		parameter = {
			x: arr[0]
		}
		nc.callServer(
			state,
			'run/preference',
			{
				name: 'form/nc/nc-work-center/call/call.json',
				parameter: parameter
			},
			setPauseCallback
		)
	}
	if (arr.length > 0) {
		setPause()
	}
	function callback(ret) {
		state.data.em = em
		if (rec.clear_after_save === true) {
			if (ret.data == null || typeof ret.data !== 'string' || ret.data === '') {
				// no error message from lua
				nc.setRec(state, 'employee_id', '')
				nc.setRec(state, 'em_whole_name', '')
				nc.setRec(state, 'work_order_id', '')
				// query()
			}
		}
		if (parameter.action === 'stop' && ret.status === 'ok' && typeof ret.data !== 'string') {
			// not error message in data
			message.setSuccess(state.hdr.work_center_gig.save_ok)
			setTimeout(() => {
				message.setSuccess('')
			}, rec.save_ok_show_time) // show save_ok for 5 seconds
		}
	}
	nc.callServer(
		state,
		'run/preference',
		{
			name: 'form/nc/nc-work-center/call/call.json',
			parameter: parameter
		},
		callback
	)
}

function editButton(edit, wpaRec, prwoRec) {
	var oldWpaRec
	if (!wpaRec) {
		return
	}
	if (edit === 'edit') {
		wpaRec._web_edit = true
		prwoRec._disable = true
		oldWpaRec = nc.clone(wpaRec)
	} else if (edit === 'cancel') {
		nc.copyRecord(oldWpaRec, wpaRec)
		wpaRec._web_edit = false
		prwoRec._disable = false
		wpaRec._web_state_executing = null
	} else {
		// else if edit is "ok" # this calls clickButton
		//  wpaRec._web_edit = false
		alert('unknown edit action when calling editButton()')
	}
	// refresh()
}
*/
