// preference/form/nc/nc-work-center/nc-work-center-util.js

export function updateCurrentAndPersonFunction(state, nc, dt, message) {
	const rec = state.rec
	const hdr = state.hdr
	const arr = state.arr
	const recData = nc.recData
	const recDataSet = nc.recDataSet

	function setDefaultToCurrent(rowRec) {
		let value
		for (const key of rec.current_field_set) {
			value = rowRec && recData(rowRec, key)
			if (value == null) {
				value = rec.current_field_set_default[key]
			}
			if (value != null) {
				if (typeof rec.current_field_set_default[key] === 'number') {
					recDataSet(rec.current, key, Number(value))
				} else {
					recDataSet(rec.current, key, value)
				}
			}
		}
	}

	function setField(infoField, infoRec) {
		let prevConcatValue = ''
		rec.current.calc[infoField] = ''
		let val
		for (const key of rec[infoField + '_field']) {
			val = infoRec && recData(infoRec, key)
			if (val != null) {
				if (val !== '') {
					if (rec.field_format[key]) {
						val = dt.formatDate(val, rec.field_format[key])
					}
					rec.current.calc[infoField] += prevConcatValue + val
				}
			} else {
				prevConcatValue = key
			}
		}
	}

	function setPersonStateToCurrent(workPhaseRec) {
		let value
		for (const key of Object.keys(rec.person_state_field)) {
			value = workPhaseRec[key]
			if (value == null) {
				value = rec.person_state_field[key]
			}
			recDataSet(rec.current, key, value)
		}
	}

	return function updateCurrentAndPerson(fromRec, workPhaseRec) {
		const personWorkPhase = state.data.work_phase_actual_open.filter(item => item.person_id === rec.person && item.end_time === '1970-01-01 00:00:00')
		// const openWorkPhase = personWorkPhase.filter(item => item.production_order_id !== rec.constant.unproductive_id)
		const unproductiveWorkPhase = personWorkPhase.filter(item => item.production_order_id === rec.constant.unproductive_id)
		if (unproductiveWorkPhase.length > 1) {
			message.setWarning(state, 'more than one unproductive work phase was found')
		}
		if (unproductiveWorkPhase.length >= 1) {
			rec.current.unproductive = unproductiveWorkPhase[0].work_phase_state
		} else {
			rec.current.unproductive = ''
		}
		if (rec.selected_work_row <= 0) {
			setDefaultToCurrent()
			setField('time_info')
			setField('amount_info')
			setField('work_info')
			setField('started_info', rec.current.calc)
			rec.current.started_amount = ''
			rec.current.info = ''
			rec.current.prev_started_amount = rec.current.started_amount
			rec.current.prev_info = rec.current.info
			rec.current.can_run = false
			rec.current.can_start = false
			return
		}
		rec.current.prev_started_amount = rec.current.started_amount
		rec.current.prev_info = rec.current.info
		let rowRec = fromRec || state.grid.work.data[rec.selected_work_row - 1] // nc.grid.activatedRow(state, 'work')
		const machineWorkPhase =
			rowRec &&
			personWorkPhase.find(item => item.production_order_id === rowRec.production_order_id && item.work_phase_number === rowRec.work_phase_number && item.serie === 'machine')
		if (machineWorkPhase) {
			rec.machine_state = machineWorkPhase.work_phase_state
			rec.run_machine = machineWorkPhase.work_phase_state
		} else {
			rec.machine_state = ''
			rec.run_machine = 'running'
		}
		rec.run_machine_idx = nc.recordArrayIndex(arr.run_machine, 'value', rec.run_machine) || 0
		if (workPhaseRec == null && rowRec) {
			workPhaseRec = personWorkPhase.find(
				item =>
					item.production_order_id === rowRec.production_order_id &&
					item.work_phase_number === rowRec.work_phase_number &&
					item.serie === 'person' &&
					item.end_time === '1970-01-01 00:00:00'
			)
		}
		if (!workPhaseRec) {
			workPhaseRec = {}
		}
		if (!workPhaseRec?.work_phase_state) {
			workPhaseRec.work_phase_state = ''
		}
		rec.person_state = workPhaseRec?.work_phase_state || ''
		if (rec.person_state !== '') {
			rec.info_open = true
		}
		function setState(state) {
			if (state === 'cancel') {
				hdr.work_center.action = hdr.work_center.cancel
				rec.action_icon = 'stop'
				rec.primary_action = 'cancel'
			} else if (state === 'start') {
				hdr.work_center.action = hdr.work_center.start
				rec.action_icon = 'play'
				rec.primary_action = 'start'
			} else if (state === 'finish') {
				hdr.work_center.action = hdr.work_center.finish
				rec.action_icon = 'check'
				rec.primary_action = 'finish'
			} else if (state === 'stop') {
				hdr.work_center.action = hdr.work_center.stop
				rec.action_icon = 'stop'
				rec.primary_action = 'stop'
			} else if (state === 'play') {
				hdr.work_center.action = hdr.work_center.start
				rec.person_state = ''
				rec.action_icon = 'play'
			}
		}
		// debugger
		if (!workPhaseRec.work_phase_state) {
			setState('start')
		} else if (workPhaseRec.work_phase_state === rec.constant.phase_state.stopping) {
			setState('finish')
		} else if (workPhaseRec.work_phase_state === rec.constant.phase_state.starting) {
			setState('cancel')
		} else if (workPhaseRec.work_phase_state === rec.constant.phase_state.material) {
			setState('stop')
		} else if (workPhaseRec.work_phase_state === rec.constant.phase_state.setup) {
			setState('stop')
		} else if (workPhaseRec.work_phase_state === rec.constant.phase_state.working) {
			setState('stop')
		} else if (workPhaseRec.work_phase_state === rec.constant.phase_state.stop) {
			setState('stop')
		} else {
			message.setError(state, `unknown person state ${rowRec.work_phase_state}, ${rec.person_state}`)
			setState('play')
		}
		if (workPhaseRec.production_order_id === rec.constant.unproductive_id) {
			rec.person_state = rec.constant.unproductive_id
			rec.person_state_icon =
				arr.person_state_unproductive.find(item => item.value === rowRec.work_phase_state)?.icon ||
				arr.person_state_unproductive_button.find(item => item.value === rowRec.work_phase_state)?.icon
		}
		setDefaultToCurrent(rowRec)
		setField('time_info', rowRec)
		setField('amount_info', rowRec)
		setField('work_info', rowRec)
		setField('started_info', rec.current.calc)
		setPersonStateToCurrent(workPhaseRec)
		if (workPhaseRec.started_amount > 0) {
			rec.current.started_amount = rowRec.started_amount
		}
		rec.current.virtual = rec.current.production_order_id.startsWith(rec.constant.virtual_production_order_prefix)
		rec.current.can_start = rec.constant.production_order_state_can_start[rec.current.pro.production_order_state]
		rec.current.can_run = rec.current.started_amount >= rec.min_start_amount
		if (!rec.person || rec.selected_work_row < 1) {
			rec.current.can_start = false
			rec.current.can_run = false
		}
		rec.current.can_setup = rec.current.can_run
		if (rec.person_state === '') {
			rec.current.can_run = false
			rec.current.can_setup = false
		}
	}
}
