// /src/components/nc-define/nc-layout/nc-layout-methods-sortable.js

import { nc } from '/assets/nc-plugin.js'

let updateCallback = null
let clickCallback = null

/*
function addNode(newNode, newIndex, droppedNode) {
	if (newNode == null) {
		alert('newNode is null')
	} else {
		if (newNode.attribute.style) {
			delete newNode.attribute.style
		}
		droppedNode.element.splice(newIndex, 0, newNode) // add new node to element array, MUST use splice for Vue reactivity
	}
	updateCallback()
} */

function getVueElementDepth(vueElement, rootVue, depth) {
	if (vueElement == null || vueElement.parent === rootVue) {
		return depth
	} else {
		return getVueElementDepth(vueElement.parent, rootVue, depth + 1)
	}
}

export function ncDragSetCallback(updateCallb, clickCallb) {
	updateCallback = updateCallb
	clickCallback = clickCallb
	updateCallback()
}

export const defineMethods = {
	// Vue methods
	isNcElement(node) {
		if (node.text != null || node.component.substring(0, 3) !== 'nc-') {
			return false
		}
		return true
	},
	onClick(event) {
		event.preventDefault() // this will prevent button click to submit page
		event.stopPropagation()
		const el = (event.item && event.item.__vue__) || event.target.__vue__ || event.target.parentNode.__vue__
		const component = el && el.ncNode && el.ncNode.component
		console.debug(`ncOnClick: '${(component || 'unknown') + ' ' + event.target.id}'`, event)
		if (el != null) {
			clickCallback(component, event.target.id)
		} else {
			debugger
		}
	},
	// sortable multiselect methods
	onSelect(event) {
		console.debug('onSelect', event)
	},
	onDeselect(event) {
		console.debug('onDeselect', event)
	},
	// normal sortable methods
	setData(event) {
		console.debug('setData', event)
	},
	onChoose(event) {
		console.debug('onChoose', event)
		defineMethods.onClick(event)
	},
	onUnchoose(event) {
		console.debug('onUnchoose', event)
	},
	onStart(event) {
		console.debug('onStart', event)
	},
	onEnd(event) {
		console.debug('onEnd', event)
	},
	onUpdate(event) {
		console.debug('onUpdate', event)
	},
	onSort(event) {
		console.debug('onSort', event)
	},
	onRemove(event) {
		console.debug('onRemove', event)
	},
	onFilter(event) {
		console.debug('onFilter', event)
	},
	onMove(event) {
		/* tried in: nc-sortable.js - did not work
		if (options.group && el.__vue__ && el.__vue__._name === '<NcRow>' && el.classList.contains('nc-droppable')) {
			console.debug(' - options changed to row', options.group.put)
			options.group.name = 'row'
			options.group.put = ['style', 'element']
		}
		*/
		if ((nc.isMac() ? event.originalEvent.metaKey : event.originalEvent.ctrlKey) === true) {
			console.debug('onMove - move override with command/control key')
			return true
		}
		console.debug('onMove', event)
		if (event.dragged.classList.contains('nc-row') && event.to.classList.contains('nc-row')) {
			console.debug('onMove - move denied from row to row')
			return false
		} else if (event.dragged.classList.contains('nc-col') && event.to.classList.contains('nc-col')) {
			console.debug('onMove - move denied from col to col')
			return false
		} else {
			// note: how many levels up should we test for depth? give both elements to getVueElementDepth as param?
			debugger // use ncNode and ncParent?
			if (event.dragged.__vueParentComponent.parent !== event.to.__vueParentComponent.parent) {
				// skip same level test
				const draggedDepth = getVueElementDepth(event.dragged.__vueParentComponent.parent, event.dragged.__vueParentComponent.$root, 0)
				const toDepth = getVueElementDepth(event.to.__vueParentComponent.parent, event.dragged.__vueParentComponent.$root, 0)
				/* old: if (event.dragged.__vue__.parent !== event.to.__vue__.parent) {
				// skip same level test
				const draggedDepth = getVueElementDepth(event.dragged.__vue__.parent, event.dragged.__vue__.$root, 0)
				const toDepth = getVueElementDepth(event.to.__vue__.parent, event.dragged.__vue__.$root, 0) */
				if (draggedDepth < toDepth) {
					return false
				}
			}
		}
		return true
	},
	onClone(event) {
		console.debug('onClone', event)
		// event.item.removeAttribute('style') // clone stays in old place, item is the moved one
	},

	onChange(event) {
		// console.debug('onChange', event) // too much calls
	}
}
