// /src/components/nc-define/nc-layout/nc-layout-drag-drop.js

import { isContainer, getVueElementDepth } from '/plugin/nc-layout-editor/nc-layout-editor-util.js'
import { _ as nc } from '/assets/nc-plugin.js'

let lastMessage = null

function debug(msg) {
	if (lastMessage != msg) {
		console.debug(msg)
		lastMessage = msg
	}
}

function dragStart(dragItem) {
	// (dragItem, event)
	// console.debug('dragStart', dragItem, event)
	dragItem.classList.add('nc-drag')
}

function allowDrop(dropTarget, dragItem, event) {
	if ((nc.isMac() ? event.metaKey : event.ctrlKey) === true) {
		debug('allowDrop - move override with command/control key')
		return true
	} else if (dragItem.classList.contains('nc-row') && dropTarget.classList.contains('nc-row')) {
		debug('allowDrop - move denied from row to row')
		return false
	} else if (dragItem.classList.contains('nc-col') && dropTarget.classList.contains('nc-col')) {
		debug('allowDrop - move denied from col to col')
		return false
	} else if (!isContainer(dropTarget?.props?.ncNode || dropTarget?.__vnode?.props?.ncNode)) {
		debug('allowDrop - move denied to non-container')
		return false
	} else {
		// we could use ncNode.__vnode.props.ncElem.props.ncNode and .ncParent, but it's too complicated and error prone compared to this simple solution
		if (dragItem.__vueParentComponent.parent !== dropTarget.__vueParentComponent.parent) {
			// skip same level test
			const draggedDepth = getVueElementDepth(dragItem.__vueParentComponent.parent, dragItem.__vueParentComponent.root, 0)
			const toDepth = getVueElementDepth(dropTarget.__vueParentComponent.parent, dragItem.__vueParentComponent.root, 0)
			if (draggedDepth < toDepth) {
				debug('allowDrop - move denied, draggedDepth < toDepth')
				return false
			}
		}
	}
	return true
}

function dropOver(dropTarget, dragItem, event) {
	// console.debug('dropOver', event)
	/* // keep the dragged position in the data-x/data-y attributes
	var x = (parseFloat(dropTarget.getAttribute('data-x')) || 0) + event.dx
	var y = (parseFloat(dropTarget.getAttribute('data-y')) || 0) + event.dy
	// translate the element
	dropTarget.style.webkitTransform = dropTarget.style.transform = 'translate(' + x + 'px, ' + y + 'px)'
	// update the position attributes
	dropTarget.setAttribute('data-x', x)
	dropTarget.setAttribute('data-y', y) */
	if (allowDrop(dropTarget, dragItem, event)) {
		dropTarget.classList.remove('nc-deny-drop')
		dropTarget.classList.add('nc-allow-drop')
		return true
	}
	dropTarget.classList.remove('nc-allow-drop')
	dropTarget.classList.add('nc-deny-drop')
	return false

	/* old JukkaR
	let distances = []
	let distancesElements = []

	elementCoords.forEach((c, i) => {
		for (let index = 0; index < c.length / 2; index++) {
			let distance = Math.hypot(
				c[0 + index * 2] - parseInt(event.clientX),
				c[1 + index * 2] - parseInt(event.clientY)
			)
			distances.push(parseInt(distance))
			distancesElements.push(i)
		}
	})

	let closestElementIndex = distancesElements[distances.indexOf(Math.min(...distances))]

	if (prevElement !== elements[closestElementIndex]) {
		if (prevElement !== undefined) prevElement.classList.remove('drop-target-active')
		prevElement = elements[closestElementIndex]
		prevElement.classList.add('drop-target-active')
	}
	// console.debug(prevElement)
	this.moved = true
	// const x = this.interactPosition.x + event.dx
	// const y = this.interactPosition.y + event.dy
	const x = event.clientX
	const y = event.clientY
	this.interactSetPosition({ x, y }) */
}

function dropLeave(dropTarget) {
	// (dropTarget, dragItem, event)
	// state.event = 'drag:end'
	// console.debug('dropLeave', dropTarget, dragItem, event)
	dropTarget.classList.remove('nc-allow-drop')
	dropTarget.classList.remove('nc-deny-drop')
	dropTarget.classList.remove('nc-drag')
	/* this.resetCardPosition()
	// this.dragging = false

	if (prevElement !== undefined) {
		console.debug(elements, elementCoords)
		// newArr.splice(newIndex, 0, oldArr.splice(oldIndex, 1)[0])

		prevElement.parentNode.__vue__.content.element.splice(
			prevElement.dataset.index,
			0,
			this.parentContent.element.splice(this.parentContent.element.indexOf(this.content), 1)[0]
		)
		prevElement.classList.remove('drop-target-active')
	} */
}

export const dragOptions = {
	allowFrom: '.nc-container, .nc-element',
	dragStart: dragStart,
	dropEnter: dropOver,
	dropOver: dropOver,
	dropLeave: dropLeave
}
