// /Volumes/nc/nc-frontend/eslint.config.js

// plugins
import html from 'eslint-plugin-html'
import json from 'eslint-plugin-json'
import prettier from 'eslint-plugin-prettier'
import prettierVue from 'eslint-plugin-prettier-vue'
import vue from 'eslint-plugin-vue'
import vuePug from 'eslint-plugin-vue-pug'
import codeCept from 'eslint-plugin-codeceptjs'
// parsers
import vueParser from 'vue-eslint-parser'
// configs
import eslintConfigJs from '@eslint/js'
import eslintConfigPrettier from 'eslint-config-prettier'
import globals from 'globals'

const ignores = [
	'dist/',
	'nc/',
	'src/lib/fomantic-ui/',
	'src/lib/vue.runtime.esm-browser.prod.js',
	'public/umami.js',
	'public/pdf-viewer/build/pdf.js',
	'public/pdf-viewer/web/viewer-nc.js',
	'public/pdf-viewer/build/pdf.worker.js',
	'public/pdf-viewer/build/pdf.worker-es6.min.js',
	'src/components/nc-pdf/pdf-es6.cjs',
	'src/components/nc-pdf/pdf.worker-es6.min.js',
	'other/convert-to-script-setup/index.js'
]

const vueConst = [
	// nc
	'nc',
	'dt',
	'peg',
	'message',
	'state',
	'rec',
	'arr',
	'hdr',
	// lifecycle
	'onActivated',
	'onBeforeMount',
	'onBeforeUnmount',
	'onBeforeUpdate',
	'onMounted',
	'onUnmounted',
	'onUpdated',
	// reactivity,
	'computed',
	'customRef',
	'isReadonly',
	'isRef',
	'markRaw',
	'reactive',
	'readonly',
	'ref',
	'shallowReactive',
	'shallowReadonly',
	'shallowRef',
	'triggerRef',
	'toRaw',
	'toRef',
	'toRefs',
	'unref',
	'watch',
	'watchEffect',
	'defineOptions', // <script> options in <script setup>
	// component
	'defineComponent',
	'defineAsyncComponent',
	'getCurrentScope',
	'onScopeDispose',
	'getCurrentInstance',
	'h',
	'inject',
	'nextTick',
	'provide',
	'useCssModule',
	'createApp',
	// vue3 only
	'onDeactivated',
	'onServerPrefetch',
	'onErrorCaptured',
	'onRenderTracked',
	'onRenderTriggered',
	'useAttrs',
	'useSlots',
	'resolveDirective',
	// vue 3 compiler-only
	'defineProps',
	'defineEmits',
	'defineExpose',
	// echarts theme
	'define'
]
const vueGlobal = vueConst.reduce((map, key) => {
	map[key] = 'readonly'
	return map
}, {})

const glob = {
	...vueGlobal,
	...globals.serviceworker,
	...globals.node,
	...globals.browser
	// ...globals.es2021,
	// ...globals.es5
}

export default [
	eslintConfigJs.configs.recommended,
	eslintConfigPrettier,
	{
		languageOptions: {
			parser: vueParser,
			ecmaVersion: 'latest',
			sourceType: 'module',
			globals: glob
		},
		plugins: {
			html: html,
			json: json,
			prettier,
			prettierVue,
			vue,
			vuePug,
			codeCept
		},
		rules: {
			'prettier/prettier': 'error',
			semi: ['error', 'never'],
			'spaced-comment': ['error', 'always'],
			'vue/html-self-closing': [
				'error',
				{
					html: {
						void: 'any',
						normal: 'any',
						component: 'any'
					},
					svg: 'always',
					math: 'always'
				}
			],
			'vue/singleline-html-element-content-newline': 'off',
			'no-debugger': 'off',
			'vue/html-indent': ['error', 'tab'],
			'vue/first-attribute-linebreak': [
				'error',
				{
					singleline: 'ignore',
					multiline: 'ignore'
				}
			],
			'vue/max-attributes-per-line': [
				'error',
				{
					singleline: {
						max: 9
					},
					multiline: {
						max: 4
					}
				}
			],
			'vue/component-definition-name-casing': 'off',
			'vue/component-tags-order': [
				'error',
				{
					order: [['template', 'script', 'style']]
				}
			],
			'vue/no-unused-vars': [
				'error',
				{
					ignorePattern: '^_'
				}
			]
		}
	},
	{
		ignores: ignores // https://github.com/eslint/eslint/issues/17400
	}
]
